#!/bin/sh

test -f /usr/share/acpi-support/key-constants || exit 0

BRIGHTNESS=$(( `grep brightness: /proc/acpi/toshiba/lcd | cut -d: -f2` + 0 ))
MAXBRIGHT=$(( `grep brightness_levels: /proc/acpi/toshiba/lcd | cut -d: -f2` - 1 ))

if [ "x$1" = "x" ]; then
   echo $BRIGHTNESS / $MAXBRIGHT
elif [ "x$1" = "xdown" ]; then
   if [ "x$BRIGHTNESS" != "x0" ]; then
      BRIGHTNESS=$(( $BRIGHTNESS - 1 ))
      echo 'brightness : '$BRIGHTNESS > /proc/acpi/toshiba/lcd
   fi
elif [ "x$1" = "xup" ]; then
   if [ "x$BRIGHTNESS" != "x$MAXBRIGHT" ]; then
      BRIGHTNESS=$(( $BRIGHTNESS + 1 ))
      echo 'brightness : '$BRIGHTNESS > /proc/acpi/toshiba/lcd
   fi
else
   echo >&2 Unknown argument $1
fi
