#!/bin/bash
# INIT script to check whether we're on batteries, and so start with laptop 
# mode etc enabled.

# BUGS: unless we start *really* late, we have no way of throttling 
# xscreensaver, since it won't be there to command.
. /usr/share/acpi-support/power-funcs

test -f /lib/lsb/init-functions || exit 1
. /lib/lsb/init-functions

test -d /var/lib/acpi-support || exit 0

shopt -s nullglob

case "$1" in
  start)
    log_begin_msg "Checking battery state..."
    if [ `echo /proc/acpi/ac_adapter/*` ]; then 
	/etc/acpi/power.sh
    fi
    # Source everything in /etc/acpi/start.d/
    for SCRIPT in /etc/acpi/start.d/*.sh; do
	. $SCRIPT
    done
    log_end_msg 0
    ;;
  stop)
    log_begin_msg "Disabling power management..."
    if [ `echo /proc/acpi/ac_adapter/*` ]; then
	/etc/acpi/power.sh stop
    fi
    log_end_msg 0
    ;;
  *)
  ;;
esac
        

