#include <kprogress.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klocale.h>
#include "acqprogresswidget.h"
#include "acqprogress.h"

using namespace adept;

AcqProgressWidget::AcqProgressWidget( QWidget *parent, const char *name )
    : AcqProgressWidgetUi( parent, name )
{
    m_statusRef = m_status;
    m_progress->setTotalSteps( 100 );
    m_progress->setProgress( 0 );
    connect(m_status, SIGNAL( totalProgress( int ) ),
             this, SLOT( setProgress( int ) ) );
    connect(m_status, SIGNAL( statusChanged( AcqStatus::Status ) ),
            this, SLOT( statusChange( AcqStatus::Status ) ) );
    connect( m_cancel, SIGNAL( clicked() ),
             m_status, SLOT( cancel() ) );
}

void AcqProgressWidget::statusChange( AcqStatus::Status s )
{
    QString t;
    switch (s) {
        case AcqStatus::StWaiting:
            t = i18n( "Waiting for headers (%p%)" );
            break;
        case AcqStatus::StDownloading:
            t = i18n( "Downloading (%p%)" );
            break;
        case AcqStatus::StDone:
            t = i18n( "Done (%p%)" );
            m_progress->setProgress( 100 );
            break;
    }
    m_progress->setFormat( t );
}

void AcqProgressWidget::setProgress( int p )
{
    if (p < 0) {
        m_progress->setTotalSteps( 0 );
        m_progress->setProgress( m_progress->progress() + 1 );
    } else {
        m_progress->setTotalSteps( 100 );
        m_progress->setProgress( p );
    }
}

#include "acqprogresswidget.moc"
