// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>

#include <ept/core/apt.h>
#include <ept/core/xapian.h>
#include <ept/core/apt/action.h>

#include <adept/extendablelist.h>
#include <adept/util.h>
#include <adept/packageinfo.h>

// for setupList
#include <adept/tokenmodel.h>
#include <QtGui/QHeaderView>


#include <QtGui/QLabel>
#include <QtGui/QLayout>
#include <QtGui/QItemDelegate>
#include <QtGui/QPainter>
#include <QtGui/QPalette>
#include <QtGui/QCheckBox>
#include <QtGui/QPixmapCache>

#include <KIcon>
#include <klocale.h>
#include <kvbox.h>

#ifndef ADEPT_PACKAGELIST_H
#define ADEPT_PACKAGELIST_H

namespace adept {

using namespace ept::core;

class PackageExtender : public PackageInfo {
    Q_OBJECT

protected:
    QLabel *m_info, *m_desc;
    QWidget *m_box, *m_actBox;
    QVBoxLayout *m_layout;

public:

    // TODO code duplication
    int iconSize() const;

    /* Arbitrary, but small -- this is the minimum we'll get from the view, it
       seems. Our heightForWidth will take care of getting actual useful
       dimensions, through expandedSizeHint in ExtendingDelegate. */
    virtual QSize sizeHint() const {
        return QSize(100, 20);
    }

    PackageExtender( PackageData  &_d, ept::Token _t,
                     QWidget *parent = 0 );

public Q_SLOTS:
    virtual void refresh();
Q_SIGNALS:
    void detailsRequested();
};

/**
 * @class PackageDelegate
 * Delegate that renders the description and status of a package
 * in an extendable list */
class PackageDelegate : public adept::ExtendingDelegate {
    Q_OBJECT

protected:
    PackageData &d;

Q_SIGNALS:
    void changed();
    void externallyChanged();
    void detailsRequested( ept::Token );
public Q_SLOTS:
    void requestDetails();

public:
    ept::Token token( const QModelIndex &idx ) const {
        return idx.data( Qt::UserRole + 1 ).value< ept::Token >();
    }

    void refresh() {
        externallyChanged();
    }

    virtual QWidget *createEditorWidget( QWidget *parent,
                                         const QStyleOptionViewItem &,
                                         const QModelIndex &idx ) const;

    int iconSize( const QStyleOptionViewItem &opt,
                  const QModelIndex &idx ) const;

    /** @param opt Parameters used to draw an item in a view widget.
     *  @param idx The model index of the item (not used). */
    virtual QSize retractedSizeHint( const QStyleOptionViewItem &opt,
                                     const QModelIndex & ) const;

    /** Paints the short/retracted package description */
    virtual void paint( QPainter *p, const QStyleOptionViewItem &_opt,
                        const QModelIndex &idx ) const;

    PackageDelegate( PackageData &_d ) : d( _d )
    {
    }
};

class PackageListView : public ExtendableListView {
    Q_OBJECT
    
public:
    PackageListView ( PackageDelegate *delegate, QWidget *parent = 0 )
        : ExtendableListView( delegate, parent ) {
        connect( this, SIGNAL( clicked( const QModelIndex & )),
            this, SLOT(clicked( const QModelIndex & )));
        connect( delegate, SIGNAL( detailsRequested( ept::Token ) ),
                 this, SIGNAL( selected( ept::Token ) ) );
    }
    
    ept::Token token( const QModelIndex &idx ) const {
        return idx.data( Qt::UserRole + 1 ).value< ept::Token >();
    }
    
protected Q_SLOTS:
    void clicked( const QModelIndex &idx ) {
        emit selected(token(idx));
    }
    
Q_SIGNALS:
    void selected(ept::Token);
};

PackageListView *setupList( QObject *obj, QWidget *p,
                            TokenModel *m, PackageData &d );

}

#endif
