# -*- coding: utf-8 -*-
#   Alacarte Menu Editor - Simple fd.o Compliant Menu Editor
#   Copyright (C) 2005  Travis Watkins
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Library General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, cgi, thread
import pygtk
pygtk.require('2.0')
import gtk, gtk.glade, gnome, gnome.ui, gobject
try:
	import gnomevfs
except:
	import gnome.vfs as gnomevfs
import gettext
gettext.bindtextdomain('alacarte')
gettext.textdomain('alacarte')
gtk.glade.bindtextdomain('alacarte')
gtk.glade.textdomain('alacarte')
_ = gettext.gettext
import Alacarte
from Alacarte.PyXDGMenuHandler import MenuItem, MenuHandler
from Alacarte.PyXDGIconHandler import IconHandler
from Alacarte.GnomeDialogHandler import DialogHandler
from Alacarte.config import *

class GnomeFront(object):
	tree = None
	file_path = os.path.split(Alacarte.__file__)[0]
	dnd_dest = [
		('MY_TREE_MODEL_ROW', gtk.TARGET_SAME_APP, 0), ('text/plain', 0, 1)
		]
	dnd_src = [('MY_TREE_MODEL_ROW', gtk.TARGET_SAME_APP, 0)]
	menu_path = None
	entry_path = None
	app_handler = None
	sys_handler = None
	options = {}

	def __init__(self):
		gnome.init('alacarte', ALACARTE_VERSION)
		self.tree = gtk.glade.XML(
			os.path.join(self.file_path, 'alacarte.glade')
			)
		self.tree.get_widget('editproperties').set_sensitive(False)
		self.tree.get_widget('editrevert').set_sensitive(False)
		self.tree.get_widget('editdelete').set_sensitive(False)
		self.tree.get_widget('entryup').set_sensitive(False)
		self.tree.get_widget('entrydown').set_sensitive(False)
		self.options = {'desktop_environment': 'GNOME', 'root_mode': False}
		self.icon_handler = IconHandler(self.options)
		signals = {}
		for attr in dir(self):
			signals[attr] = getattr(self, attr)
		self.tree.signal_autoconnect(signals)
		self.setIcon()
		self.dialogs = DialogHandler(self.tree, self.icon)
		self.setupEntriesTree()
		self.setupMenusTree()
		self.loadMenus()
		gnome.ui.authentication_manager_init()
		self.tree.get_widget('mainwindow').show()
		gtk.main()

	def getIcon(self, icon, itemType=ALACARTE_IS_ENTRY, size=24):
		path = self.icon_handler.getIconPath(icon, itemType, size)
		if path == None:
			pb = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, size, size)
			pb.fill(0x00000000)
		else:
			try:
				pb = gtk.gdk.pixbuf_new_from_file_at_size(path, size, size)
			except:
				pb = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, size, size)
				pb.fill(0x00000000)
		return path, pb

	def setIcon(self):
		self.icon = self.getIcon('gnome-logo-icon-transparent')[1]
		self.tree.get_widget('mainwindow').set_icon(self.icon)

	def setupMenusTree(self):
		menus = self.tree.get_widget('menus')
		column = gtk.TreeViewColumn(_('Name'))
		column.set_spacing(4)
		cell = gtk.CellRendererPixbuf()
		column.pack_start(cell, False)
		column.set_attributes(cell, pixbuf=0)
		cell = gtk.CellRendererText()
		cell.set_fixed_size(-1, 25)
		column.pack_start(cell, True)
		column.set_attributes(cell, markup=1)
		menus.append_column(column)
		menus.set_expander_column(column)
		menus.enable_model_drag_dest(self.dnd_dest, gtk.gdk.ACTION_PRIVATE)
		menus.enable_model_drag_source(gtk.gdk.BUTTON1_MASK, self.dnd_src,
			gtk.gdk.ACTION_MOVE | gtk.gdk.ACTION_DEFAULT
			)
		_('Loading...')
		menus.connect(
			'drag_data_received', self.on_menus_drag_data_received_data
			)
		menus.connect('drag_data_get', self.on_menus_drag_data_get_data)

	def setupEntriesTree(self):
		entries = self.tree.get_widget('entries')
		column = gtk.TreeViewColumn(_('Visible'))
		cell = gtk.CellRendererToggle()
		cell.connect('toggled', self.on_entry_visible_toggled)
		column.pack_start(cell, True)
		column.set_attributes(cell, active=0)
		entries.append_column(column)
		column = gtk.TreeViewColumn(_('Name'))
		column.set_spacing(4)
		cell = gtk.CellRendererPixbuf()
		column.pack_start(cell, False)
		column.set_attributes(cell, pixbuf=1)
		cell = gtk.CellRendererText()
		cell.set_fixed_size(-1, 25)
		column.pack_start(cell, True)
		column.set_attributes(cell, markup=2)
		entries.append_column(column)
		entry_store = gtk.ListStore(bool, gtk.gdk.Pixbuf, str, object, object)
		entries.set_model(entry_store)
		entries.enable_model_drag_dest(self.dnd_dest, gtk.gdk.ACTION_DEFAULT)
		entries.enable_model_drag_source(
			gtk.gdk.BUTTON1_MASK, self.dnd_src,
			gtk.gdk.ACTION_DEFAULT | gtk.gdk.ACTION_MOVE
			)
		entries.connect(
			'drag_data_received', self.on_entries_drag_data_received_data
			)
		entries.connect('drag_data_get', self.on_entries_drag_data_get_data)

	def getEntries(self, path):
		entries = gtk.ListStore(bool, gtk.gdk.Pixbuf, str, object, object)
		menus = self.tree.get_widget('menus').get_model()
		parent = menus[path][2]
		for child in parent.getChildren():
			name = cgi.escape(child.getKey('Name'))
			show = child.isVisible()
			if show != True:
				name = '<small><i>' + name + '</i></small>'
			iconPath, icon = self.getIcon(child.getKey('Icon'), child.itemType)
			child.iconPath = iconPath
			entries.append((
				show, icon, name,
				child, path
				))
		menus[path][3] = entries
		return entries

	def loadMenu(self, parent, depth=0):
		if depth == 0:
			iconPath, icon = self.getIcon(
				parent.getKey('Icon'), parent.itemType
				)
			parent.iconPath = iconPath
			self.parents[depth] = self.menu_store.append(None, (
				icon, cgi.escape(parent.getKey('Name')), parent, None, None
				)
			)
		depth += 1
		for child in parent.getChildren():
			if child.itemType == ALACARTE_IS_MENU:
				name = cgi.escape(child.getKey('Name'))
				show = child.isVisible()
				if show != True:
					name = '<small><i>' + name + '</i></small>'
				parentPath = None
				if self.parents[depth-1] != None:
					parentPath = self.menu_store.get_path(self.parents[depth-1])
				iconPath, icon = self.getIcon(
					child.getKey('Icon'), child.itemType
					)
				child.iconPath = iconPath
				self.parents[depth] = self.menu_store.append(
					self.parents[depth-1], (icon, name, child, None, parentPath)
					)
				self.loadMenu(child, depth)
		depth -= 1

	def loadMenus(self, oldExpand=None):
		self.menu_store = gtk.TreeStore(
			gtk.gdk.Pixbuf, str, object, object, object
			)
		self.parents = [None]*20
		if self.app_handler == None:
			self.app_handler = MenuHandler('applications.menu', self.options)
		self.loadMenu(self.app_handler.root)
		self.parents = [None]*20
		if self.sys_handler == None:
			self.sys_handler = MenuHandler('settings.menu', self.options)
		self.loadMenu(self.sys_handler.root)
		menus = self.tree.get_widget('menus')
		menus.set_model(self.menu_store)
		for menu in self.menu_store:
			self.tree.get_widget('menus').expand_to_path(menu.path)
		if oldExpand:
			menus.expand_to_path(oldExpand)
			menus.expand_to_path(self.menu_path)
			menus.get_selection().select_path(self.menu_path)
			gobject.idle_add(
				self.on_menus_cursor_changed, menus, self.entry_path
				)
		return False

	#here there be monsters
	def updateVisibility(self):
		def updateEntry():
			model = self.tree.get_widget('entries').get_model()
			item = model[self.entry_path][3]
			name = cgi.escape(item.getKey('Name'))
			if item.isVisible():
				if item.itemType == ALACARTE_IS_MENU:
					menus = self.tree.get_widget('menus').get_model()
					iter = menus.iter_children(menus.get_iter(self.menu_path))
					while True:
						childRow = menus[menus.get_path(iter)]
						if childRow[2] == item:
							childRow[1] = name
						iter = menus.iter_next(iter)
						if iter == None:
							break
				model[self.entry_path][2] = name
				model[self.entry_path][0] = True
			else:
				if item.itemType == ALACARTE_IS_MENU:
					menus = self.tree.get_widget('menus').get_model()
					iter = menus.iter_children(menus.get_iter(self.menu_path))
					while True:
						childRow = menus[menus.get_path(iter)]
						if childRow[2] == item:
							childRow[1] = '<small><i>' + name + '</i></small>'
						iter = menus.iter_next(iter)
						if iter == None:
							break
				model[self.entry_path][2] = '<small><i>' + name + '</i></small>'
				model[self.entry_path][0] = False

		if not self.entry_path:
			entryTree = self.tree.get_widget('entries')
			model, iter = entryTree.get_selection().get_selected()
			if iter:
				self.entry_path = model.get_path(iter)
				updateEntry()
		else:
			updateEntry()
		parent_path = self.menu_path
		while parent_path != None:
			row = self.tree.get_widget('menus').get_model()[parent_path]
			item = row[2]
			name = cgi.escape(item.getKey('Name'))
			parent_path = row[4]
			if item.isVisible():
				row[1] = name
				if parent_path != None:
					row = self.tree.get_widget('menus').get_model()[parent_path]
					if row[3] == None:
						self.getEntries(parent_path)
					for row2 in row[3]:
						if item == row2[3]:
							row2[2] = name
							row2[0] = True
			else:
				row[1] = '<small><i>' + name + '</i></small>'
				if parent_path != None:
					row = self.tree.get_widget('menus').get_model()[parent_path]
					if row[3] == None:
						self.getEntries(parent_path)
					for row2 in row[3]:
						if item == row2[3]:
							row2[2] = '<small><i>' + name + '</i></small>'
							row2[0] = False
		return False

	def setAllowed(self, item):
		self.tree.get_widget('editdelete').set_sensitive(False)
		self.tree.get_widget('editrevert').set_sensitive(False)
		self.tree.get_widget('editproperties').set_sensitive(True)
		if item.fileType == ALACARTE_IS_LOCKED:
			self.tree.get_widget('editproperties').set_sensitive(False)
			return
		if item.itemType == ALACARTE_IS_SEPARATOR:
			self.tree.get_widget('editdelete').set_sensitive(True)
			self.tree.get_widget('editproperties').set_sensitive(False)
			return
		if item.fileType == ALACARTE_IS_SYSTEM:
			return
		elif item.fileType == ALACARTE_IS_SYSTEM_WITH_LOCAL:
			self.tree.get_widget('editrevert').set_sensitive(True)
		elif item.fileType == ALACARTE_IS_LOCAL:
			self.tree.get_widget('editdelete').set_sensitive(True)

	def getHandler(self):
		entries = self.tree.get_widget('entries').get_model()
		menus = self.tree.get_widget('menus').get_model()
		if self.entry_path:
			path = entries[self.entry_path][4]
		elif self.menu_path:
			path = self.menu_path
		else:
			return self.app_handler
		if path[0] == 0:
			return self.app_handler
		return self.sys_handler

	def save(self):
		self.app_handler.save()
		self.sys_handler.save()

	#menu callbacks
	def on_filenewentry_activate(self, menu):
		entries = self.tree.get_widget('entries').get_model()
		menus = self.tree.get_widget('menus').get_model()
		handler = self.getHandler()
		parentPath = None
		if self.entry_path:
			parentPath = entries[self.entry_path][4]
			parent = menus[parentPath][2]
		elif self.menu_path:
			parentPath = self.menu_path
			parent = menus[self.menu_path][2]
		else:
			parentPath = (0,)
			parent = handler.root
		name, comment, command, icon, term = self.dialogs.newEntryDialog()
		if name == None:
			return
		item = handler.newEntry(
			parent, name, command, comment, icon, term, None, None
			)
		self.menu_path = parentPath
		gobject.idle_add(self.loadMenus, self.menu_path)
		self.save()

	def on_filenewmenu_activate(self, menu):
		entries = self.tree.get_widget('entries').get_model()
		menus = self.tree.get_widget('menus').get_model()
		handler = self.getHandler()
		parentPath = None
		if self.entry_path:
			parentPath = entries[self.entry_path][4]
			parent = menus[parentPath][2]
		elif self.menu_path:
			parentPath = self.menu_path
			parent = menus[self.menu_path][2]
		else:
			parentPath = (0,)
			parent = handler.root
		name, comment, icon = self.dialogs.newMenuDialog()
		if name == None:
			return
		item = handler.newMenu(parent, name, comment, icon, None, None)
		self.menu_path = parentPath
		gobject.idle_add(self.loadMenus, self.menu_path)
		self.save()

	def on_filenewseparator_activate(self, menu):
		if not self.entry_path:
			return False
		entries = self.tree.get_widget('entries').get_model()
		menus = self.tree.get_widget('menus').get_model()
		handler = self.getHandler()
		parentPath = entries[self.entry_path][4]
		parent = menus[parentPath][2]
		after = entries[self.entry_path][3]
		item = handler.newSeparator(parent, None, after)
		self.menu_path = parentPath
		self.entry_path = (self.entry_path[0] + 1,)
		gobject.idle_add(self.loadMenus, self.menu_path)
		self.save()

	def on_filequit_activate(self, menu):
		gtk.main_quit()

	def on_editdelete_activate(self, menu):
		if self.entry_path:
			model = self.tree.get_widget('entries').get_model()
			path = self.entry_path
			item = model[path][3]
		elif self.menu_path:
			model = self.tree.get_widget('menus').get_model()
			path = self.menu_path
			item = model[path][2]
		else:
			return False
		if item.delete():
			model.remove(model.get_iter(path))
		self.save()

	def on_editrevert_activate(self, menu):
		if self.entry_path:
			model = self.tree.get_widget('entries').get_model()
			item = model[self.entry_path][3]
		elif self.menu_path:
			model = self.tree.get_widget('menus').get_model()
			item = model[self.menu_path][2]
		else:
			return False
		if item.revert():
			gobject.idle_add(self.loadMenus, self.menu_path)
		self.save()

	def on_editproperties_activate(self, menu):
		menus = self.tree.get_widget('menus').get_model()
		entries = self.tree.get_widget('entries').get_model()
		if self.entry_path:
			item = entries[self.entry_path][3]
		elif self.menu_path:
			model = self.tree.get_widget('menus').get_model()
			item = menus[self.menu_path][2]
		if item.itemType == ALACARTE_IS_MENU:
			self.dialogs.editMenuDialog(item)
			if self.entry_path:
				path = self.entry_path
				gobject.idle_add(self.loadMenus, self.menu_path)
				self.entry_path = path
				entryTree = self.tree.get_widget('entries')
				entryTree.get_selection().select_path(self.entry_path)
			else:
				gobject.idle_add(self.loadMenus, self.menu_path)
		elif item.itemType == ALACARTE_IS_ENTRY:
			self.dialogs.editEntryDialog(item)
			menus[entries[self.entry_path][4]][3] = None
			menuTree = self.tree.get_widget('menus')
			gobject.idle_add(
				self.on_menus_cursor_changed, menuTree, self.entry_path
				)

	def on_helpabout_activate(self, menu):
		about = gtk.AboutDialog()
		about.set_icon(self.icon)
		logoPath = os.path.join(self.file_path, 'images', 'alacarte.svg')
		logoPixbuf = gtk.gdk.pixbuf_new_from_file_at_size(logoPath, 128, 128)
		about.set_logo(logoPixbuf)
		about.set_authors(['Travis Watkins <alleykat@gmail.com>'])
		about.set_translator_credits(_('translator-credits'))
		about.set_copyright('Copyright © 2005 Travis Watkins')
		about.set_name(_('Alacarte Menu Editor'))
		about.set_version(ALACARTE_VERSION)
		about.set_comments(_('Simple fd.o Compliant Menu Editor'))
		about.connect('response', lambda *a: about.destroy())
		about.show()

	#treeview callbacks
	def on_menus_cursor_changed(self, treeview, entryPath = None):
		self.tree.get_widget('filenewseparator').set_sensitive(False)
		model, iter = treeview.get_selection().get_selected()
		self.menu_path = model.get_path(iter)
		if model[self.menu_path][2].fileType == ALACARTE_IS_LOCKED:
			self.tree.get_widget('filenewentry').set_sensitive(False)
			self.tree.get_widget('filenewmenu').set_sensitive(False)
		else:
			self.tree.get_widget('filenewentry').set_sensitive(True)
			self.tree.get_widget('filenewmenu').set_sensitive(True)
		self.entry_path = None
		entries = self.tree.get_widget('entries')
		entries.get_selection().unselect_all()
		entry_model = model.get(iter, 3)[0]
		if entry_model == None:
			entry_model = self.getEntries(model.get_path(iter))
		entries.set_model(entry_model)
		if entryPath:
			self.tree.get_widget('filenewseparator').set_sensitive(True)
			entries.get_selection().select_path(entryPath)
			self.entry_path = entryPath
			self.tree.get_widget('entryup').set_sensitive(True)
			self.tree.get_widget('entrydown').set_sensitive(True)
		else:
			self.tree.get_widget('entryup').set_sensitive(False)
			self.tree.get_widget('entrydown').set_sensitive(False)
		return False

	def on_menus_drag_data_get_data(
		self, treeview, context, selection, target_id, etime
		):
		menus, iter = treeview.get_selection().get_selected()
		row = menus[menus.get_path(iter)]
		self.drag_data = (row[0], row[1], row[2], row[3], row[4])
		selection.set(selection.target, 8, 'menus:::0')

	def on_menus_drag_data_received_data(
		self, treeview, context, x, y, selection, info, etime
		):
		menus = treeview.get_model()
		if selection.target == 'MY_TREE_MODEL_ROW':
			source, source_path = selection.data.split(':::', 1)
			source_path = self.menu_path
			drop_info = treeview.get_dest_row_at_pos(x, y)
			if drop_info:
				path, position = drop_info
				types = (
					gtk.TREE_VIEW_DROP_INTO_OR_BEFORE,
					gtk.TREE_VIEW_DROP_INTO_OR_AFTER
					)
				if position not in types:
					context.finish(False, False, etime)
					return False
				if source == 'entries':
					self.entry_path = None
					item = self.drag_data[3]
					oldparent = menus[self.drag_data[4]][2]
					newparent = menus[path][2]
					if self.drag_data[4][0] != path[0]:
						if item.itemType != ALACARTE_IS_ENTRY:
							context.finish(False, False, etime)
							return False
						oldHandler = self.sys_handler
						newHandler = self.app_handler
						if self.drag_data[4][0] == 0:
							oldHandler = self.app_handler
							newHandler = self.sys_handler
						if newHandler.move(
							oldHandler, oldparent, newparent, item, None, None
							):
							menus[self.drag_data[4]][3] = None
							menus[path][3] = None
							self.updateVisibility()
							self.menu_path = path
							self.updateVisibility()
							treeview.get_selection().select_path(self.menu_path)
							gobject.idle_add(
								self.on_menus_cursor_changed, treeview
								)
							context.finish(True, True, etime)
							return True
					if item.move(oldparent, newparent, None, None):
						menus[self.drag_data[4]][3] = None
						menus[path][3] = None
						self.updateVisibility()
						self.menu_path = path
						self.updateVisibility()
						treeview.get_selection().select_path(self.menu_path)
						gobject.idle_add(self.on_menus_cursor_changed, treeview)
					else:
						context.finish(False, False, etime)
						return False
				elif source == 'menus':
					if path == source_path:
						context.finish(False, False, etime)
						return False
					item = self.drag_data[2]
					self.entry_path = None
					if self.drag_data[4][0] != path[0]:
						context.finish(False, False, etime)
						return False
					oldparent = menus[self.drag_data[4]][2]
					newparent = menus[path][2]
					if item.move(oldparent, newparent, None, None):
						if path > source_path:
							self.menu_path = tuple(
								list(path[:-1]) + [path[-1] - 1,]
								)
						else:
							self.menu_path = path
						gobject.idle_add(self.loadMenus, self.drag_data[4])
					else:
						context.finish(False, False, etime)
						return False
		self.save()
		context.finish(True, True, etime)

	def on_menus_button_press_event(self, treeview, event):
		if event.button == 3:
			x = int(event.x)
			y = int(event.y)
			time = event.time
			pathinfo = treeview.get_path_at_pos(x, y)
			if pathinfo != None:
				path, col, cellx, celly = pathinfo
				model = treeview.get_model()
				iter = model.get_iter(path)
				treeview.grab_focus()
				treeview.set_cursor(path, col, 0)
				self.setAllowed(treeview.get_model()[path][2])
				popup = self.tree.get_widget('editmenu_menu')
				popup.popup( None, None, None, event.button, time)
			return 1

	def on_entries_cursor_changed(self, treeview):
		model, iter = treeview.get_selection().get_selected()
		self.entry_path = model.get_path(iter)
		self.tree.get_widget('filenewseparator').set_sensitive(True)
		self.tree.get_widget('entryup').set_sensitive(True)
		self.tree.get_widget('entrydown').set_sensitive(True)

	def on_entries_row_activated(self, treeview, path, column):
		self.on_editproperties_activate(None)

	def on_entry_visible_toggled(self, cell, path):
		model = self.tree.get_widget('entries').get_model()
		self.entry_path = path
		item = model[path][3]
		if item.toggleVisibility():
			self.updateVisibility()
		self.save()

	def on_entries_drag_data_get_data(
		self, treeview, context, selection, target_id, etime
		):
		entries, iter = treeview.get_selection().get_selected()
		row = entries[entries.get_path(iter)]
		self.drag_data = (row[0], row[1], row[2], row[3], row[4])
		selection.set(selection.target, 8, 'entries:::0')

	def on_entries_drag_data_received_data(
		self, treeview, context, x, y, selection, info, etime
		):
		entries = treeview.get_model()
		menus = self.tree.get_widget('menus').get_model()
		handler = self.getHandler()
		types = (gtk.TREE_VIEW_DROP_BEFORE,	gtk.TREE_VIEW_DROP_INTO_OR_BEFORE)
		if selection.target == 'MY_TREE_MODEL_ROW':
			source, source_path = selection.data.split(':::', 1)
			drop_info = treeview.get_dest_row_at_pos(x, y)
			if drop_info:
				path, position = drop_info
				iter = entries.get_iter(path)
				if source == 'entries':
					before = None
					after = None
					if position in types:
						before = entries[path][3]
						self.entry_path = path
						item = self.drag_data[3]
						parent = menus[self.drag_data[4]][2]
						if item.move(parent, parent, before, after):
							entries.insert_before(iter, self.drag_data)
							treeview.get_selection().select_path(
								self.entry_path
								)
					else:
						after = entries[path][3]
						self.entry_path = (path[0] + 1,)
						item = self.drag_data[3]
						parent = menus[self.drag_data[4]][2]
						if item.move(parent, parent, before, after):
							entries.insert_after(iter, self.drag_data)
							treeview.get_selection().select_path(
								self.entry_path
								)
				else:
					context.finish(False, False, etime)
					return False
			else:
				if source == 'entries':
					path = (len(entries) - 1,)
					iter = entries.get_iter(path)
					after = entries[path][3]
					self.entry_path = (path[0] + 1,)
					item = self.drag_data[3]
					parent = menus[self.drag_data[4]][2]
					if item.move(parent, parent, None, after):
						entries.insert_after(iter, self.drag_data)
						treeview.get_selection().select_path(self.entry_path)
				else:
					context.finish(False, False, etime)
					return False
		elif selection.target == 'text/plain':
			file_path = gnomevfs.unescape_string(selection.data, '').strip()
			file_info = gnomevfs.get_file_info(
				file_path, gnomevfs.FILE_INFO_GET_MIME_TYPE|
				gnomevfs.FILE_INFO_FORCE_SLOW_MIME_TYPE|
				gnomevfs.FILE_INFO_FOLLOW_LINKS|gnomevfs.FILE_INFO_DEFAULT
				)
			if file_info.mime_type == 'application/x-desktop':
				handle = gnomevfs.open(file_path)
				data = handle.read(file_info.size)
				drop_info = treeview.get_dest_row_at_pos(x, y)
				before = None
				after = None
				if drop_info:
					path, position = drop_info
					if position in types:
						before = entries[path][3]
						self.entry_path = path
					else:
						after = entries[path][3]
						self.entry_path = (path[0] + 1,)
				else:
					path = (len(entries) - 1,)
					after = entries[path][3]
					self.entry_path = (path[0] + 1,)
				parent = menus[self.menu_path][2]
				item = handler.new(data, parent)
				if item and item.move(parent, parent, before, after):
					entries = self.getEntries(self.menu_path)
					entryTree = self.tree.get_widget('entries')
					entryTree.set_model(entries)
					entryTree.get_selection().select_path(self.entry_path)
		self.save()
		context.finish(True, True, etime)

	def on_entries_button_press_event(self, treeview, event):
		if event.button == 3:
			x = int(event.x)
			y = int(event.y)
			time = event.time
			pathinfo = treeview.get_path_at_pos(x, y)
			if pathinfo != None:
				path, col, cellx, celly = pathinfo
				model = treeview.get_model()
				iter = model.get_iter(path)
				treeview.grab_focus()
				treeview.set_cursor(path, col, 0)
				self.setAllowed(treeview.get_model()[path][3])
				popup = self.tree.get_widget('editmenu_menu')
				popup.popup( None, None, None, event.button, time)
			return 1

	#move button callbacks
	def on_entryup_clicked(self, button):
		if self.entry_path == None or self.entry_path[0] == 0:
			return
		entries = self.tree.get_widget('entries').get_model()
		menus = self.tree.get_widget('menus').get_model()
		item = entries[self.entry_path][3]
		parent = menus[entries[self.entry_path][4]][2]
		before = entries[(self.entry_path[0] - 1,)][3]
		if item.move(parent, parent, before, None):
			menus[entries[self.entry_path][4]][3] = None
			self.entry_path = (self.entry_path[0] - 1,)
			gobject.idle_add(
				self.on_menus_cursor_changed, self.tree.get_widget('menus'),
				self.entry_path
				)
		self.save()

	def on_entrydown_clicked(self, button):
		entries = self.tree.get_widget('entries').get_model()
		if self.entry_path == None or self.entry_path[0] == len(entries) - 1:
			return
		menus = self.tree.get_widget('menus').get_model()
		item = entries[self.entry_path][3]
		parent = menus[entries[self.entry_path][4]][2]
		after = entries[(self.entry_path[0] + 1,)][3]
		if item.move(parent, parent, None, after):
			menus[entries[self.entry_path][4]][3] = None
			self.entry_path = (self.entry_path[0] + 1,)
			gobject.idle_add(
				self.on_menus_cursor_changed, self.tree.get_widget('menus'),
				self.entry_path
				)
		self.save()

	#mainwindow callbacks
	def on_mainwindow_destroy(self, window):
		gtk.main_quit()

	def on_closebutton_clicked(self, button):
		gtk.main_quit()

	def on_revertbutton_clicked(self, button):
		dialog = gtk.MessageDialog(
			self.tree.get_widget('mainwindow'),	gtk.DIALOG_MODAL,
			gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO,
			_('Revert all menus to original settings?')
			)
		if dialog.run() == gtk.RESPONSE_YES:
			dialog.destroy()
			gobject.idle_add(self.app_handler.revert)
			gobject.idle_add(self.sys_handler.revert)
			gobject.idle_add(self.loadMenus)
			self.tree.get_widget('entries').set_model(None)
		dialog.destroy()

	#edit dialog callbacks
	def on_econtents_changed(self, widget):
		menus = self.tree.get_widget('menus').get_model()
		entries = self.tree.get_widget('entries').get_model()
		menus[entries[self.entry_path][4]][3] = None
		menuTree = self.tree.get_widget('menus')
		gobject.idle_add(
			self.on_menus_cursor_changed, menuTree, self.entry_path
			)

	def on_mcontents_changed(self, widget):
		if self.entry_path:
			path = self.entry_path
			gobject.idle_add(self.loadMenus, self.menu_path)
			self.entry_path = path
			menuTree = self.tree.get_widget('menus')
			gobject.idle_add(
				self.on_menus_cursor_changed, menuTree, self.entry_path
				)
		else:
			gobject.idle_add(self.loadMenus, self.menu_path)
