# Copyright (c) 2007 Canonical
#
# AUTHOR:
# Michael Vogt <mvo@ubuntu.com>
#
# This file is part of AptUrl
#
# GDebi is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# GDebi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GDebi; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


class InvalidUrlException(Exception):
    pass

class AptUrl(object):
    " a class that contains the parsed data from a apt url "
    def __init__(self):
        self.package = None
        self.schema = None
        self.keyfile = None
        self.minver = None
        self.repo_url = None
        self.dist = '/'
        self.section = []

def parse(full_url):
    " parse a apt url and return a list of AptUrl objects "
    res = []

    for url in full_url.split(";"):
        if not ":" in url:
            raise InvalidUrlException
        apt_url = AptUrl()

        # now parse it
        (schema, rem) = url.split(":", 1)
        apt_url.schema = schema
        # check for schemas of the form: apt+http://
        if schema.startswith("apt+"):
            apt_url.repo_url = schema[len("apt+"):] + ":" + rem.split("?",1)[0]
        else:
            if "?" in rem:
                rem = rem.split("?")[0]
            apt_url.package = rem.lstrip("/")

        # now parse the ?... bits
        if "?" in url:
            key_value_pairs = url.split("?")
            if len(key_value_pairs) > 1:
                # first one is invalid
                del key_value_pairs[0]
                for s in key_value_pairs:
                    (k,v) = s.split("=")
                    # for list defaults, add to list
                    try:
                        if type(getattr(apt_url, k)) == type([]):
                            getattr(apt_url, k).append(v)
                        else:
                            setattr(apt_url, k, v)
                    except Exception, e:
                        raise InvalidUrlException
        res.append(apt_url)
    return res    
