/* namespace.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__NAMESPACE_H
#define INCLUDE__LIBARCH__NAMESPACE_H


#include "hackerlab/machine/types.h"
#include "libawk/relational.h"



enum arch_valid_package_name_archive
{
  arch_maybe_archive,
  arch_req_archive,
  arch_no_archive,
};

enum arch_valid_package_name_types
{
  arch_req_category,
  arch_req_package,
  arch_req_version,
  arch_req_patch_level,
};

enum arch_parse_package_name_type
{
  arch_ret_archive,
  arch_ret_non_archive,
  arch_ret_category,
  arch_ret_branch,
  arch_ret_package,
  arch_ret_version,
  arch_ret_patch_level,
  arch_ret_package_version,
  arch_ret_fqversion
};

enum arch_patch_level_type
{
  arch_is_base0_level,
  arch_is_patch_level,
  arch_is_version_level,
  arch_is_versionfix_level,
};





/* automatically generated __STDC__ prototypes */
extern int arch_valid_id (t_uchar * id);
extern int arch_valid_archive_name (t_uchar const * name);
extern int arch_valid_patch_level_name (t_uchar * name);
extern int arch_valid_config_name (t_uchar * name);
extern int arch_valid_package_name (t_uchar const * name,
                         enum arch_valid_package_name_archive archive_disposition,
                         enum arch_valid_package_name_types type,
                         int tolerant);
extern int arch_is_system_package_name (t_uchar * name);
extern t_uchar * arch_parse_package_name (enum arch_parse_package_name_type type,
                         t_uchar const * default_archive,
                         t_uchar const * name);
extern t_uchar * arch_fully_qualify (t_uchar * default_archive, t_uchar * name);
extern int arch_names_cmp (t_uchar const * a, t_uchar const * b);
extern void arch_sort_table_by_name_field (int reverse_p, rel_table table, int field);
extern int arch_patch_lvl_cmp (t_uchar * a, t_uchar * b);
extern void arch_sort_table_by_patch_level_field (int reverse_p, rel_table table, int field);
extern rel_table arch_pick_archives_by_field (rel_table in, int field);
extern rel_table arch_pick_categories_by_field (rel_table in, int field);
extern rel_table arch_pick_branches_by_field (rel_table in, int field);
extern rel_table arch_pick_versions_by_field (rel_table in, int field);
extern rel_table arch_pick_revisions_by_field (rel_table in, int field);
extern rel_table arch_pick_patch_levels_by_field (rel_table in, int field);
extern enum arch_patch_level_type arch_analyze_patch_level (t_ulong * n, t_uchar * patch_level);
extern int arch_cmp_revision (t_uchar *a, t_uchar *b);
extern int arch_cmp_patch_level_type (enum arch_patch_level_type a, enum arch_patch_level_type b);
extern t_uchar * arch_form_patch_level (enum arch_patch_level_type type, t_ulong n);
#endif  /* INCLUDE__LIBARCH__NAMESPACE_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (namespace.h)
 */
