#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test my-id
# Copyright  2005 Canonical Ltd
# Original Authors Robert Collins and James Blackwell
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e


DOW="(Sun|Mon|Tue|Wed|Thu|Fri|Sat)"
MONTH="(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)"
DATEFIELD="$DOW $MONTH [0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]"

FOOARCH="foo@example.org--2003"
FOOBCH="$FOOARCH/hecko-world--foo--1.0"
FOONAME="Jane Doe <jane@example.com>"

JANEARCH="jane@example.com--2003"
JANEONLYBRANCH="hello-world--mainline--1.0"
JANEBCH="$JANEARCH/$JANEONLYBRANCH"
JANENAME="Jane Doe <jane@example.com>"

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "log"

#=======================================================
begin_test "Testing command line arguments"
tla log -h \
  || test_fail "No help for log"
# Tests after this one currently require a working tree
tla get $JANEBCH foo
cd foo

tla log -f \
  || test_fail "No log -f"

tla log --full \
  || test_fail "No log --full"

tla log -r base-0 \
  || test_fail "Baz does not accept one -r argument"

tla log -r base-0:patch-1 \
  || test_fail "Baz does not accept a range"

tla log -r base-0:patch-10 -r patch-23 2>/dev/null\
 && test_fail "Baz accepts than one -r arguments?"

tla log -r hello-world--mainline--1.0 \
  || test_fail "Baz does not accept a limiting beginning version"

tla log -r $FOOBCH--base-0 \
  || test_fail "Baz does not accept fully qualified revisions"

tla log -r :$FOOBCH--patch-1 \
  || test_fail "Baz does not :end range"

tla log -r $FOOBCH--patch-1: \
  || test_fail "Baz does not start: range"

#tla log -r $FOOBCH \
#        -r hello-world--mainline--1.0--base-0 \
#  || test_fail "Baz does not accept fully qualified versions"

end_test

#=======================================================
begin_test "log can do a solitary revision"
# this needs a workdir
tla get $JANEBCH foo
cd foo
tla log > ,,log-output

file_matches "$JANEBCH--base-0
    $DATEFIELD
    $JANENAME
    initial import" ,,log-output \
  || test_fail "$JANEBCH--base-0 not present or has incorrect data"
cd ..
end_test

#=======================================================
begin_test "Ensure log -f shows a full log"
# this needs a workdir
tla get $JANEBCH foo
cd foo
tla log -f > ,,log-output

file_matches "^Archive: $JANEARCHIVE" ,,log-output \
  || test-fail "Jane's base-0 full log is not present"
file_matches "^Revision: $JANEONLYBRANCH" ,,log-output \
  || test-fail "Jane's base-0 full log is not present"

cd ..
end_test

#=======================================================
begin_test "log can handle multiple revisions"

tla get $JANEBCH foo 1>&2>/dev/null
cd foo
tla commit -s "commit for patch-1"
tla log > ,,log-output

file_matches "$JANEBCH--base-0
    $DATEFIELD
    $JANENAME
    initial import

$JANEBCH--patch-1
    $DATEFIELD
    $JANENAME
    commit for patch-1 " ,,log-output \
    || test_fail "logs doesnt show all the logs it should"
cd ..
end_test

#=======================================================
begin_test "Foo branches off of Jane, and wants to use log"

tla branch $JANEBCH \
           $FOOBCH
tla get $FOOBCH foo 1>&2>/dev/null
cd foo
tla commit -s "This is my first local patch"
tla commit -s "This is my second local patch"

tla log > ,,log-output

file_matches "$FOOBCH--patch-2
    $DATEFIELD
    $FOONAME
    This is my second local patch" ,,log-output \
  || test_fail "Log failed to see Foo's patch-2"

file_matches "$FOOBCH--patch-1
    $DATEFIELD
    $FOONAME
    .*" ,,log-output \
  || test_fail "Log failed to Foo's patch-1"

file_matches "$FOOBCH--base-0
    $DATEFIELD
    $FOONAME
    tag of $JANEBCH" ,,log-output \
  || test_fail "Log failed to see Foo's tag of Jane"

file_matches "$JANEBCH--patch-1
    $DATEFIELD
    $JANENAME
    commit for patch-1" ,,log-output \
  || test_fail "Log failed follow back to Jane's patch-1"

file_matches "$JANEBCH--base-0
    $DATEFIELD
    $JANENAME
    initial import" ,,log-output \
  || test_fail "Log failed to follow back to Jane's base-0"

cd ..

end_test

#=======================================================
begin_test "Foo's doesn't know where his ancestor is"

JANEHOME=$(tla whereis-archive jane@example.com--2003)
tla register-archive -d jane@example.com--2003

tla get $FOOBCH foo 1>&2>/dev/null
cd foo

tla log > ,,log-output

file_matches "$FOOBCH--patch-2
    $DATEFIELD
    $FOONAME
    This is my second local patch" ,,log-output \
  || test_fail "Log failed to see Foo's patch-2"

file_matches "$FOOBCH--patch-1
    $DATEFIELD
    $FOONAME
    .*" ,,log-output \
  || test_fail "Log failed to Foo's patch-1"

file_matches "$FOOBCH--base-0
    $DATEFIELD
    $FOONAME
    tag of $JANEBCH" ,,log-output \
  || test_fail "Log failed to see Foo's tag of Jane"

file_matches "$JANEBCH--patch-1
    $DATEFIELD
    $JANENAME
    commit for patch-1" ,,log-output \
  || test_fail "Log failed follow back to Jane's patch-1"

file_matches "$JANEBCH--base-0
    $DATEFIELD
    $JANENAME
    initial import" ,,log-output \
  || test_fail "Log failed to follow back to Jane's base-0"

cd ..

tla register-archive $JANEHOME
end_test

#=======================================================
begin_test "Foo lied about where his ancestor lives"

JANEHOME=$(tla whereis-archive jane@example.com--2003)

mkdir $HOME/no-archive
echo sftp://invalid@invalid.t/ > $HOME/.arch-params/\=locations/jane@example.com--2003

tla get $FOOBCH foo
cd foo

tla log > ,,log-output

file_matches "$FOOBCH--patch-2
    $DATEFIELD
    $FOONAME
    This is my second local patch" ,,log-output \
  || test_fail "Log failed to see Foo's patch-2"

file_matches "$FOOBCH--patch-1
    $DATEFIELD
    $FOONAME
    .*" ,,log-output \
  || test_fail "Log failed to Foo's patch-1"

file_matches "$FOOBCH--base-0
    $DATEFIELD
    $FOONAME
    tag of $JANEBCH" ,,log-output \
  || test_fail "Log failed to see Foo's tag of Jane"

file_matches "$JANEBCH--patch-1
    $DATEFIELD
    $JANENAME
    commit for patch-1" ,,log-output \
  || test_fail "Log failed follow back to Jane's patch-1"

file_matches "$JANEBCH--base-0
    $DATEFIELD
    $JANENAME
    initial import" ,,log-output \
  || test_fail "Log failed to follow back to Jane's base-0"

cd ..

tla register-archive -d jane@example.com--2003
tla register-archive $JANEHOME

rm -rf $HOME/no-archive
end_test

#=======================================================

begin_test "Foo specifies base-0 as the start of log"

tla get $FOOBCH foo
cd foo
tla log -r base-0 > ,,log-output

file_matches "$FOOBCH--patch-2" ,,log-output \
  || test_fail "Log failed to see Foo's patch-2 on unpecified end"

file_matches "^$FOOBCH--patch-1" ,,log-output \
  || test_fail "Log failed to Foo's patch-1 on unspecified end"

file_matches "^$JANEARCH"  ,,log-output\
  && test_fail "Log not properly pruned on unspecified end!"

tla log -r base-0: > ,,log-output

file_matches "$FOOBCH--patch-2" ,,log-output \
  || test_fail "Log failed to see Foo's patch-2 on open end"

file_matches "^$FOOBCH--patch-1" ,,log-output \
  || test_fail "Log failed to Foo's patch-1 on open end"

file_matches "^$JANEARCH"  ,,log-output\
  && test_fail "Log not properly pruned on open end!"


end_test
#=======================================================

begin_test "Foo specifies base-0 as the end of log"

tla get $FOOBCH foo
cd foo
tla log -r :base-0 > ,,log-output

file_matches "$FOOBCH--patch-1" ,,log-output \
  && test_fail "Log failed to prune on closed end"

file_matches "^$FOOBCH--base-0" ,,log-output \
  || test_fail "Log failed to have Foo's base-0 on closed end"

file_matches "^$JANEARCH"  ,,log-output\
  || test_fail "Jane listed in log on closed end!"


#=======================================================

begin_test "Foo just wants base-0 and patch-1"

tla get $FOOBCH foo
cd foo
tla log -r base-0:patch-1> ,,log-output

file_matches "$FOOBCH--patch-2" ,,log-output \
  && test_fail "Log not properly pruned for Foo"

file_matches "^$JANEARCH"  ,,log-output\
  && test_fail "Log not properly pruned for Jane!"

file_matches "^$FOOBCH--patch-1" ,,log-output \
  || test_fail "Log failed to Foo's patch-1"

file_matches "^$FOOBCH--base-0" ,,log-output \
  || test_fail "Log failed to Foo's base-0"

end_test

#=======================================================

begin_test "Wants to see how Jane's work relates to his tree"

tla get $FOOBCH foo
cd foo

tla log -r $JANEBCH:$JANEBCH> ,,log-output

file_matches "^$FOOBCH"  ,,log-output\
  && test_fail "Foo not self pruned!"

file_matches "^$JANEBCH--patch-1" ,,log-output \
  || test_fail "Log failed to Jane's patch-1"

file_matches "^$JANEBCH--base-0" ,,log-output \
  || test_fail "Log failed to Jane's base-0"

end_test

#=======================================================

begin_test "Check to starting offset"

tla get $FOOBCH foo
cd foo

tla log -r 1 > ,,log-output

file_matches "^$FOOBCH--patch-1" ,,log-output \
  || test_fail "Log failed to Jane's patch-1"

file_matches "^$JANEBCH--patch-1" ,,log-output \
  && test_fail "Log failed to Jane's base-0"

file_matches "^$JANEBCH--base-0" ,,log-output \
  && test_fail "Log mistakenly added to Jane's base-0"

end_test

#=======================================================

begin_test "Baz handles a version for a start and a offset for an end"

tla get $FOOBCH foo
cd foo

tla log -r $FOOBCH:1 > ,,log-output

file_matches "^$FOOBCH--patch-2" ,,log-output \
  && test_fail "Log didn't include Foos patch-2"

file_matches "^$FOOBCH--patch-1" ,,log-output \
  || test_fail "Log failed to include Foo's patch-2"

file_matches "^$FOOBCH--base-0" ,,log-output \
  || test_fail "Log failed to include Foo's base-0"

file_matches "^$JANEBCH--patch-1" ,,log-output \
  && test_fail "Log mistakenly added Jane's base-0"

end_test

#=======================================================

begin_test "Check to ending offset"

tla get $FOOBCH foo
cd foo

tla log -r :1 > ,,log-output

file_matches "^$FOOBCH--patch-2"  ,,log-output\
  && test_fail "Foo not self pruned!"

file_matches "^$FOOBCH--patch-1" ,,log-output \
  || test_fail "Log failed to Jane's patch-1"

file_matches "^$FOOBCH--base-0" ,,log-output \
  || test_fail "Log failed to Jane's base-0"

end_test

#=======================================================
#begin_test "Intentional failure"
#dive!dive!dive!
#end_test

clean_workdir

# tag: James Blackwell Sun Feb  6 18:48:11 EST 2005 (test-log.sh)
#
