/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2006  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __BLUETOOTH_DEVICE_H
#define __BLUETOOTH_DEVICE_H

#include <glib-object.h>

G_BEGIN_DECLS

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
				BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), \
				BLUETOOTH_TYPE_DEVICE, BluetoothDeviceClass))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
						BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), \
						BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_GET_DEVICE_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), \
				BLUETOOTH_TYPE_DEVICE, BluetoothDeviceClass))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceClass BluetoothDeviceClass;

struct _BluetoothDevice {
	GObject parent;
};

struct _BluetoothDeviceClass {
	GObjectClass parent_class;
};

GType bluetooth_device_get_type(void);

BluetoothDevice *bluetooth_device_new(void);

G_END_DECLS

#endif /* __BLUETOOTH_DEVICE_H */
