# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import os
import time
from bzrlib.bzrdir import BzrDir

default_branch = "http://bazaar.launchpad.net/~bugsquad/bughelper-data/main/"

def update_packages_data(path, intervall):
    if not os.path.exists(path):
        os.system("bzr branch %s %s" % (default_branch, path))
    else:
        bi = branch_info(path)
        if bi.timestamp + time.timezone + float(intervall)*60*60 <= time.time():
            old_cwd = os.getcwd()
            os.chdir(path)
            os.system("bzr pull %s" % default_branch)
            os.chdir(old_cwd)

class branch_info(object):
    def __init__(self, path):
        tree = BzrDir.open(path).open_workingtree()
        self.revno = tree.branch.revno()
        last_rev = tree.branch.repository.get_revision(tree.last_revision())
        self.timestamp = last_rev.timestamp

