# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import os
import re
import subprocess
import apt_pkg

try:
    from bzrlib.bzrdir import BzrDir
    HAVE_BZR = True    
except:
    HAVE_BZR = False

def find_version_number():
    path = os.path.join(os.path.dirname(__file__), "..")

    # We're using a package
    if path.startswith('/usr'):
        output = subprocess.Popen(["dpkg-query", "-W", "python-launchpad-bugs"], 
                                   stdout=subprocess.PIPE).communicate()[0]
        return output.split()[1]
    if HAVE_BZR:
        try:
            bzr_revno = BzrDir.open(path).open_branch().revno()
            setupscript = open(os.path.join(path, "setup.py")).read()
            version = re.findall("version=\"(.*)\",", setupscript)
            return "%sr%s" % (version[0], bzr_revno)
        except:
            pass
    return "unknown"

def package_exists(package_name):
    try:
        apt_pkg.init()
        sources = apt_pkg.GetPkgSrcRecords()
        sources.Restart()
        if not sources.Lookup(str(package_name)):
            return False
        else:
            return True
    except:
        print "You must put some 'source' URIs in your sources.list"
        return False

def lazy_makedir(directory):
    try:
        os.makedirs(directory)
    except:
        pass

