from bzrlib.tests.blackbox import ExternalBase
from unittest import makeSuite
import os.path
class TestBzrTools(ExternalBase):
    @staticmethod
    def touch(filename):
        file(filename, 'wb').write('')

    def test_clean_tree(self):
        self.run_bzr('init')
        self.run_bzr('ignore *~')
        self.run_bzr('ignore *.pyc')
        self.touch('name')
        self.touch('name~')
        assert os.path.lexists('name~')
        self.touch('name.pyc')
        self.run_bzr('clean-tree')
        assert os.path.lexists('name~')
        assert not os.path.lexists('name')
        self.touch('name')
        self.run_bzr('clean-tree --detritus')
        assert os.path.lexists('name')
        assert not os.path.lexists('name~')
        assert os.path.lexists('name.pyc')
        self.run_bzr('clean-tree --ignored')
        assert os.path.lexists('name')
        assert not os.path.lexists('name.pyc')
        self.run_bzr('clean-tree --unknown')
        assert not os.path.lexists('name')
        self.touch('name')
        self.touch('name~')
        self.touch('name.pyc')
        self.run_bzr('clean-tree --unknown --ignored')
        assert not os.path.lexists('name')
        assert not os.path.lexists('name~')
        assert not os.path.lexists('name.pyc')

    def test_shelve(self):
        self.run_bzr('init')
        self.run_bzr('commit -m uc --unchanged')
        self.run_bzr('shelve -r 1 -m foo --all', retcode=3)
        file('foo', 'wb').write('foo')
        self.run_bzr('add foo')
        self.run_bzr('commit -m foo')
        self.run_bzr('shelve -r 1 -m foo --all', retcode=0)

    def test_fetch_ghosts(self):
        self.run_bzr('init')
        self.run_bzr('fetch-ghosts .')

    def test_patch(self):
        self.run_bzr('init')
        file('myfile', 'wb').write('hello')
        self.run_bzr('add')
        self.run_bzr('commit -m hello')
        file('myfile', 'wb').write('goodbye')
        file('mypatch', 'wb').write(self.run_bzr('diff', retcode=1)[0])
        self.run_bzr('revert')
        assert file('myfile', 'rb').read() == 'hello'
        self.run_bzr('patch --silent mypatch')
        assert file('myfile', 'rb').read() == 'goodbye'

    def test_branch_history(self):
        self.run_bzr('init')
        file('myfile', 'wb').write('hello')
        self.run_bzr('add')
        self.run_bzr('commit -m hello')
        self.run_bzr('branch-history')

    def test_branch_history(self):
        self.run_bzr('init')
        file('myfile', 'wb').write('hello')
        self.run_bzr('add')
        self.run_bzr('commit -m hello')
        self.run_bzr('graph-ancestry . graph.dot')
        self.run_bzr('branch . my_branch')
        self.run_bzr('graph-ancestry . graph.dot --merge-branch my_branch')

    def test_fetch_ghosts(self):
        self.run_bzr('init')
        file('myfile', 'wb').write('hello')
        self.run_bzr('add')
        self.run_bzr('commit -m hello')
        self.run_bzr('branch . my_branch')
        self.run_bzr('fetch-ghosts my_branch')

    def test_zap(self):
        self.run_bzr('init source')
        self.run_bzr('checkout --lightweight source checkout')
        self.run_bzr('zap checkout')
        self.assertIs(False, os.path.exists('checkout'))
        self.assertIs(True, os.path.exists('source'))

    def test_zap_branch(self):
        self.run_bzr('init source')
        self.run_bzr('checkout --lightweight source checkout')
        self.run_bzr('zap --branch checkout', retcode=3)
        self.assertIs(True, os.path.exists('checkout'))
        self.assertIs(True, os.path.exists('source'))
        self.run_bzr('branch source source2')
        self.run_bzr('checkout --lightweight source2 checkout2')
        self.run_bzr('zap --branch checkout2')
        self.assertIs(False, os.path.exists('checkout2'))
        self.assertIs(False, os.path.exists('source2'))

    def test_branches(self):
        self.run_bzr('init source')
        self.run_bzr('init source/subsource')
        self.run_bzr('checkout --lightweight source checkout')
        self.run_bzr('init checkout/subcheckout')
        self.run_bzr('init checkout/.bzr/subcheckout')
        out = self.run_bzr('branches')[0]
        lines = out.split('\n')
        self.assertIs(True, 'source' in lines)
        self.assertIs(True, 'source/subsource' in lines)
        self.assertIs(True, 'checkout/subcheckout' in lines)
        self.assertIs(True, 'checkout' not in lines)
        self.assertIs(True, 'checkout/.bzr/subcheckout' not in lines)

    def test_import_upstream(self):
        self.run_bzr('init source')
        os.mkdir('source/src')
        f = file('source/src/myfile', 'wb')
        f.write('hello?')
        f.close()
        os.chdir('source')
        self.run_bzr('add')
        self.run_bzr('commit -m hello')
        self.run_bzr('export ../source-0.1.tar.gz')
        self.run_bzr('export ../source-0.1.tar.bz2')
        self.run_bzr('export ../source-0.1')
        self.run_bzr('init ../import')
        os.chdir('../import')
        self.run_bzr('import ../source-0.1.tar.gz')
        self.failUnlessExists('src/myfile')
        result = self.run_bzr('import ../source-0.1.tar.gz', retcode=3)[1]
        self.assertContainsRe(result, 'Working tree has uncommitted changes')
        self.run_bzr('commit -m commit')
        self.run_bzr('import ../source-0.1.tar.gz')
        os.chdir('..')
        self.run_bzr('init import2')
        self.run_bzr('import source-0.1.tar.gz import2')
        self.failUnlessExists('import2/src/myfile')
        self.run_bzr('import source-0.1.tar.gz import3')
        self.failUnlessExists('import3/src/myfile')
        self.run_bzr('import source-0.1.tar.bz2 import4')
        self.failUnlessExists('import4/src/myfile')
        self.run_bzr('import source-0.1 import5')
        self.failUnlessExists('import5/src/myfile')

def test_suite():
    return makeSuite(TestBzrTools)
