#!/bin/sh

if [ $# = 3 ]; then
	index=$1
	seconds=$2
	mod_version=$3
	gpu=`./gpu`
	ogl_version=`./ogl`

	echo "This will take roughly $((6*5*2*2*3*seconds/60)) minutes to complete"
	all=$((6*5*2*2*3))
	current=0

	for num in 5 10 15 20 25 30; do
		for size in 10 20 50 100 125; do
			for actor_type in single composited; do
				for anim_type in animated static; do
					for effect_type in blur glow shadow; do
						current=$((current+1))
						./test-clutk-perf $index $num $size $seconds $actor_type $anim_type $effect_type $mod_version "$gpu" "$ogl_version" $current $all >>log-$num-$size-$actor_type-$anim_type-$effect_type.csv
					done
				done
			done
		done
	done
else
	echo "Usage: $0 <index> <seconds> <mod_version>"
	echo "Example: $0 0 5 0.3.2"
fi

