#!/bin/sh

. /lib/lsb/init-functions

#
# Load the keymaps *as soon as possible*
#

# Don't fail on error
CONSOLE_TYPE=`fgconsole 2>/dev/null` || CONSOLE_TYPE="unknown"

# Don't fail on serial consoles

# fail silently if loadkeys not present (yet).
command -v loadkeys >/dev/null 2>&1 || exit 0

CONFDIR=/etc/console
CONFFILEROOT=boottime
EXT=kmap
CONFFILE=${CONFDIR}/${CONFFILEROOT}.${EXT}.gz

reset_kernel()
{
	# On Mac PPC machines, we may need to set kernel vars first
        # We need to mount /proc to do that; not optimal, as its going to 
        # be mounted in S10checkroot, but we need it set up before sulogin
        # may be run in checkroot, which will need the keyboard to log in...
	[ -x /sbin/sysctl ] || return
	[ -r /etc/sysctl.conf ] || return
	grep -v '^\#' /etc/sysctl.conf | grep -q keycodes 
	if [ "$?" = "0" ] ; then
	    grep keycodes /etc/sysctl.conf | grep -v "^#" | while read d ; do
	        /sbin/sysctl -w $d 2> /dev/null || true
            done
        fi
}

unicode_start_stop()
{
	# Switch unicode mode by checking the locale.
	# This will be needed before loading the keymap.
	[ -x /usr/bin/unicode_start ] || return
	[ -x /usr/bin/unicode_stop ] || return
	[ -r /etc/environment ] || return
	
	for var in LANG LC_ALL LC_CTYPE; do
		value=$(egrep "^[^#]*${var}=" /etc/environment | cut -d= -f2)
		eval $var=$value
	done

	CHARMAP=`LANG=$LANG LC_ALL=$LC_ALL LC_CTYPE=$LC_CTYPE locale charmap`
	if [ "$CHARMAP" = "UTF-8" ]; then
		/usr/bin/unicode_start 2> /dev/null || true
	else
		/usr/bin/unicode_stop 2> /dev/null || true
	fi
}

case "$1" in
    start | restart | force-reload | reload)

       # First mount /proc if necessary.
       unmount_proc="no"
       if [ ! -x /proc/1 ]; then
      	unmount_proc="yes"	
        mount -n /proc
       fi

	# Set kernel variables if required
	reset_kernel

        if [ -f /proc/sys/dev/mac_hid/keyboard_sends_linux_keycodes ] ; then
           linux_keycodes=`cat /proc/sys/dev/mac_hid/keyboard_sends_linux_keycodes`
	else
           linux_keycodes=1;
        fi

	# load new map
	if [ $linux_keycodes -gt 0 ] ; then 
	  if [ -r ${CONFFILE} ] ; then

	    # Switch console mode to UTF-8 or ASCII as necessary
	    unicode_start_stop

	    if [ $CONSOLE_TYPE = "serial" ] ; then 
		    loadkeys -q ${CONFFILE} 2>&1 > /dev/null
	    else
	    	    loadkeys -q ${CONFFILE}
	    fi
	    if [ $? -gt 0 ]
		then
	    	# if we've a serial console, we may not have a keyboard, so don't
		# complain if we fail. 
		[ $CONSOLE_TYPE = "serial" ] && exit 0

		log_warning_msg "Problem when loading ${CONFDIR}/${CONFFILEROOT}.${EXT}.gz, use install-keymap"
		sleep 10
		fi
	    fi
	fi

	# unmount /proc if we mounted it
        [ "$unmount_proc" = "no" ] || umount -n /proc

	;;

    stop)
# 	# ensure the saved kernel keymap is removed before halt/reboot
# 	rm -f ${KERNEL_KEYMAP}
	;;

    *)
	log_success_msg "Usage: $0 {start|stop|restart|reload|force-reload}"
	exit 1
	;;
esac
