/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlmsublist.h"

static const char rcsid[]="$Id: cmlmsublist.C,v 1.2 2000/09/16 21:37:20 mrsam Exp $";

SubscriberList::SubscriberList( int wantalias)
	: dirp(0), next_func( wantalias ? &SubscriberList::openalias:
			      &SubscriberList::domain )
{
}

SubscriberList::~SubscriberList()
{
	if (dirp)	closedir(dirp);
}

//
// Read addresses from dedicated domain files.
//

int SubscriberList::domain(CString &ret)
{
struct	dirent *de;
char	*key, *val;
size_t	kl, vl;

	if (!dirp)	dirp=opendir(DOMAINS);

	if (domain_file.IsOpen())	// A domain file is currently open
	{
		key=domain_file.FetchNextKeyVal(kl, val, vl);
		if (key)
		{
			memcpy(buf.GetBuffer(kl), key, kl);
			buf.ReleaseBuffer(kl);

			memcpy(sub_info.GetBuffer(vl), val, vl);
			sub_info.ReleaseBuffer(vl);

			free(val);
			ret=buf;
			return (0);
		}

		domain_file.Close();
	}

	// Searching for the next domain file.

	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;
		if (strchr(de->d_name, '.') == 0)	continue;

		buf=DOMAINS "/";
		buf += de->d_name;

		if (domain_file.Open(buf, "R") == 0)
		{
			key=domain_file.FetchFirstKeyVal(kl, val, vl);
			if (key)
			{
				memcpy(buf.GetBuffer(kl), key, kl);
				buf.ReleaseBuffer(kl);

				memcpy(sub_info.GetBuffer(vl), val, vl);
				sub_info.ReleaseBuffer(vl);

				free(val);
				ret=buf;
				return (0);
			}
			domain_file.Close();
		}
	}
	closedir(dirp);
	dirp=0;

	// Now, read the miscellaneous database

	if (domain_file.Open(MISC, "R"))	return (-1);

	key=domain_file.FetchFirstKeyVal(kl, val, vl);
	if (!key)
	{
		domain_file.Close();
		return (-1);
	}

	memcpy(buf2.GetBuffer(vl), val, vl);
	buf2.ReleaseBuffer(vl);
	free(val);
	buf2index=0;

	next_func= &SubscriberList::shared;
	return (shared(ret));
}

// Read the miscellaneous database file

int SubscriberList::shared(CString &ret)
{
	for (;;)
	{
	char	*key, *val;
	size_t	kl, vl;
	size_t	val_start;

		vl=buf2.GetLength();

		if (buf2index < vl)
		{
		size_t	j;

			for (j=buf2index; j<vl && buf2[j]; j++)
				;

			if (j < vl)
			{
				val_start=j+1;

				do
				{
					++j;
				} while (j<vl && buf2[j]);
				if (j < vl)
				{
					buf= (const char *)buf2 + buf2index;
					buf2index=j+1;
					ret=buf;
					sub_info=(const char *)buf2+val_start;
					return (0);
				}
			}
		}

		key=domain_file.FetchNextKeyVal(kl, val, vl);
		if (!key)	break;

		memcpy(buf2.GetBuffer(vl), val, vl);
		buf2.ReleaseBuffer(vl);
		free(val);

		buf2index=0;
	}

	domain_file.Close();

	next_func= &SubscriberList::domain;
	return (-1);
}

// Read the alias file, instead of the subscriber database.

int SubscriberList::openalias(CString &ret)
{
	if (domain_file.Open( ALIASES, "R" ))	return (-1);
	next_func= &SubscriberList::nextalias;

char	*key, *val;
size_t	kl, vl;

	key=domain_file.FetchFirstKeyVal(kl, val, vl);
	if (!key)
		return (-1);

CString	keys, vals;

	memcpy(vals.GetBuffer(vl), val, vl);
	vals.ReleaseBuffer(vl);
	free(val);

	memcpy(keys.GetBuffer(kl), key, kl);
	keys.ReleaseBuffer(kl);

	ret=keys;
	posting_alias=vals;
	return ( 0 );
}

int SubscriberList::nextalias(CString &ret)
{
char	*key, *val;
size_t	kl, vl;

	key=domain_file.FetchNextKeyVal(kl, val, vl);
	if (!key)
		return (-1);

CString	keys, vals;

	memcpy(vals.GetBuffer(vl), val, vl);
	vals.ReleaseBuffer(vl);
	free(val);

	memcpy(keys.GetBuffer(kl), key, kl);
	keys.ReleaseBuffer(kl);

	ret=keys;
	posting_alias=vals;
	return ( 0 );
}
