/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"cmlmsubunsub.h"
#include	"numlib/numlib.h"
#include	"dbobj.h"
#include	"sys/types.h"
#include	"sys/stat.h"
#include	<time.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<iostream>
#include	<fstream>
#include	<ctype.h>
#include	<sysexits.h>

static const char rcsid[]="$Id: cmlmsubunsub.C,v 1.5 2003/01/05 04:01:14 mrsam Exp $";

// subscribe an address


static int cmdsubunsub(int argc, char **argv,
		int (*)(const char *, CString),
		const char *);

int cmdsub(int argc, char **argv)
{
	return (cmdsubunsub(argc, argv, docmdsub, "subscribed"));
}

int cmdunsub(int argc, char **argv)
{
	return (cmdsubunsub(argc, argv, docmdunsub, "unsubscribed"));
}

static int cmdsubunsub(int argc, char **argv,
		int (*func)(const char *, CString),
		const char *msg)
{
char	*p, *q;

	if (argc == 0 || (p=strchr(argv[0], '@')) == 0 || strchr(p+1, '@'))
	{
		cerr << "Invalid address." << endl;
		return (1);
	}

	for (q=p; *q; q++)
		*q=tolower((int)(unsigned char)*q);

CString	buf;
CString	subbuf;

	{
	time_t	t;

		time(&t);
		subbuf=ctime(&t);
		subbuf += '\n';
	}

#if	HAVE_ISATTY
	if (isatty(2))
#endif
	{
		cout << "Enter supporting information, EOF to terminate (usually CTRL-D):" << endl;
	}

	while ((buf << cin) == 0)
	{
		subbuf += buf;
		subbuf += '\n';
	}

int rc=(*func)(argv[0], subbuf);

	if (rc == 9)
		cerr << argv[0] << ": already " << msg << "." << endl;
	return (rc);
}

int docmdsub(const char *aptr, CString subbuf)
{
	CString	addrbuf=(aptr ? aptr:"");
	char	*addr=addrbuf.GetBuffer(-1);

	char	*p, *q;
	struct	stat	stat_buf;
	CString	buf;
	time_t	timestamp;

	if (aptr == 0 || (p=strchr(addr, '@')) == 0 || strchr(p+1, '@')
			|| strchr(p, '.') == 0 || strchr(p, '/'))
	{
		cerr << "Invalid address." << endl;
		return (1);
	}

	for (q=p; *q; q++)
		*q=tolower((int)(unsigned char)*q);

	// Save subscription date in a header.

	{
	char buf[NUMBUFSIZE];

		time(&timestamp);
		libmail_str_time_t(timestamp, buf);
		subbuf= CString("x-couriermlm-date: ") + buf + "\n" + subbuf;
	}

SubExclusiveLock subscription_lock;

	buf=DOMAINS "/";
	buf += p+1;

//
// First, check for a dedicated db file
//

DbObj	domain_file;

	if (stat(buf, &stat_buf) == 0 && domain_file.Open(buf, "W") == 0)
	{
		if (domain_file.Store(addr, strlen(addr),
			(const char *)subbuf, subbuf.GetLength(), "I"))
		{
			domain_file.Close();
			return (9);
		}
		return (0);
	}

//
// No, check the misc file
//

DbObj	misc_file;

	if (misc_file.Open(MISC, "C"))
	{
		perror(MISC);
		return (1);
	}

CString	miscbuf;
char	*r;
size_t	rlen;
size_t	i, j;

	if ((r=misc_file.Fetch(p+1, strlen(p+1), rlen, "")) != 0)
	{
	size_t	cnt=0;

		for (i=0; i<rlen; i++)
		{
			for (j=i; j < rlen && r[j]; j++)
				;
			if (j >= rlen)	break;

			if (strcmp(r+i, addr) == 0)
			{
				misc_file.Close();
				return (9);
			}

			do
			{
				++j;
			} while (j < rlen && r[j]);
			if (j >= rlen)	break;
			++cnt;
			i=j;
		}
		memcpy(miscbuf.GetBuffer(i), r, i);
		miscbuf.ReleaseBuffer(i);
		free(r);

		if (cnt >= MISCSIZE)	// Time to create a new domain file
		{
			buf=DOMAINS "/";
			buf += p+1;
			if (domain_file.Open(buf, "C"))
			{
				perror(buf);
				misc_file.Close();
				return (1);
			}

			rlen=miscbuf.GetLength();
			r=miscbuf.GetBuffer(rlen);
			for (i=0; i<rlen; i++)
			{
				for (j=i; r[j++]; )
					;

				if (domain_file.Store(r+i,
					strlen(r+i),
					r+j,
					strlen(r+j), "I"))
				{
					perror(buf);
					domain_file.Close();
					misc_file.Close();
					unlink(buf);
					return (1);
				}
				while ( r[j] )
					++j;
				i=j;
			}
			miscbuf.ReleaseBuffer(rlen);
			if (domain_file.Store(addr, strlen(addr),
					(const char *)subbuf,
					subbuf.GetLength(), "I"))
			{
				perror(buf);
				domain_file.Close();
				misc_file.Close();
				unlink(buf);
				return (1);
			}
			domain_file.Close();
			misc_file.Delete(p+1, strlen(p+1));
			misc_file.Close();

			ofstream(SUBLOGFILE, ios::out|ios::app) << timestamp << " SUBSCRIBE " << addr << endl;

			return (0);
		}
	}

	i=miscbuf.GetLength();

	j=i+strlen(addr)+subbuf.GetLength()+2;

	r=miscbuf.GetBuffer(j)+i;

	strcpy(r, addr);
	while (*r++)
		;
	strcpy(r, subbuf);
	miscbuf.ReleaseBuffer(j);

	if (misc_file.Store(p+1, strlen(p+1),
		miscbuf.GetBuffer(j), j, "R"))
	{
		perror(MISC);
		misc_file.Close();
		return (EX_SOFTWARE);
	}
	misc_file.Close();

	ofstream(SUBLOGFILE, ios::out|ios::app) << timestamp << " SUBSCRIBE " << addr << endl;

	return (0);
}

static void saveunsub(CString, const char *, const char *);
static void unsubalias(const char *);

static int unsub_common(const char *, CString, const char *);

int docmdunsub(const char *aptr, CString reason)
{
	return (unsub_common(aptr, reason, "UNSUBSCRIBE"));
}

int docmdunsub_bounce(const char *aptr, CString reason)
{
	return (unsub_common(aptr, reason, "BOUNCE"));
}

static int unsub_common(const char *aptr, CString reason, const char *log)
{
CString	addrbuf=(aptr ? aptr:"");

char	*addr=addrbuf.GetBuffer(-1);
char	*p, *q;
struct	stat	stat_buf;

	if (addr == 0 || (p=strchr(addr, '@')) == 0 || strchr(p+1, '@')
			|| strchr(p, '.') == 0 || strchr(p, '/'))
	{
		cerr << "Invalid address." << endl;
		return (1);
	}

	for (q=p; *q; q++)
		*q=tolower((int)(unsigned char)*q);

SubExclusiveLock subscription_lock;

CString	buf;

	buf=DOMAINS "/";
	buf += p+1;

DbObj	domain_file;
CString	sub_request;

	if (stat(buf, &stat_buf) == 0 && domain_file.Open(buf, "W") == 0)
	{
	CString	newbuf;
	size_t	newbufl;
	char	*key, *val;
	size_t	kl, vl;
	size_t	cnt=0;

		if ((val=domain_file.Fetch(addr, strlen(addr), vl, ""))
			== 0)
		{
			return (9);
		}

		memcpy(sub_request.GetBuffer(vl), val, vl);
		sub_request.ReleaseBuffer(vl);
		free(val);
		sub_request += "==========================================\n";
		sub_request += reason;

		domain_file.Delete(addr, strlen(addr));

		newbufl=0;

		for (key=domain_file.FetchFirstKeyVal(kl, val, vl);
			key;
			key=domain_file.FetchNextKeyVal(kl, val, vl))
		{
		char	*p;

			if (cnt >= MISCSIZE)
			{
				free(val);
				domain_file.Close();
				saveunsub(sub_request, addr, log);
				unsubalias(addr);
				return (0);
			}

			p=newbuf.GetBuffer(newbufl+kl+vl+2);
			p += newbufl;
			memcpy(p, key, kl);
			p += kl;
			*p++=0;
			memcpy(p, val, vl);
			p[vl]=0;

			newbufl += kl + vl + 2;
			newbuf.ReleaseBuffer(newbufl);
			++cnt;
		}

	DbObj	misc_file;

		if (misc_file.Open(MISC, "W") ||
			misc_file.Store(p+1, strlen(p+1), newbuf, newbufl, "R"))
		{
			perror(MISC);
			misc_file.Close();
			domain_file.Close();
			return (1);
		}
		misc_file.Close();
		domain_file.Close();
		unlink(buf);
		saveunsub(sub_request, addr, log);
		unsubalias(addr);
		return (0);
	}

char	*r;
size_t	rlen;
size_t	i, j, k;

	if (domain_file.Open(MISC, "W"))
	{
		return (0);
	}

	if ((r=domain_file.Fetch(p+1, strlen(p+1), rlen, "")) == 0)
		return (9);

int	rc=9;

	k=0;
	for (i=0; i<rlen; )
	{
		for (j=i; j < rlen && r[j]; j++)
			;
		if (j >= rlen)	break;
		++j;
		while (j < rlen && r[j])
			j++;
		if (j >= rlen)	break;
		++j;
		if (strcmp(r+i, addr))
		{
			while (i < j)
				r[k++]=r[i++];
		}
		else
		{
			rc=0;
			sub_request= r+i+strlen(addr)+1;
			sub_request += "==========================================\n";
			sub_request += reason;
		}
		i=j;
	}
	if (domain_file.Store(p+1, strlen(p+1), r, k, "R") == 0)
	{
		domain_file.Close();
		if (rc == 0)
		{
			saveunsub(sub_request, addr, log);
			unsubalias(addr);
		}
		return (rc);
	}
	perror(MISC);
	free(r);
	domain_file.Close();
	return (1);
}

static void saveunsub(CString sub_request, const char *addr, const char *log)
{
CString	f=mktmpfilename();
CString	tfilename= TMP "/" + f;
CString	ufilename= UNSUBLIST "/" + f;

ofstream	ofs(tfilename);

	ofs << "Address: " << addr << endl << sub_request;
	ofs.flush();
	if (ofs.bad())
	{
		perror(tfilename);
		exit(1);
	}
	ofs.close();
	rename (tfilename, ufilename);

	time_t	timestamp;

	{
	char buf[NUMBUFSIZE];

		time(&timestamp);
		libmail_str_time_t(timestamp, buf);
		ofstream(SUBLOGFILE,
			 ios::out|ios::app) << timestamp << " " << log << " " << addr << endl;
	}
}

static void unsubalias(const char *addr)
{
DbObj	aliases;
CString	buf;

	if (aliases.Open(ALIASES, "W"))	return;

	buf="0";
	buf += addr;

size_t	pl;
char	*p=aliases.Fetch(buf, buf.GetLength(), pl, "");

	if (!p)	return;

	aliases.Delete(buf, buf.GetLength());

char	*q=buf.GetBuffer(pl+1);

	*q='1';
	memcpy(q+1, p, pl);
	buf.ReleaseBuffer(pl+1);

	aliases.Delete(buf, buf.GetLength());
}
