#ifndef	afxdebug_h
#define	afxdebug_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

static const char afxdebug_h_rcsid[]="$Id: afxdebug.h,v 2.1 2001/04/21 02:03:17 mrsam Exp $";

#ifdef	DEBUG

#include	"afxtempl.h"
#include	<iostream>

class	AfxDebug	{
	CStringArray	m_debugmodes;
public:
	void	Init(CString modes)
		{
			m_debugmodes=CStringTok(modes, ",");
		}
	AFXBOOL	HasMode(CString m)
		{
		size_t l=m_debugmodes.GetSize();
		size_t i;

			for (i=0; i<l; i++)
				if (m == m_debugmodes[i])
					return (TRUE);
			return (FALSE);
		}
} ;

extern AfxDebug afxdebug;	// Must declare in your main

#define IFDEBUG(name, action) if (afxdebug.HasMode(name)) { action }
#else
#define IFDEBUG(name, action)
#endif

#define TRACE(x)	IFDEBUG("trace", cout << __FILE__ << '(' \
				<< __LINE__ << "): " << x << endl; )

#ifdef	DEBUG
class	AfxDebugFunction {
	const char *m_name;
public:
	AfxDebugFunction(const char *name) : m_name(name)
		{
			IFDEBUG("func", cout << "Entering " << m_name << endl;)
		}
	~AfxDebugFunction()
		{
			IFDEBUG("func", cout << "Exiting " << m_name<< endl;)
		}
} ;

#define	TRACE_FUNCTION(name) AfxDebugFunction debug_function(name);
#else
#define	TRACE_FUNCTION(name)
#endif

#endif
