/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "channelhandler.h"
#include "channelhandleradaptor.h"

#include <QtTapioca/Connection>
#include <QtTapioca/Channel>
#include <QtTapioca/Handle>

#include <QtDBus/QDBusObjectPath>
#include <QtCore/QPointer>
#include <QtCore/QDebug>

namespace Decibel
{

/// @cond INCLUDE_PRIVATE

/**
 * @brief Private data class for the ChannelHandler.
 * @author Tobias Hunger <info@basyskom.de>
 */
class ChannelHandlerPrivate
{
private:
    ChannelHandlerPrivate()
    { }

    ~ChannelHandlerPrivate()
    { }

    QPointer<ChannelHandlerAdaptor> adaptor;

    friend class ChannelHandler;
};

/// @endcond

} // namespace

// ****************************************************************************

Decibel::ChannelHandler::ChannelHandler(QObject * parent) :
    QObject(parent),
    d(new Decibel::ChannelHandlerPrivate())
{
    d->adaptor = new ChannelHandlerAdaptor(this);
}

Decibel::ChannelHandler::~ChannelHandler()
{ delete d; }

bool Decibel::ChannelHandler::handleChannel(const Decibel::ChannelInfo & channel_info)
{
    if (channel_info.isNull())
    {
        qDebug() << "ChannelHandler: ChannelInfo isNull()";
        return false;
    }

    QtTapioca::Connection * connection = channel_info.connection(this);
    if (0 == connection)
    {
        qWarning() << "ChannelHandler: Connection is NULL.";
        return false;
    }
    QtTapioca::Channel * channel = channel_info.channel();
    if (0 == channel)
    {
        qWarning() << "ChannelHandler: Channel is NULL.";
        return false;
    }

    return handleChannel(connection, channel, channel_info.incoming);
}
