/* drawtuplets.cpp
 *
 * Functions for drawing tuplet indications
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Matthew Hiller
 */

#include "utils.h"		/* Includes <gdk.h> */
#include <denemo/denemo.h>

void
draw_tupbracket (GdkPixmap * pixmap, GdkGC * gc, GdkFont * font,
		 gint xx, gint y, mudelaobject * theobj)
{
  static GdkFont *tupbracketfont = NULL;
  static GString *tupopentext;

  if (!tupbracketfont)
    {
      tupbracketfont =
	gdk_fontset_load
	("-*-helvetica-medium-r-normal-*-12-*-*-*-*-*-iso8859-*");
      if (!tupbracketfont)
	tupbracketfont = font;
      tupopentext = g_string_new (NULL);
    }
  if (theobj->type == TUPOPEN)
    {
      g_string_sprintf (tupopentext, _("Times %d/%d"),
			((tupopen *) theobj->object)->numerator,
			((tupopen *) theobj->object)->denominator);
      gdk_draw_text (pixmap, tupbracketfont, gc, xx, y - 4, tupopentext->str,
		     tupopentext->len);
    }
  else if (theobj->type == TUPCLOSE)
    gdk_draw_text (pixmap, tupbracketfont, gc, xx, y - 4, _("End tuplet"),
		   10);
}
