/* help.cpp
 * implements the stuff under Help in the menubar
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001, 2002 Matthew Hiller
 */

#include <denemo/denemo.h>
#include "config.h"
#include <string.h>		/* for strlen */
/* The tutorial mentioned that the actual gchar * held within a
 * GtkText widget needs to be freed.  I don't do such a free, though,
 * so I think this function has a memory leak in it. */

void
about (GtkAction *action , gpointer callback_data)
{
  GtkWidget *dialog;
  const char* authors[] = {"Matthew Hiller", "Adam Tee", NULL};

  dialog = gtk_about_dialog_new();
  gtk_about_dialog_set_name(GTK_ABOUT_DIALOG(dialog), _("Denemo"));
  gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(dialog), 
				_("The GNU graphical score editor"));
  gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(dialog), VERSION);
  gtk_about_dialog_set_website(GTK_ABOUT_DIALOG(dialog), 
			       "http://denemo.sourceforge.net");
  gtk_about_dialog_set_website_label(GTK_ABOUT_DIALOG(dialog), 
				     _("Denemo website"));
  gtk_about_dialog_set_license(GTK_ABOUT_DIALOG(dialog),
			       _("(c) 1999, 2000, 2001 Matthew Hiller, Adam Tee, and others.\n\n\
http://www.gnu.org/software/denemo/denemo.html\n\n\
This program is licensed under the terms of the GNU\n\
General Public License and is provided with absolutely\n\
NO WARRANTY; see the file COPYING for details."));
  
  
  gtk_about_dialog_set_authors(GTK_ABOUT_DIALOG(dialog), authors);
  gtk_widget_show_all(dialog);
}
