/* keyresponses.cpp
 * switching station for processing user keypresses
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller
 */


#include "kbd-custom.h"
#include "keyresponses.h"
#include "articulations.h"
#include "barline.h"

void
scorearea_keypress_event (GtkWidget * widget, GdkEventKey * event,
			  gpointer data)
{
  struct scoreinfo *si = (struct scoreinfo *) data;
  struct keybinding_info *ki;

  if (si->textview && GTK_WIDGET_IS_SENSITIVE (si->textview))
    {
      /*    printf("Focus is on text window\n"); */
      gtk_widget_draw (si->textview, NULL);
      return;
    }
  /* Look up the keystroke in the keymap and execute the appropriate
   * function */

  if ((ki = lookup_keybinding (si->prefs->the_keymap, event->keyval,
			       event->state)))
    {
      if (ki->callback_action == -1)
	ki->func.nocallback (si);
      else
	ki->func.callback (NULL, si);

      gtk_widget_draw (si->scorearea, NULL);
    }
}

void
adjust_measure_less_width_key (struct scoreinfo *si)
{
  adjustmeasurewidth (si, -10);
}

void
adjust_measure_more_width_key (struct scoreinfo *si)
{
  adjustmeasurewidth (si, 10);
}

void
adjust_staff_less_height_key (struct scoreinfo *si)
{
  adjuststaffheight (si, -10);
}

void
adjust_staff_more_height_key (struct scoreinfo *si)
{
  adjuststaffheight (si, 10);

}

void
unset_selection_key (struct scoreinfo *si)
{
  si->markstaffnum = 0;
}

void
insert_chord_key (struct scoreinfo *si)
{
  insertchord (si, 2, FALSE);
}

void
go_to_A_key (struct scoreinfo *si)
{
  shiftcursor (si, 5);
}

void
go_to_B_key (struct scoreinfo *si)
{
  shiftcursor (si, 6);
}

void
go_to_C_key (struct scoreinfo *si)
{
  shiftcursor (si, 0);
}

void
go_to_D_key (struct scoreinfo *si)
{
  shiftcursor (si, 1);
}

void
go_to_E_key (struct scoreinfo *si)
{
  shiftcursor (si, 2);
}

void
go_to_F_key (struct scoreinfo *si)
{
  shiftcursor (si, 3);
}

void
go_to_G_key (struct scoreinfo *si)
{
  shiftcursor (si, 4);
}

void
octave_up_key (struct scoreinfo *si)
{
  si->cursor_y += 7;
}

void
octave_down_key (struct scoreinfo *si)
{
  si->cursor_y -= 7;
}

void
default_mode (GtkAction * action, struct scoreinfo *si)
{
  if (si->mode != TRAVERSE)
    si->mode = TRAVERSE;
  gtk_statusbar_push (GTK_STATUSBAR (si->statusbar), si->status_context_id,
		      "Default");
  displayhelper(si);
  
}

void
insert_mode (GtkAction * action, struct scoreinfo *si)
{
  if (si->mode != INPUTNORMAL)
    si->mode = INPUTNORMAL;
  gtk_statusbar_push (GTK_STATUSBAR (si->statusbar), si->status_context_id,
		      "Insert");
  displayhelper(si);
}

void
replace_mode (GtkAction * action, struct scoreinfo *si)
{
  if (si->mode != REPLACE)
    si->mode = REPLACE;
  gtk_statusbar_push (GTK_STATUSBAR (si->statusbar), si->status_context_id,
		      "Replace");
  displayhelper(si);
}

void
rest_toggle_key (struct scoreinfo *si)
{
  if (si->mode == INPUTNORMAL)
    si->mode = INPUTREST;
  else if (si->mode == INPUTREST)
    si->mode = INPUTNORMAL;
  else if (si->mode == INPUTBLANK)
    si->mode = INPUTBLANKREST;
  else
    si->mode = INPUTBLANK;
}

void
toggle_blank (struct scoreinfo *si)
{
  if (si->mode == INPUTNORMAL)
    si->mode = INPUTBLANK;
  else if (si->mode == INPUTREST)
    si->mode = INPUTBLANKREST;
  else if (si->mode == INPUTBLANK)
    si->mode = INPUTNORMAL;
  else
    si->mode = INPUTREST;
}

void
append_measure_key (struct scoreinfo *si)
{
  appendmeasures (si, 1);
}

void
insert_measure_key (struct scoreinfo *si)
{
  insertmeasures (si, 1);
}

void
change_duration_0key (struct scoreinfo *si)
{
  changeduration (si, 0);
}

void
change_duration_1key (struct scoreinfo *si)
{
  changeduration (si, 1);
}

void
change_duration_2key (struct scoreinfo *si)
{
  changeduration (si, 2);
}

void
change_duration_3key (struct scoreinfo *si)
{
  changeduration (si, 3);
}

void
change_duration_4key (struct scoreinfo *si)
{
  changeduration (si, 4);
}

void
change_duration_5key (struct scoreinfo *si)
{
  changeduration (si, 5);
}

void
change_duration_6key (struct scoreinfo *si)
{
  changeduration (si, 6);
}

void
insert_chord_0key (struct scoreinfo *si)
{
  if (si->mode == REPLACE)
    {
      change_pitch (si);
      displayhelper (si);
    }
  else
    insertchord (si, 0, FALSE);

}

void
insert_chord_1key (struct scoreinfo *si)
{
  if (si->mode == REPLACE)
    {
      change_pitch (si);
      displayhelper (si);
    }
  else
    insertchord (si, 1, FALSE);
}

void
insert_chord_2key (struct scoreinfo *si)
{
  if (si->mode == REPLACE)
    {
      change_pitch (si);
      displayhelper (si);
    }
  else
    insertchord (si, 2, FALSE);
}

void
insert_chord_3key (struct scoreinfo *si)
{
  if (si->mode == REPLACE)
    {
      change_pitch (si);
      displayhelper (si);
    }
  else
    insertchord (si, 3, FALSE);
}

void
insert_chord_4key (struct scoreinfo *si)
{
  if (si->mode == REPLACE)
    {
      change_pitch (si);
      displayhelper (si);
    }
  else
    insertchord (si, 4, FALSE);
}

void
insert_chord_5key (struct scoreinfo *si)
{
  if (si->mode == REPLACE)
    {
      change_pitch (si);
      displayhelper (si);
    }
  else
    insertchord (si, 5, FALSE);
}

void
insert_chord_6key (struct scoreinfo *si)
{
  if (si->mode == REPLACE)
    {
      change_pitch (si);
      displayhelper (si);
    }
  else
    insertchord (si, 6, FALSE);
}

void
insert_rest_0key (struct scoreinfo *si)
{
  insertchord (si, 0, TRUE);
}

void
insert_rest_1key (struct scoreinfo *si)
{
  insertchord (si, 1, TRUE);
}

void
insert_rest_2key (struct scoreinfo *si)
{
  insertchord (si, 2, TRUE);
}

void
insert_rest_3key (struct scoreinfo *si)
{
  insertchord (si, 3, TRUE);
}

void
insert_rest_4key (struct scoreinfo *si)
{
  insertchord (si, 4, TRUE);
}

void
insert_rest_5key (struct scoreinfo *si)
{
  insertchord (si, 5, TRUE);
}

void
insert_rest_6key (struct scoreinfo *si)
{
  insertchord (si, 6, TRUE);
}

void
insert_tuplet_0key (struct scoreinfo *si)
{
  inserttuplet (si, 0);
}

void
insert_tuplet_1key (struct scoreinfo *si)
{
  inserttuplet (si, 1);
}

void
insert_tuplet_2key (struct scoreinfo *si)
{
  inserttuplet (si, 2);
}

void
insert_tuplet_3key (struct scoreinfo *si)
{
  inserttuplet (si, 3);
}

void
insert_tuplet_4key (struct scoreinfo *si)
{
  inserttuplet (si, 4);
}

void
insert_tuplet_5key (struct scoreinfo *si)
{
  inserttuplet (si, 5);
}

void
insert_tuplet_6key (struct scoreinfo *si)
{
  inserttuplet (si, 6);
}

void
insert_tuplet_7key (struct scoreinfo *si)
{
  inserttuplet (si, 7);
}

void
insert_tuplet_9key (struct scoreinfo *si)
{
  inserttuplet (si, 9);
}

void
add_tone_key (struct scoreinfo *si)
{
  tonechange (si, FALSE);
  displayhelper (si);
}

void
remove_tone_key (struct scoreinfo *si)
{
  tonechange (si, TRUE);
  displayhelper (si);
}

void
backspace_key (struct scoreinfo *si)
{
  /* remove the object preceding the cursor, within the current measure */
  if (si->cursor_x)
    {
      /* Then move the cursor back */
      cursorleft (si);
      /* And delete */
      deleteobject (si);
    }
}

void
sharpen_key (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  if (curmudelaobj && curmudelaobj->type == STEMDIRECTIVE)
    change_stem_directive (si, DENEMO_STEMUP);
  else
    changeenshift (si, 1);
}

void
flatten_key (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  if (curmudelaobj && curmudelaobj->type == STEMDIRECTIVE)
    change_stem_directive (si, DENEMO_STEMDOWN);
  else
    changeenshift (si, -1);
}

void
tie_notes_key (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    {
      nextmeasure (si);
      object_insert (si, clone_object (curmudelaobj));
      ((chord *) curmudelaobj->object)->is_tied =
	!((chord *) curmudelaobj->object)->is_tied;
    }
}

void
add_dot_key (struct scoreinfo *si)
{
  changedots (si, 1);
}

void
remove_dot_key (struct scoreinfo *si)
{
  changedots (si, -1);
}


void
add_accent (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
	  ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(D_ACCENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
    
}

void
add_fermata (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
  ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(FERMATA,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
    
}

void
add_staccato (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
	  ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(STACCATO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
		 
   
}

void
add_tenuto (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TENUTO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}


void
add_trill (struct scoreinfo *si)
{
/*  note *curr;*/
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TRILL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void
add_turn (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
   ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TURN,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void
add_mordent (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(MORDENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);

}

void
add_staccatissimo (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(STACCATISSIMO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);

}

void add_coda(struct scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(CODA,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);

	
}


void add_flageolet(struct scoreinfo *si) 
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(FLAGEOLET,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_open(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(OPEN,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
	
}

void add_prallmordent(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(PRALLMORDENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_prallprall(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(PRALLPRALL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_prall(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(PRALL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_reverseturn(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(REVERSETURN,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_segno(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(SEGNO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_sforzato(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(SFORZATO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_stopped(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(STOPPED,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_thumb(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(THUMB,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_trillelement(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TRILLELEMENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_trill_element(struct scoreinfo *si) 
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TRILLELEMENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}
void add_upprall(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(UPPRALL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_arpeggio(struct scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(D_ARPEGGIO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

	

void
set_grace (struct scoreinfo *si)
{
  insertgrace (si);
}

void
force_cautionary (struct scoreinfo *si)
{
  mudelaobject *theobj =
    si->currentobject ? (mudelaobject *) si->currentobject->data : NULL;
  if (theobj && theobj->type == CHORD)
    caution (si);

}

void
change_pitch (struct scoreinfo *si)
{
  mudelaobject *theobj =
    si->currentobject ? (mudelaobject *) si->currentobject->data : NULL;
  tonechange(si,TRUE);
  addtone(theobj, si->cursor_y, si->cursoraccs[si->staffletter_y],
		 si->cursorclef);
	displayhelper(si);
}


void
insert_doublebar (struct scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Double"))));
}

void
insert_endbar(struct scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname ( _("End"))));
}

void 
insert_openrepeat(struct scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Open Repeat"))));
}

void insert_closerepeat(struct scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Close Repeat"))));
}

void insert_opencloserepeat(struct scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Double"))));
}
