/* staffops.h
 * Header file for functions dealing with whole staffs

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller */

/* This function returns a staff containing n empty measures */

#ifndef __STAFFOPS_H__
#define __STAFFOPS_H__

enum newstaffcallbackaction
{ INITIAL, FIRST, LAST, ADDFROMLOAD, BEFORE, AFTER,
  NEWVOICE,LYRICSTAFF, FIGURESTAFF
};


#include <denemo/denemo.h>
#include <gtk/gtk.h>

struct newstaffinfotopass {
  struct scoreinfo *si;
  guint addat;
};

objnode *firstobjnode (measurenode *mnode);

objnode *lastobjnode (measurenode *mnode);

measurenode *firstmeasurenode (staffnode *thestaff);

measurenode *
nth_measure_node_in_staff (staffnode *thestaff, gint n);

objnode *firstobjnodeinstaff (staffnode *thestaff);

void initkeysig (gint *accs, gint number);

void setcurrentprimarystaff (struct scoreinfo *si);

void newstaff (struct scoreinfo *si, enum newstaffcallbackaction action);

void removestaff (struct scoreinfo *si, gint pos, gint numstaffs);

void beamsandstemdirswholestaff (staff *thestaff);

void showwhichaccidentalswholestaff (staff *thestaff);

void fixnoteheights (staff *thestaff);

void newstaffinitial(GtkAction *action, gpointer data);

void newstaffbefore(GtkAction *action, gpointer data);

void newstaffafter(GtkAction *action, gpointer data);

void newstafflyric(GtkAction *action, gpointer data);

void newstafffigured(GtkAction *action, gpointer data);

void newstaffvoice(GtkAction *action, gpointer data);

void newstafflast(GtkAction *action, gpointer data);

#endif /* __STAFFOPS_H__ */
