/* staffpropdialog.cpp
 * callback that creates a "Staff Properties" dialog box asking
 * the user to change the properties of the current staff

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller */

#include <gtk/gtk.h>
#include "calculatepositions.h"
#include "chordops.h"
#include "contexts.h"
#include <denemo/denemo.h>
#include "processstaffname.h"
#include "staffops.h"
#include "utils.h"
#include <stdlib.h>
#include <string.h>

static gchar *instruments[128] = {
  "acoustic grand",
  "bright acoustic",
  "electric grand",
  "honky-tonk",
  "electric piano 1",
  "electric piano 2",
  "harpsichord",
  "clav",
  "celesta",
  "glockenspiel",
  "music box",
  "vibraphone",
  "marimba",
  "xylophone",
  "tubular bells",
  "dulcimer",
  "drawbar organ",
  "percussive organ",
  "rock organ",
  "church organ",
  "reed organ",
  "accordion",
  "harmonica",
  "concertina",
  "acoustic guitar (nylon)",
  "acoustic guitar (steel)",
  "electric guitar (jazz)",
  "electric guitar (clean)",
  "electric guitar (muted)",
  "overdriven guitar",
  "distorted guitar",
  "guitar harmo(dinics",
  "acoustic bass",
  "electric bass (finger)",
  "electric bass (pick)",
  "fretless bass",
  "slap bass 1",
  "slap bass 2",
  "synth bass 1",
  "synth bass 2",
  "violin",
  "viola",
  "cello",
  "contrabass",
  "tremolo strings",
  "pizzicato strings",
  "orchestral strings",
  "timpani",
  "string ensemble 1",
  "string ensemble 2",
  "synthstrings 1",
  "synthstrings 2",
  "choir aahs",
  "voice oohs",
  "synth voice",
  "orchestra hit",
  "trumpet",
  "trombone",
  "tuba",
  "muted trumpet",
  "french horn",
  "brass section",
  "synthbrass 1",
  "synthbrass 2",
  "soprano sax",
  "alto sax",
  "tenor sax",
  "baritone sax",
  "oboe",
  "english horn",
  "bassoon",
  "clarinet",
  "piccolo",
  "flute",
  "recorder",
  "pan flute",
  "blown bottle",
  "skakuhachi",
  "whistle",
  "ocarina",
  "lead 1 (square)",
  "lead 2 (sawtooth)",
  "lead 3 (calliope)",
  "lead 4 (chiff)",
  "lead 5 (charang)",
  "lead 6 (voice)",
  "lead 7 (fifths)",
  "lead 8 (bass+lead)",
  "pad 1 (new age)",
  "pad 2 (warm)",
  "pad 3 (polysynth)",
  "pad 4 (choir)",
  "pad 5 (bowed)",
  "pad 6 (metallic)",
  "pad 7 (halo)",
  "pad 8 (sweep)",
  "fx 1 (rain)",
  "fx 2 (soundtrack)",
  "fx 3 (crystal)",
  "fx 4 (atmosphere)",
  "fx 5 (brightness)",
  "fx 6 (goblins)",
  "fx 7 (echoes)",
  "fx 8 (sci-fi)",
  "sitar",
  "banjo",
  "shamisen",
  "koto",
  "kalimba",
  "bagpipe",
  "fiddle",
  "shanai",
  "tinkle bell",
  "agogo",
  "steel drums",
  "woodblock",
  "taiko drum",
  "melodic tom",
  "synth drum",
  "reverse cymbal",
  "guitar fret noise",
  "breath noise",
  "seashore",
  "bird tweet",
  "telephone ring",
  "helicopter",
  "applause",
  "gunshot"
};

struct callbackdata
{
  struct scoreinfo *si;
  staff *staffstruct;
  GtkWidget *nameentry;
  GtkWidget *aboveentry;
  GtkWidget *belowentry;
  GtkWidget *numlinesentry;
  GtkWidget *transposeentry;
  GtkWidget *volume;
  GtkWidget *posinhalflinesentry;
  GtkWidget *midientry;
};

/* Actually sets staff properties */

void
set_properties (gpointer data)
{
  struct callbackdata *cbdata = (struct callbackdata *) data;
  staff *staffstruct = cbdata->staffstruct;
  gint n;

  canonicalize_denemo_name
    ((gchar *) gtk_entry_get_text (GTK_ENTRY (cbdata->nameentry)),
     staffstruct->denemo_name);
  set_lily_name (staffstruct->denemo_name, staffstruct->lily_name);

  /* !!!! Insert advisory function for detecting colliding staff names
   * here */

  g_string_assign (staffstruct->midi_instrument,
		   gtk_entry_get_text (GTK_ENTRY (cbdata->midientry)));
  if ((n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->aboveentry)))))
    staffstruct->space_above = n;
  if ((n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->belowentry)))))
    staffstruct->space_below = n;
  if ((n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->numlinesentry)))))
    staffstruct->no_of_lines = n;
  if ((n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->transposeentry)))))
    staffstruct->transposition = n;
  if ((n =
       atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->posinhalflinesentry)))))
    staffstruct->pos_in_half_lines = n;
  if ((n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->volume)))))
    staffstruct->volume = n;
  beamsandstemdirswholestaff (staffstruct);
  find_xes_in_all_measures (cbdata->si);
  /* (To adjust the stem directions of the notes, if necessary) */

  gtk_widget_draw (cbdata->si->scorearea, NULL);
}

gboolean staff_properties_change (GtkAction * action, gpointer callback_data)
{
  struct scoreinfo *si;
  guint callback_action = 0;
  gboolean result = FALSE;
#ifdef DEBUG
  g_print ("Action %d\n",  *action);
#endif
  if (action)
    si = (struct scoreinfo *) callback_data;
  else
    {
      struct newstaffinfotopass *cbdata1 =
	(struct newstaffinfotopass *) callback_data;
      si = (struct scoreinfo *) cbdata1->si;
      callback_action = cbdata1->addat;
    }

  staff *staffstruct;
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *nameentry;
  GtkWidget *aboveentry;
  GtkWidget *belowentry;
  GtkWidget *numlinesentry;
  GtkWidget *transposeentry;
  GtkWidget *posinhalflinesentry;
  GtkWidget *volume;
  GtkWidget *midicombo;
  static GString *entrycontent;
  GList *instrument_list = NULL;
  static struct callbackdata cbdata;

  if (callback_action)
    staffstruct =
      (staff *) g_list_nth (si->thescore, callback_action - 1)->data;
  else
    staffstruct = (staff *) si->currentstaff->data;

  if (!entrycontent)
    {
      entrycontent = g_string_new (NULL);
    }

  dialog = gtk_dialog_new_with_buttons (_("Staff Properties"),
					GTK_WINDOW (si->window),
					(GtkDialogFlags)
					(GTK_DIALOG_MODAL |
					 GTK_DIALOG_DESTROY_WITH_PARENT),
					GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
					GTK_STOCK_CANCEL, GTK_STOCK_CANCEL,
					NULL);

  table = gtk_table_new (4, 5, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (table), 12);
  gtk_table_set_row_spacings (GTK_TABLE (table), 8);
  gtk_table_set_col_spacings (GTK_TABLE (table), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), table,
		      TRUE, TRUE, 0);

  label = gtk_label_new (_("Staff name:"));
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);

  nameentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (nameentry), staffstruct->denemo_name->str);
  gtk_table_attach (GTK_TABLE (table), nameentry, 1, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (nameentry);

  label = gtk_label_new (_("Space above:"));
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);

  aboveentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->space_above);
  gtk_entry_set_text (GTK_ENTRY (aboveentry), entrycontent->str);
  gtk_table_attach (GTK_TABLE (table), aboveentry, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (aboveentry);

  label = gtk_label_new (_("Space below:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);
  belowentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->space_below);
  gtk_entry_set_text (GTK_ENTRY (belowentry), entrycontent->str);
  gtk_table_attach (GTK_TABLE (table), belowentry, 1, 2, 2, 3,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (belowentry);

  label = gtk_label_new (_("Number of lines:"));
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);
  numlinesentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->no_of_lines);
  gtk_entry_set_text (GTK_ENTRY (numlinesentry), entrycontent->str);
  gtk_table_attach (GTK_TABLE (table), numlinesentry, 3, 4, 0, 1,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (numlinesentry);

  label = gtk_label_new (_("Transposition:"));
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);
  transposeentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->transposition);
  gtk_entry_set_text (GTK_ENTRY (transposeentry), entrycontent->str);
  gtk_table_attach (GTK_TABLE (table), transposeentry, 3, 4, 1, 2,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (transposeentry);

  label = gtk_label_new (_("Position in half-lines:"));
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);
  posinhalflinesentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->pos_in_half_lines);
  gtk_entry_set_text (GTK_ENTRY (posinhalflinesentry), entrycontent->str);
  gtk_table_attach (GTK_TABLE (table), posinhalflinesentry,
		    3, 4, 2, 3, (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (posinhalflinesentry);

  label = gtk_label_new (_("MIDI Instrument:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);
  midicombo = gtk_combo_new ();
  if (!instrument_list)
    for (int i = 0; i < 128; i++)
      {
	instrument_list = g_list_append (instrument_list, instruments[i]);
      }
  gtk_combo_set_popdown_strings (GTK_COMBO (midicombo), instrument_list);

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (midicombo)->entry),
		      staffstruct->midi_instrument->str);
  gtk_table_attach (GTK_TABLE (table), midicombo, 1, 2, 3, 4,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (midicombo);

  label = gtk_label_new (_("Volume:"));
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 3, 4,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (label);
  volume = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->volume);
  gtk_entry_set_text (GTK_ENTRY (volume), entrycontent->str);
  gtk_table_attach (GTK_TABLE (table), volume, 3, 4, 3, 4,
		    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (volume);



  gtk_widget_show (table);

  /* Set up the callback data */

  cbdata.si = si;
  cbdata.staffstruct = staffstruct;
  cbdata.nameentry = nameentry;
  cbdata.aboveentry = aboveentry;
  cbdata.belowentry = belowentry;
  cbdata.numlinesentry = numlinesentry;
  cbdata.transposeentry = transposeentry;
  cbdata.posinhalflinesentry = posinhalflinesentry;
  cbdata.volume = volume;
  cbdata.midientry = GTK_COMBO (midicombo)->entry;

  /* Also set things up so that the callback'll run when you hit enter
   * in the text entries */
  //processenter (nameentry, set_properties, cbdata,dialog);
  //processenter (aboveentry, set_properties, cbdata, dialog);
  //processenter (belowentry, set_properties, cbdata, dialog);
  //processenter (numlinesentry, set_properties, cbdata, dialog);
  //processenter (transposeentry, set_properties, cbdata, dialog);
  //processenter (posinhalflinesentry, set_properties, cbdata, dialog);
  //processenter (GTK_COMBO (midicombo)->entry, set_properties, cbdata, dialog);



  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
  gtk_widget_grab_focus (nameentry);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      set_properties (&cbdata);
      result = TRUE;
    }
  gtk_widget_destroy (dialog);

  return result;
}
