/* playback.cpp
 * Midi playback for a specific portion of
 * a score
 *
 * (c) 2000-2005 Adam Tee
 */


#include <denemo/denemo.h>
#include "exportmudela.h"
#include "exportmidi.h"
#include "staffops.h"
#include "scoreops.h"
#include "dialogs.h"
#include "prefops.h"
#include "utils.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif
#include <errno.h>



void
playback (GtkAction * action, scoreinfo *si)
{
  static GString *filename = NULL;
  GError* err = NULL;

 
  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoplayback.mid");
    }
    
  exportmidi (filename->str, si, si->start, si->end);
  fflush (0);
 
  gchar* argv[] = {
    si->prefs->midiplayer->str,
    filename->str,
    NULL
  };
  
  
  g_spawn_sync(NULL, /* dir */
	       argv,
	       NULL, /* env */
	       G_SPAWN_SEARCH_PATH,
	       NULL, /* child setup func */
               NULL, /* user data */
	       NULL, /* stdout */
	       NULL, /* stderr */
	       NULL,
	       &err);

  if (err != NULL)
    {
      g_warning("%s", err->message);
      g_error_free(err);
    }



    
  /* Otherwise, this is the parent process, in which case we simply
   * want to return the user to his or her regularly scheduled
   * music-making */
}

void
playback_local (gpointer callback_data, guint callback_action,
		GtkWidget * widget)
{
  static GString *filename = NULL;
 
 
  GError* err = NULL;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;

  if (!filename)
  {
    filename = g_string_new (locatedotdenemo ());
    g_string_append (filename, "/denemoplayback");
   
  }
  
  

  GString *thefilename = g_string_new (filename->str);
  g_string_append (filename, ".mid");
  exportmidi (thefilename->str, si, si->start, si->end); 
  fflush (0);
 
  gchar* argv[] = {
    si->prefs->midiplayer->str,
    filename->str,
    NULL
  };
  
  gint exit_status;
  g_spawn_sync(NULL, /* dir */
	       argv,
	       NULL, /* env */
	       G_SPAWN_SEARCH_PATH,
	       NULL, /* child setup func */
               NULL, /* user data */
	       NULL, /* stdout */
	       NULL, /* stderr */
	       &exit_status,
	       &err);

  if (err != NULL)
    {
      g_warning("%s", err->message);
      g_error_free(err);
    }

  /* Otherwise, this is the parent process, in which case we simply
   * want to return the user to his or her regularly scheduled
   * music-making */
}
