#include "includes.h"
#include "dbus_service.h"
#include "dhcp_options.h"
#include "dhcdbd.h"

int
dhcdbd_log
( const char *fmt, ... )
{
    va_list va;
    va_start(va, fmt);
    vprintf( fmt, va);
    printf("\n");
    va_end(va);
    return 0;
}

dbus_svc_HandlerResult
dhcdbd_message_filter
(   DBUS_SVC dbus,
    dbus_svc_MessageType type,
    uint8_t  reply_expected,  
    uint32_t serial,          
    char *destination,  
    char *path,         
    char *member,       
    char *interface,    
    char *if_suffix,
    char *sender,       
    char *signature,  
    dbus_svc_MessageHandle msg,
    char *prefix,
    char *suffix,
    void       *prefixObject,
    void       *object
) 
{ /* Filter to shutdown when dbus-daemon shuts down */
    char dhpath[1024], a[16];
    uint32_t *routers=0L, *ip_address=0L, *subnet_mask=0L, *rp=0L, *domain_name,  *domain_name_servers, length=0,
	     *s=0, *dnsp;
    uint8_t state, r;
    
    if (  ( type == SIGNAL )
	&&( strcmp(path,"/org/freedesktop/DBus/Local") == 0 )
	&&( strcmp(member,"Disconnected") == 0 )
       ) 
    {
	dhcdbd_log("Filtered QUIT message OK");
	dbus_svc_quit( dbus );
    }
    if ( strncmp(interface,"com.redhat.dhcp",15) == 0 )
    {
	if( strncmp(signature,"y",1) == 0)
	{
	    r = dbus_svc_get_args(dbus, msg, (int)'y', &state, TYPE_INVALID);

	    if( r == 1 )
	    {	
		if( ( state != DHC_PREINIT ) && (state != DHC_START) && (state != DHC_END) )
		{
		    length=0;
		    snprintf(dhpath, 1024, "/com/redhat/dhcp/%s", member); 
		    msg = dbus_svc_call
			( dbus,
			  "com.redhat.dhcp",
			  dhpath,
			  "reason",
			  "com.redhat.dhcp.text.get",
			  TYPE_INVALID
			);
		    if( msg != 0L)
		    {		    
			if( dbus_svc_get_args(dbus, msg,
					      's', &s, TYPE_INVALID
					     ) 
			    == 0 
			  )
			{
			    dhcdbd_log("dbus_svc_get_args failed");
			}else
			{
			    if(s != 0L)			    
				dhcdbd_log("\n if: %s  state: %u %s", member, state, s);
			    else
				dhcdbd_log("\n if: %s  state: %u", member, state);
			}
		    }
		}else
		{
		    dhcdbd_log("\n if: %s  state: %u %s", member, state,
			       (state == DHC_PREINIT) 
			       ? "PREINIT" : 
			       ((state == DHC_START) ? "START" : "END")
			      );

		    state = DHC_INVALID;
		}
		if( (state == DHC_BOUND )
		  ||(state == DHC_REBOOT)
		  ||(state == DHC_REBIND)
		  )    
		{		    
		    length=0;
		    msg = dbus_svc_call
		    ( dbus,
		      "com.redhat.dhcp",
		      dhpath,
		      "ip_address",
		      "com.redhat.dhcp.binary.get",
		      TYPE_INVALID
		    );
		    if( msg != 0L)
		    {
			
			if( dbus_svc_get_args(dbus, msg, 
					      'a', 'y', &ip_address, &length, TYPE_INVALID
				             )
			    == 0 
			  )
			{
			    dhcdbd_log("dbus_svc_get_args failed");
			}else
			{
			    if(  (ip_address > 0)
			      && (length >= sizeof(uint32_t))
			      && ((length % sizeof(uint32_t)) == 0)
			      )
				dhcdbd_log("   IP ADDRESS:\t\t%s", 
					       inet_ntop(AF_INET, (struct in_addr*)ip_address, &a[0], 16)
				          );
			    else
				dhcdbd_log("   bad ip-address %p length %u", ip_address, length);
			}
		    }		
		    length=0;
		    msg = dbus_svc_call
		    ( dbus,
		      "com.redhat.dhcp",
		      dhpath,
		      "subnet_mask",
		      "com.redhat.dhcp.binary.get",
		      TYPE_INVALID
		    );
		    if( msg != 0L)
		    {
			
			if( dbus_svc_get_args(dbus, msg,
					      'a', 'y', &subnet_mask, &length, TYPE_INVALID
				             ) 
			    == 0 
			  )
			{
			    dhcdbd_log("dbus_svc_get_args failed");
			}else
			{
			    if(  (subnet_mask > 0)
			      && (length >= sizeof(uint32_t))
			      && ((length % sizeof(uint32_t)) == 0)
			      )
				dhcdbd_log("   SUBNET MASK:\t\t%s", 
					   inet_ntop(AF_INET, (struct in_addr*)subnet_mask, &a[0], 16)
				          );
			    else
				dhcdbd_log("   bad subnet_mask %p length %u", ip_address, length);
			}
		    }		    
		    length=0;
		    msg = dbus_svc_call
		    ( dbus,
		      "com.redhat.dhcp",
		      dhpath,
		      "routers",
		      "com.redhat.dhcp.binary.get",
		      TYPE_INVALID
		    );
		    if( msg != 0L)
		    {
			
			if( dbus_svc_get_args(dbus, msg, 
					      'a', 'y', &routers, &length, TYPE_INVALID
				             ) == 0 
			  )
			{
			    dhcdbd_log("dbus_svc_get_args failed");
			}else
			{
			    if(  (routers > 0)
			      && (length >= sizeof(uint32_t))
			      && ((length % sizeof(uint32_t)) == 0)
			      )
				for(rp = routers; rp < (uint32_t*)(((uint8_t*)routers)+length); rp++)
				    dhcdbd_log("   ROUTER:\t\t%s", 
					       inet_ntop(AF_INET, (struct in_addr*)rp, &a[0], 16)
					      );
			    else
				dhcdbd_log("   bad routers %p length %u", ip_address, length);
			}
		    }
		    length=0;
		    msg = dbus_svc_call
		    ( dbus,
		      "com.redhat.dhcp",
		      dhpath,
		      "domain_name",
		      "com.redhat.dhcp.binary.get",
		      TYPE_INVALID
		    );
		    if( msg != 0L)
		    {			
			if( dbus_svc_get_args(dbus, msg,
					      'a', 'y', &domain_name, &length, TYPE_INVALID
				             ) == 0 
			  )
			{
			    dhcdbd_log("dbus_svc_get_args failed");
			}else
			{
			    if( domain_name > 0 )
				dhcdbd_log("   DOMAIN_NAME:\t\t%s", 
					   domain_name
				    );
			    else
				dhcdbd_log("   bad domain-name %p length %u", ip_address, length);
			}
		    }
		    length=0;
		    msg = dbus_svc_call
		    ( dbus,
		      "com.redhat.dhcp",
		      dhpath,
		      "domain_name_servers",
		      "com.redhat.dhcp.binary.get",
		      TYPE_INVALID
		    );
		    if( msg != 0L)
		    {			
			if( dbus_svc_get_args(dbus, msg,
					      'a', 'y', &domain_name_servers, &length, TYPE_INVALID
				             ) == 0 
			  )
			{
			    dhcdbd_log("dbus_svc_get_args failed");
			}else
			{
			    if(  (domain_name > 0)
			      && (length >= sizeof(uint32_t))
			      && ((length % sizeof(uint32_t)) == 0)
			      )
				for(dnsp = domain_name_servers; dnsp < (uint32_t*)(((uint8_t*)domain_name_servers)+length); dnsp++)
				    dhcdbd_log("   DNS SERVER:\t\t%s", 
					       inet_ntop(AF_INET, (struct in_addr*)dnsp, &a[0], 16)
					      );
			    else
				dhcdbd_log("   bad domain-name_servers %p length %u", domain_name_servers, length);
			}
		    }		    
		}
	    }
	}
	
	return NOT_HANDLED;
    }
    return HANDLED;
}

int main( int argc, char **argv, char **envp )
{
    DBUS_SVC dbus;
    dhcdbd_log("starting up");

    dbus = dbus_svc_init( DBUS_SYSTEM, 0L, 0L, 0L );

    if ( dbus == 0L )
    {
	dhcdbd_log("Failed to initialise D-Bus service.\n");
	return( 1 );
    }
	
    if ( !dbus_svc_add_message_filter
	 ( dbus, dhcdbd_message_filter,1,
	   "type=signal"
	 )
       )return( 1 );
    
    dbus_svc_main_loop( dbus, 0L);

    return(0);
}
