
sub dc_debconf_select (){
    my $class    = shift;
    my $priority = shift;
    my $question = "shared/packages-$class";

    $priority = "critical" if not $priority;
    
    if ( $class eq "ispell" ){
	$title = "Dictionaries-common: Ispell dictionary"; 
    } else {
	$title = "Dictionaries-common: Wordlist dictionary"; 
    }
    
    my ($errorcode,$pkgowners) = metaget ($question, "owners");
    return if $errorcode;
    
    my @choices = ();
    foreach (split (/\s*,\s*/, $pkgowners)){
	my $entry = metaget ("$_/languages", "default");
	for ( $entry ){ # trim leading/trailing whitespaces the perlfaq way
	    s/^\s+//;
	    s/\s+$//;
	}
	push (@choices, split(/\s*,\s*/, $entry));
    }
    my $choices = join (', ', sort {lc $a cmp lc $b} @choices);

    $question = "dictionaries-common/default-$class";
    if ($choices ne metaget ($question, "choices")) {
	subst ($question, "choices", $choices);
	fset ($question, "seen", "false");
    }

    input ($priority, $question);
    title ($title);
    go ();
}

1;

