//C-  -*- C++ -*-
//C- -------------------------------------------------------------------
//C- Xmltools for DjVu3 and DjVuLibre-3.5
//C- Copyright (c) 2002  Bill C. Riemers
//C- -------------------------------------------------------------------
//C- This software is subject to, and may be distributed under, the
//C- GNU General Public License, Version 2. The license should have
//C- accompanied the software or you may obtain a copy of the license
//C- from the Free Software Foundation at http://www.fsf.org .
//C-
//C- This program is distributed in the hope that it will be useful,
//C- but WITHOUT ANY WARRANTY; without even the implied warranty of
//C- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//C- GNU General Public License for more details.
//C- 
//C- I, Bill C. Riemers, hereby grant all rights to this code,
//C- provided usage complies with the GPL or a written exception to 
//C- the GPL granted by any of Bill C. Riemers, Leon Bottou, 
//C- Yann Le Cun, or the Free Source Foundation.
//C-
//C- ------------------------------------------------------------------
//C- DjVuLibre-3.5 is derived from the DjVu(r) Reference Library
//C- distributed by Lizardtech Software.  On July 19th 2002, Lizardtech 
//C- Software authorized us to replace the original DjVu(r) Reference 
//C- Library notice by the following text (see doc/lizard2002.djvu):
//C-
//C-  ------------------------------------------------------------------
//C- | DjVu (r) Reference Library (v. 3.5)
//C- | Copyright (c) 1999-2001 LizardTech, Inc. All Rights Reserved.
//C- | The DjVu Reference Library is protected by U.S. Pat. No.
//C- | 6,058,214 and patents pending.
//C- |
//C- | This software is subject to, and may be distributed under, the
//C- | GNU General Public License, Version 2. The license should have
//C- | accompanied the software or you may obtain a copy of the license
//C- | from the Free Software Foundation at http://www.fsf.org .
//C- |
//C- | The computer code originally released by LizardTech under this
//C- | license and unmodified by other parties is deemed "the LIZARDTECH
//C- | ORIGINAL CODE."  Subject to any third party intellectual property
//C- | claims, LizardTech grants recipient a worldwide, royalty-free, 
//C- | non-exclusive license to make, use, sell, or otherwise dispose of 
//C- | the LIZARDTECH ORIGINAL CODE or of programs derived from the 
//C- | LIZARDTECH ORIGINAL CODE in compliance with the terms of the GNU 
//C- | General Public License.   This grant only confers the right to 
//C- | infringe patent claims underlying the LIZARDTECH ORIGINAL CODE to 
//C- | the extent such infringement is reasonably necessary to enable 
//C- | recipient to make, have made, practice, sell, or otherwise dispose 
//C- | of the LIZARDTECH ORIGINAL CODE (or portions thereof) and not to 
//C- | any greater extent that may be necessary to utilize further 
//C- | modifications or combinations.
//C- |
//C- | The LIZARDTECH ORIGINAL CODE is provided "AS IS" WITHOUT WARRANTY
//C- | OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
//C- | TO ANY WARRANTY OF NON-INFRINGEMENT, OR ANY IMPLIED WARRANTY OF
//C- | MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//C- +------------------------------------------------------------------
// 
// $Id: djvuxmlparser.cpp,v 1.7 2003/11/07 22:08:23 leonb Exp $
// $Name: release_3_5_16 $

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if NEED_GNUG_PRAGMAS
# pragma implementation
#endif

#include "XMLParser.h"
#include "XMLTags.h"
#include "GOS.h"
#include "GURL.h"
#include "DjVuDocument.h"
#include "ByteStream.h"
#include "DjVuMessage.h"
#include <stdio.h>
#include <ctype.h>
#include <locale.h>
#include <stdlib.h>

int 
main(int argc,char *argv[],char *[])
{
  setlocale(LC_ALL,"");
  djvu_programname(argv[0]);
  GArray<GUTF8String> dargv(0,argc-1);
  for(int i=0;i<argc;++i)
    dargv[i]=GNativeString(argv[i]);
  G_TRY
  {
    bool is_valid=(argc >= 2);
    if((is_valid=(argc>=2)))
    {
      int i=1;
      do {
        if(! GURL::Filename::Native(argv[i]).is_file())
        {
          is_valid=false;
          DjVuPrintErrorUTF8("Error: File '%s' does not exist.\n",argv[i]);
          exit(1);
        }
      } while (++i<argc);
    }
    if(! is_valid)
    {
      DjVuPrintErrorUTF8("Usage: %s <inputfiles>\n",argc?argv[0]:"-");
      exit(1);
    }

    for(int i=1;i<argc;++i)
    {
      const GP<lt_XMLParser> parser(lt_XMLParser::create());
      {
        const GP<lt_XMLTags> tag(
          lt_XMLTags::create(GURL::Filename::Native(dargv[i])));
        parser->parse(*tag);
      }
      parser->save();
    }
  }
  G_CATCH(ex)
  {
    ex.perror();
    exit(1);
  }
  G_ENDCATCH;
  exit(0);
#ifdef WIN32
  return 0;
#endif
}

