%{!?kernel: %{expand: %%define kernel %(uname -r)}}

Summary: Utilities for Eagle driven usb modem
Name: eagle-usb
Version: 1.9.9
Release: 0.1
License: GPL
Group: Networking/Daemons
Source0: %{name}-%{version}.tar.bz2
URL: http://www.eagle-usb.org
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Provides: %{name} = %{version}
Obsoletes: adiusbadsl, eagle

%description
This is an enhanced version of the Linux driver for DSL modems based
on the Analog chipset Eagle 8051. The Sagem F@st 800 modem as well as
USRobotics DSL modems are based on this chipset.

Depending on your setup/isp, you might also need ppp and/or a dhcp client.
  
You'll find latest revision of this driver and a dedicated french
newsgroup at the following URL:

http://www.eagle-usb.org

%prep

%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%pre

%post
hash -r

%preun
%{_sbindir}/fctStopAdsl -sf
# remove hotplug specific scripts
if [ -d /etc/hotplug/usb ] ; then
	rm -f /etc/hotplug/usb/eagle-usb*
fi
# disable [and remove] autostart service
# - mandrake specific script
if test -e /etc/init.d/internet ; then \
	chkconfig --del internet &>/dev/null ; \
fi
# - generic script
if test -e /etc/init.d/eagle-usb ; then \
	chkconfig --del eagle-usb &>/dev/null ; \
	update-rc.d -f eagle-usb remove &>/dev/null ; \
	rm -f /etc/init.d/eagle-usb ; \
fi

%postun
hash -r

%files
%defattr(-,root,root)
#%doc README TODO
%{_mandir}/man8/eagleconfig.8.bz2
%{_mandir}/man8/eaglectrl.8.bz2
%{_mandir}/man8/eaglediag.8.bz2
%{_mandir}/man8/eaglestat.8.bz2
%{_mandir}/man8/fctStartAdsl.8.bz2
%{_mandir}/man8/fctStopAdsl.8.bz2
%{_mandir}/man8/pppoa.8.bz2
%{_mandir}/man8/startadsl.8.bz2
%{_mandir}/man8/startmire.8.bz2
%{_mandir}/man8/stopadsl.8.bz2
%{_sbindir}/fctStartAdsl
%{_sbindir}/fctStopAdsl
%{_sbindir}/startadsl
%{_sbindir}/startmire
%{_sbindir}/stopadsl
%{_sbindir}/eagleconnect.tcl
%{_sbindir}/eagleconfig
%{_sbindir}/eaglectrl
%{_sbindir}/eaglediag
%{_sbindir}/eaglestat
%{_sbindir}/pppoa
%dir %{_sysconfdir}/%{name}
%dir %{_sysconfdir}/%{name}/dsp
%{_sysconfdir}/%{name}/dsp/dsp_code_pots.bin
%{_sysconfdir}/%{name}/dsp/dsp_code_isdn.bin
%dir %{_sysconfdir}/%{name}/lang
%{_sysconfdir}/%{name}/lang/de
%{_sysconfdir}/%{name}/lang/en
%{_sysconfdir}/%{name}/lang/es
%{_sysconfdir}/%{name}/lang/fr
%{_sysconfdir}/%{name}/lang/f2
%{_sysconfdir}/%{name}/lang/it
%{_sysconfdir}/%{name}/lang/pl
%{_sysconfdir}/%{name}/lang/p2
%dir %{_sysconfdir}/%{name}/eagleconnect
%{_sysconfdir}/%{name}/eagleconnect/diagnostic.tcl
%dir %{_sysconfdir}/%{name}/eagleconnect/lang
%{_sysconfdir}/%{name}/eagleconnect/lang/fr.msg
%{_sysconfdir}/%{name}/eagleconnect/parameagleconnect.tcl
%{_sysconfdir}/%{name}/eagleconnect/reseau.tcl
%dir %{_sysconfdir}/%{name}/scripts
%{_sysconfdir}/%{name}/scripts/eagle-usb.conf.template
%{_sysconfdir}/%{name}/scripts/eu_config_bash
%{_sysconfdir}/%{name}/scripts/eu_dsp
%{_sysconfdir}/%{name}/scripts/eu_init
%{_sysconfdir}/%{name}/scripts/options
%{_sysconfdir}/%{name}/scripts/setvars
%{_sysconfdir}/%{name}/scripts/testconnec
%{_sysconfdir}/%{name}/scripts/usb.usermap
%{_sysconfdir}/%{name}/scripts/lock
%{_sysconfdir}/sysconfig/network-scripts/net_cnx_*
%config(noreplace) %{_sysconfdir}/%{name}/eagleconnect.conf
#( % configure )

%changelog
* Tue Jun 08 2004 Olivier Borowski <coin@tuxfamily.org> 1.9.8
- ChangeLog: check http://www.eagle-usb.org

* Mon Mar 22 2004 Olivier Borowski <coin@tuxfamily.org> 1.9.7
- separate eagleconfig into two parts
- change hotplug scripts location
- improved uninstall method
- minor changes & bugfixes...

* Wed Mar 04 2004 Frederic Hermann <Frederic.Hermann@neptune.fr> 1.9.6-2
- Change "/usr/local/sbin" to "%{prefix}"
- Use default rpm "./configure" values
- replace "/etc" by "%{sysconfdir}

* Fri Feb 20 2004 Olivier Borowski <coin@tuxfamily.org> 1.9.6
- ChangeLog: check http://eagle-usb.ath.cx

* Sat Feb 14 2004 Olivier Borowski <coin@tuxfamily.org> 1.9.5
- ChangeLog: check http://eagle-usb.ath.cx

* Mon Dec 22 2003 Herv Guehl <herve@linusk.net> 1.9.0
- Initial Revision (RH9.0 - kernel2.6)

#=============================== kernel module ===============================
%package module-%{kernel}
Summary: Kernel module for Eagle driven usb modem
Group:System Environment/Kernel

%description module-%{kernel}
Kernel module for Analog chipset Eagle 8051 The Sagem F@st 800/908 modem as well as
USRobotics DSL modems are based on this chipset.

%pre module-%{kernel}

%post module-%{kernel}
depmod -a

%preun module-%{kernel}
if lsmod | grep -q eagle-usb ; then
	rmmod eagle-usb
fi

%postun module-%{kernel}
depmod -a

%files module-%{kernel}
%defattr(-,root,root)
/lib/modules/%{kernel}/misc/eagle-usb.*

%changelog module-%{kernel}
* Tue Jun 08 2004 Olivier Borowski <coin@tuxfamily.org> 1.9.8
- ChangeLog: check http://www.eagle-usb.org

* Fri Feb 20 2004 Olivier Borowski <coin@tuxfamily.org> 1.9.6
- ChangeLog: check http://eagle-usb.ath.cx

* Sat Feb 14 2004 Olivier Borowski <coin@tuxfamily.org> 1.9.5
- ChangeLog: check http://eagle-usb.ath.cx

* Mon Dec 22 2003 Herv Guehl <herve@linusk.net> 1.9.0
- Initial Revision (RH9.0 - kernel2.6)
