#
#   eagleconfig: configuration utility for eagle USB modems
#
#   Copyright (C) 2003 Jerome Marant <jerome.marant@sagem.com>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License Version 2 as 
#   published by the Free Software Foundation.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#   or contact the author.
#
#   $Id: modem.pl,v 1.1 2004/02/15 12:50:16 Tux Exp $
#

my $restart_command = "eaglectrl";
my $modem_up = 'grep "Modem is operational" /proc/adimodem';

sub vpi ($)
  {
    my ($vpi) = @_;

    my $title = "Modem parameters: VPI";
    my $desc = "";

    my ($status, $value);

    ($status, $value) = inputbox($desc, $title, $$vpi);
    $$vpi = $value if (! $status);

    return $status;
  }

sub vci ($)
  {
    my ($vci) = @_;

    my $title = "Modem parameters: VCI";
    my $desc = "";

    my ($status, $value);

    ($status, $value) = inputbox($desc, $title, $$vci);
    $$vci = $value if (! $status);

    return $status;
  }

sub encapsulation ($)
  {
    my ($encapsulation) = @_;

    my $title = "Modem parameters";
    my $desc = "Choose the modem protocol";

    my ($status, $value);

    my @menuvar = ();
    add_radiolist_item(\@menuvar, "1", "Bridged Ethernet LLC", $$encapsulation);
    add_radiolist_item(\@menuvar, "2", "Bridged Ethernet VC", $$encapsulation);
    add_radiolist_item(\@menuvar, "3", "Routed IP LLC", $$encapsulation);
    add_radiolist_item(\@menuvar, "4", "Routed IP VC", $$encapsulation);
    add_radiolist_item(\@menuvar, "5", "PPPOA LLC", $$encapsulation);
    add_radiolist_item(\@menuvar, "6", "PPPOA VC", $$encapsulation);

    ($status, $value) =  radiolist($desc, $title, scalar(@menuvar) / 3, @menuvar);
    $$encapsulation = $value if (! $status);

    return $status;
  }


sub bnmdir ($)
  {
    my ($bnmdir) = @_;

    my $title = "Modem parameters";
    my $desc = "Please give the path to firmware (.bnm files)";

    my ($status, $value);

    ($status, $value) = inputbox($desc, $title, $$bnmdir);
    $$bnmdir = $value if (! $status);

    return $status;
  }

# Hotplug or init?
sub startup ($)
  {
    my ($startup) = @_;

    my $title = "Modem parameters";
    my $desc = "What is your prefered way of activating the modem?";

    my ($status, $value);

    my @menuvar = ();
    add_radiolist_item(\@menuvar, "manual", "Manual startup", $$startup);
    add_radiolist_item(\@menuvar, "hotplug", "Hotplug", $$startup);
    add_radiolist_item(\@menuvar, "init", "Init scripts", $$startup);

    ($status, $value) =  radiolist($desc, $title, scalar(@menuvar) / 3, @menuvar);
    $$startup = $value if (! $status);

    return $status;
  }

sub modem_parameters
  {
    my ($profile) = @_;

    my $cfg = $profiles{$profile};

    my $vpi = $cfg->val($modem_sect, 'vpi', '8');
    return 0 if (vpi(\$vpi));

    my $vci = $cfg->val($modem_sect, 'vci', '35');
    return 0 if (vci(\$vci));

    my $encapsulation = $cfg->val($modem_sect, 'encapsulation', '1');
    return 0 if (encapsulation(\$encapsulation));

    my $bnmdir = $cfg->val($modem_sect, 'bnmdir', '/etc/eagle-usb');
    return 0 if (bnmdir(\$bnmdir));

    my $startup = $cfg->val($modem_sect, 'startup', 'manual');
    return 0 if (startup(\$startup));

    # Write updates
    add_val($cfg, $modem_sect, 'vpi', $vpi);
    add_val($cfg, $modem_sect, 'vci', $vci);
    add_val($cfg, $modem_sect, 'encapsulation', $encapsulation);
    add_val($cfg, $modem_sect, 'bnmdir', $bnmdir);
    add_val($cfg, $modem_sect, 'startup', $startup);

    return 1;
  }

sub write_modem_configuration
  {
    my ($profile) = @_;

    my $cfg = $profiles{$profile};

    my $vpi = sprintf "%08x", $cfg->val($modem_sect, 'vpi');
    my $vci = sprintf "%08x", $cfg->val($modem_sect, 'vci');
    my $encapsulation = sprintf "%08x", $cfg->val($modem_sect, 'encapsulation');

    open EAGLECONF, "> $eagle_conf" or die "Error: Could not open $eagle_conf.";

    print EAGLECONF <<EOF;
#
# This file has been generated by eagleconfig
# **** DO NOT EDIT MANUALLY ****
#

OPTN0=80020066
OPTN4=00000000

VPI=$vpi
VCI=$vci
Encapsulation=$encapsulation
Linetype=1
RatePollFreq=00000009

EOF

    close EAGLECONF;
  }

sub modem_restart
  {
    # Run adictrl to restart the modem
    system($restart_command);

    # Check for the modem to be operational
    my $timeout = 120;
    sleep 5;
    my $cnt = 5;

    while ($cnt < $timeout)
      {
	return () if (! system($modem_up));
	sleep 5;
	$cnt += 5;
      }

    my $title = "";
    my $desc = "\nError: I could not restart the modem.\n\n" .
      "Please run adictrl manually.";

    my ($status, $value) = infobox($desc, $title);
  }
  
1;
