# To build rpm: rpmbuild -bb elinks.spec
# Debug version: rpmbuild -bb elinks.spec --debug
# Console version without X11 dependency: rpmbuild -bb elinks.spec --without x
#
# This file was contributed by <zimon@niksula.hut.fi> and
# <yanek@yankuv.koniec.sk>.
#
#
# If you want to update this file, I'd like you to push your change through at
# least one of these people:
#
# * <bet@rahul.net>
# * <yanek@yankuv.koniec.sk>
#
# Just try to send the patch/new version to them and wait few days if they will
# do anything. If yes, they'll approve it or forward it to me (don't fear, the
# credit won't be lost) if it's ok by them. If you won't get any reply, send it
# to the elinks-dev mailing list. Thanks! --pasky
#
#
# Spec file format from < http://www.rpm.org/RPM-HOWTO/build.html >
#
# $Id: elinks.spec.in,v 1.16 2003/12/10 00:24:09 witekfl Exp $

Summary:	Enhanced version of Links (Lynx-like text WWW browser)
Name:		elinks
Version:	0.9.1
Release:	1
License:	GPL
Vendor:		ELinks project <elinks-users@linuxfromscratch.org>
Packager:	Petr Baudis <pasky@ucw.cz>
Group:		Applications/Internet
Source:		http://elinks.or.cz/download/%{name}-%{version}.tar.bz2
URL:		http://elinks.or.cz/
BuildRequires:	bzip2-devel
BuildRequires:	expat-devel
BuildRequires:	gpm-devel
BuildRequires:	openssl-devel
BuildRequires:	zlib-devel
BuildRequires:	/usr/bin/texi2html
%{!?_without_x:BuildRequires:	XFree86-devel}
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
Enhanced version of Links (Lynx-like text WWW browser), with more liberal
features policy and development style.

ELinks aims to provide feature-rich version of Links.  Its purpuose is to make
alternative to Links, and to test and tune various new features, but still
provide good rock-solid releases inside stable branches.

%prep
%setup -q

%build

#
# if you just checkout the source and make a tarball from it uncomment
# the following line
#
# ./autogen.sh

%configure \
%{?debug:	--enable-debug} \
%{!?debug:	--enable-fastmem} \
	--enable-256-colors \
%{?_without_x: --without-x} \
	--enable-leds \
	--enable-local-cgi
%{__make}

cd doc
texi2html elinks-lua.texi
cd ..

%install
rm -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}/{contrib,conv,lua,guile}
install \
	AUTHORS* BUGS* ChangeLog* COPYING* README* SITES* TODO* THANKS* \
	INSTALL* NEWS* $RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}/
install \
	contrib/elinks.vim contrib/elinks-vim.diff contrib/keybind*.conf \
	$RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}/contrib/
install \
	contrib/conv/w3m2links.gawk contrib/conv/conf-links2elinks.pl \
	contrib/conv/mailcap.pl contrib/conv/old_to_new_bookmarks.sh \
	$RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}/conv/
install \
	contrib/lua/elinks-remote contrib/lua/*.lua \
	$RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}/lua/
install \
	contrib/guile/*scm \
	$RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}/guile/
install \
	doc/*.txt doc/*.html \
	$RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}/

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(644,root,root,755)
%attr (755,root,root) %{_bindir}/%{name}
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/
%doc %{_defaultdocdir}/%{name}
%doc %{_mandir}/man?/*

# date +"%a %b %d %Y"
%changelog
* Wed Dec 10 2003 Witold Filipczyk <witekfl@pld-linux.org>
- enabled leds and local-cgi

* Sun 0ct 26 2003 Witold Filipczyk <witekfl@pld-linux.org>
- revert to version from 5 October

* Sat Oct 25 2003 Witold Filipczyk <witekfl@pld-linux.org>
- more BRs. gettext should be enough for most cases, but
  gettext-devel shouldn't hurt.

* Sun Oct 05 2003 Witold Filipczyk <witekfl@pld-linux.org>
- enabled 256 colors

* Thu Oct 02 2003 Witold Filipczyk <witekfl@pld-linux.org>
- polished
- no sanity checks

* Sat Sep 27 2003 darix@irssi.org
- added license
- changed BuildRoot to use tmppath variable.
- removed prefix
- added some more docs and the guile scripts

* Sat Sep 27 2003 Petr Baudis <pasky@ucw.cz>
- sanity checks of $RPM_BUILD_ROOT before rm -rf'ing it, based on darix's
  suggestion

* Sun Jan 26 2003 Petr Baudis <pasky@ucw.cz>
- elinks.pld.org.pl -> elinks.or.cz, based on Bennett's suggestion

* Thu Dec 19 2002 Bennett Todd <bet@rahul.net>
- wildcarded the above doc and manpage specifications, and tagged the man
  pages as docs

* Mon May 06 2002 yanek@yankuv.koniec.sk
- general update - cleanup of .spec file, massive simplifications

* Thu Apr 04 2002 pasky@ucw.cz
- Changed some stuff so that it's now ready for inclusion..

* Sat Mar 16 2002 zimon (t) iki fi
- Made my own elinks.spec file as the one I found with Google didn't work how
  I wanted

