/* Global include with common functions and definitions for ELinks */
/* $Id: elinks.h,v 1.32 2004/01/01 23:40:56 zas Exp $ */

#ifndef EL__ELINKS_H
#define EL__ELINKS_H

#ifndef __EXTENSION__
#define __EXTENSION__ /* Helper for SunOS */
#endif

/* This determines the system type and loads system-specific macros and
 * symbolic constants. The other includes may reuse this. This should be
 * always the very first ELinks include a source should include (except
 * config.h, of course). */
#include "osdep/system.h"

/* This introduces some generic ensurements that various things are how
 * they are supposed to be. */
#include "osdep/generic.h"

/* This loads hard-configured settings - which are too lowlevel to configure at
 * the runtime but are too unlikely to be changed to be configured through
 * config.h. */
#include "setup.h"

#ifdef DEBUG
#define LEAK_DEBUG
#endif

/* This maybe overrides some of the standard high-level functions, to ensure
 * the expected behaviour. These overrides are not system specific. */
#include "util/stub.h"

/* TODO: Move this to some dedicated util/ .h file, perhaps. Or whatever,
 * suggest something ;-). --pasky */

/* These macros will evaluate twice their arguments.
 * Ie. MIN(a+b, c+d) will do 3 additions...
 * Please prefer to use int_min() and int_max() if possible. */

/* FreeBSD needs this. */
#ifdef MIN
#undef MIN
#endif

#ifdef MAX
#undef MAX
#endif

#define MIN(x, y) ((x) < (y) ? (x) : (y))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

static inline int
int_min(register int x, register int y)
{
	if (x < y) return x;
	return y;
}

static inline int
int_max(register int x, register int y)
{
	if (x > y) return x;
	return y;
}

/* Limit @what pointed value to upper bound @limit. */
static inline void
int_upper_bound(register int *what, register int limit)
{
	if (*what > limit) *what = limit;
}

/* Limit @what pointed value to lower bound @limit. */
static inline void
int_lower_bound(register int *what, register int limit)
{
	if (*what < limit) *what = limit;
}

/* Limit @what pointed value to lower bound @lower_limit and to upper bound
 * @upper_limit. */
static inline void
int_bounds(register int *what, register int lower_limit,
	   register int upper_limit)
{
	if (*what < lower_limit)
		*what = lower_limit;
	else if (*what > upper_limit)
		*what = upper_limit;
}

#endif
