/** -*- C++ -*-
    @file libept/actor.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <qobject.h>
#include <apt-front/cache/entity/entity.h>
#include <apt-front/actor.h>

#ifndef EPT_ACTOR_H
#define EPT_ACTOR_H

namespace ept {

using namespace aptFront;

class EntityActor : public QObject
{
    Q_OBJECT
public:
    EntityActor( actor::Bound< cache::entity::Entity > a )
        : m_actor( a )
    {}
    actor::Bound< cache::entity::Entity > actor() const {
        return m_actor;
    }
public slots:
    void act() { m_actor(); }
    void destructiveAct() { act(); delete this; }
protected:
    actor::Bound< cache::entity::Entity > m_actor;
};

/* class BoundActor : public {
public:
    BoundActor( Actor< entity::Entity > a, entity::Entity e ) 
        : m_actor( a ), m_entity( e )
    {}
public slots:
    void act() { m_actor( m_entity ); }
    void destructiveAct() { act(); delete this; }
protected:
    Actor< entity::Entity > m_actor;
    entity::Entity m_entity;
    }; */

}

#endif
