#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <klocale.h>
#include <kdebug.h>
#include <qcheckbox.h>
#include <qobjectlist.h>
#include "statefilter.h"

using namespace aptFront;
using namespace ept;

StateFilterWidget::StateFilterWidget( QWidget *parent, const char *name )
    : StateFilterUi( parent, name )
{
    QObjectList *chld = queryList( "QCheckBox" );
    QObjectListIt it( *chld );
    while( it.current() != 0 ) {
        connect( it.current(), SIGNAL( toggled( bool )  ),
                 this, SLOT( widgetsChanged() ) );
        ++it;
    }
    connect( m_reset, SIGNAL( clicked() ),
             this, SLOT( reset() ) );
}

StateFilterWidget::Predicate StateFilterWidget::predicate()
{
    typedef StateFilter< entity::Package > F;
    unsigned mask = 0;
    if (m_installed->isChecked()) mask |= F::Installed;
    if (m_notInstalled->isChecked()) mask |= F::NotInstalled;
    if (m_upgradable->isChecked()) mask |= F::Upgradable;
    if (m_keep->isChecked()) mask |= F::Keep;
    if (m_install->isChecked()) mask |= F::Install;
    if (m_remove->isChecked()) mask |= F::Remove;
    if (m_upgrade->isChecked()) mask |= F::Upgrade;

    StateFilter< entity::Package > f;
    f.setMask( mask );
    return predicate::adapt< entity::Entity >( f );
}

static void blockedSet( QCheckBox *b, bool v ) {
    b->blockSignals( true );
    b->setChecked( v );
    b->blockSignals( false );
}

void StateFilterWidget::predicateChanged()
{
    typedef StateFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    unsigned mask = f.mask();
    blockedSet( m_installed, mask & F::Installed );
    blockedSet( m_notInstalled, mask & F::NotInstalled );
    blockedSet( m_upgradable, mask & F::Upgradable );
    blockedSet( m_keep, mask & F::Keep );
    blockedSet( m_install, mask & F::Install );
    blockedSet( m_upgrade, mask & F::Upgrade );
    blockedSet( m_remove, mask & F::Remove );
}

void StateFilterWidget::reset()
{
    QObjectList *chld = queryList( "QCheckBox" );
    QObjectListIt it( *chld );
    while( it.current() != 0 ) {
        blockedSet( dynamic_cast< QCheckBox * >( it.current() ), true );
        ++it;
    }
    emit widgetsChanged();
}
