from distutils.core import setup
from DistUtilsExtra.command import *
import glob

import re
import os

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)

setup(
    name = 'human-theme',
    version = version,
    data_files=[('share/themes/Human/metacity-1',
                 glob.glob('metacity/Human/*')),
                ('share/themes/Human/gtk-2.0',
                 glob.glob('Human/gtk-2.0/*')),
		('share/themes/DarkRoom/gtk-2.0',
                 glob.glob('DarkRoom//gtk-2.0/*')),
		('share/themes/DarkRoom//metacity-1',
                 glob.glob('DarkRoom//metacity-1/*')),
                ('share/themes/Human-Clearlooks/gtk-2.0',
                 glob.glob('Human-Clearlooks/gtk-2.0/*')),
		('share/themes/HumanLogin/metacity-1',
                 glob.glob('HumanLogin/metacity-1/*')),
                ('share/themes/HumanLogin/gtk-2.0',
                 glob.glob('HumanLogin/gtk-2.0/*')),
                ('share/icons/HumanLoginIcons',
                 glob.glob('HumanLoginIcons/index.theme')),
                ('share/icons/HumanLoginIcons/apps/16',
                 glob.glob('HumanLoginIcons/apps/16/*')),
                ('share/icons/HumanLoginIcons/apps/22',
                 glob.glob('HumanLoginIcons/apps/22/*')),
                ('share/icons/HumanLoginIcons/apps/24',
                 glob.glob('HumanLoginIcons/apps/24/*')),
                ('share/icons/HumanLoginIcons/apps/48',
                 glob.glob('HumanLoginIcons/apps/48/*')),
                ('share/icons/HumanLoginIcons/apps/64',
                 glob.glob('HumanLoginIcons/apps/64/*')),
		('share/themes/Human', 
                 ['cursor.theme',]),
                ('share/pixmaps/',
                 glob.glob('ubuntu-screensaver.svg')),
               ],
    cmdclass = { "build" : build_extra.build_extra,
                 "build_i18n" :  build_i18n.build_i18n }
)

