# hunspell 한국어 데이터, 개발 정보

이 파일은 소스 파일입니다. 맞춤법 검사 기능을 사용하려면 이 소스
파일에서 빌드한 AFF 및 DIC 파일을 이용하거나 여러 가지 확장 기능을
이용하십시오.

프로젝트 정보: https://github.com/spellcheck-ko/hunspell-dict-ko/

이 프로젝트는 2017년부터 공개SW개발자Lab의 지원을 받고 있습니다.
(http://kosslab.kr)


## 빌드

make와 Python 3.x가 설치되어 있는 환경에서 make 명령을 실행하면
hunspell이 사용하는 맞춤법 사전 데이터인 ko.aff 및 ko.dic 파일을 만들어
낸다.

DIC 파일에는 표제어 데이터가 들어 있고 AFF (affix) 파일에는 단어의 활용
정보가 들어간다. AFF 파일과 DIC 파일은 hunspell의 전신인 myspell에서도
이용하는 형식이지만 한국어 데이터는 hunspell에만 들어 있는 기능이
필요하기 때문에 hunspell에서만 동작한다.

DIC 파일과 AFF 파일의 내용은 프로그램을 통해 만들어 내기 때문에 직접
편집하지 않도록 한다. 데이터는 유니코드의 한글 자모 코드로 (U+1100)
쓰여 있기 때문에 에디터에서 직접 편집하면 의도한 대로 동작하지 않는다.

## 각 OS 및 애플리케이션 별 정보

 * 데비안: hunspell-ko 패키지 설치, 6.0 (squeeze) 이후 패키지 정보
 * 우분투: hunspell-ko 패키지 설치, 9.10 (karmic) 이후 패키지 정보
 * 페도라: hunspell-ko 패키지 설치, fc12 이후 패키지 정보
 * Mac OS X 10.5: BaramSpellChecker
 * Mac OS X 10.6 이상: /Library/Spelling 또는 홈폴더/Library/Spelling 아래 aff/dic 파일 복사 
 * Mozilla/Firefox 부가 기능
 * LibreOffice 및 OpenOffice.org 부가 기능 

## 소스 프로그램

데이터를 만들어 내는 소스 프로그램은 Python으로 작성되어 있고,
수정하려면 유니코드의 한글 코드, 특히 한글 자모 (U+1100,
http://unicode.org/charts/PDF/U1100.pdf 참고) 영역을 잘 알고 있어야
한다. 모든 파일은 UTF-8 인코딩으로 작성되어 있으므로 UTF-8 인코딩을
편집할 수 있는 에디터를 사용해야 한다. 코드와 데이터 전체에 걸쳐
유니코드를 사용하므로 Python 3 이상 버전이 필수이다.

현대 한글만 지원하므로 현대 자모만 사용하고 옛한글 자모는 사용하지
않는다. 완벽함을 따진다면 옛한글 자모를 굳이 뺄 필요도 없지만, 알고리듬
처리 속도가 느려지고 어차피 중세 국어 맞춤법 검사를 구현하기도 어렵다.

### 인코딩 문제

편집 거리 계산 (insert/delete/replace) 알고리듬이 한글 음절 단위가
아니라 자모 단위로 동작하도록, 또 파생 규칙을 편리하게 작성할 수 있도록
내부적으로 모두 유니코드의 한글 자모 코드로 (U+1100) 처리한다.

때문에 한글 음절 (U+AC00) 코드에서 이 한글 자모 코드로 변환하고, 이
코드를 다시 한글 음절로 변환하는 유니코드 정규화 변환을 해야 하는데
AFF 파일의 ICONV 및 OCONV 키워드를 이용한다. 이 때문에 hunspell 1.2.8
이상 버전이 필요하다. AFF 파일의 크기가 커지고 메모리 사용량이 약간
부담스럽지만 향후에는 hunspell 내부에서 직접 이 코드 변환을 지원할 수도
있을 것이다.

hunspell 1.2.8에서 1.2.11까지 버전을 사용할 경우 셸에서 실행하는
hunspell 명령어에서는 자체 내장된 tokenizer에서 (문자열을 단어 단위로
구분하는 기능을 말한다) 한글 음절로 구성된 단어를 분리하지 못한다.
그래서 셸에서 hunspell 명령을 실행할 경우 맞춤법 검사가 올바르게
동작하지 않는다. 이 문제를 바로잡은 hunspell 1.2.12 이후 버전을
사용해야 한다. 셸에서 사용하는 명령어가 아니라 hunspell 라이브러리만
사용하는 다른 응용 프로그램은 tokenizer를 자체 구현하므로 이 문제가
발생하지 않는다.

또 hunspell 1.2.8 이후에도 ICONV 및 OCONV 키워드는 입력 단어와 추천
단어에만 적용되는 문제가 있다. hunspell 명령어에서 파생어를 입력하면
결과가 "+"로 나타나면서 어근이 표시되는데, 이 문제 때문에 어근이 한글
자모로 분리되어 다음과 같은 모양으로 (한글 자모 인코딩으로) 나타날 수
있다.

  사람이
  + ㅅㅏㄹㅏㅁ

별로 중요하지 않으므로 이대로 사용해도 상관 없지만 눈에 거슬린다면
출력하는 내용을 NFC로 정규화하면 된다. 소스에 들어 있는
utils/jamo2syl.py 스크립트가 이 역할을 한다.

  $ hunspell -d ko | ./utils/jamo2syl.py 
  사람이
  + 사람


## 사전 데이터

사전 데이터는 "갈퀴" 온라인 시스템에서 만들어져서, 리뷰를 거친 단어
모음을 XML 형식으로 export해 이 소스 파일로 가져온다. Python 코드가
이 데이터를 읽어 DIC 파일을 만든다.

대략의 사전 형식:

```
  <?xml version="1.0"?>
  <entries>
    <Entry>
      <word>홈런</word>
      <pos>명사</pos>
      <props>가산명사</props>
      <etym>homerun</etym>
      <comment>야구</comment>
    </Entry>
  </entries>
```

갈퀴 데이터베이스에서는 과거에 입력한 사전이 모두 기록으로 남아 있다.
하지만 이 소스 코드에는 갈퀴 데이터베이스에서 현재 유효한 사전 엔트리만
들어 있다.

### 수동 입력한 데이터만 사용

맞춤법 검사의 성능은 단어 데이터의 완성도에 크게 좌우된다. 그래서
외부에 공개되어 있는 다른 단어 데이터를 잘 찾아서 입력하면 간단히
맞춤법 검사의 품질을 높일 수 있지 않을까 생각하기 쉽다.

하지만 외부 데이터는 라이선스 논란의 여지가 있으므로 사용하지 않고,
바닥부터 시작해서 직접 수동으로 입력한 데이터만 사용하도록 한다.
현재까지 조사해 봤지만 인터넷에서 다운로드할 수 있는 여러가지 자료
중에서는 자유로운 라이선스로 배포했을 때 저작권 문제나 라이선스 충돌을
일으키지 않는다고 확신할 수 있는 단어 데이터는 찾을 수 없었다. 

심지어 국립국어원이 배포하는 "21세기 세종 계획"의 데이터 조차
(http://www.sejong.or.kr) 약정서를 작성하면 제한된 용도로 이용할 수
있을 뿐이다. 적어도 정부가 주도해 대한민국 국민의 세금으로 만들어진
지식은 이렇게 꽁꽁 닫아 놔서는 안 된다.

단어 정보와 같은 종류의 보편적인 데이터는 독창적인 저작물이 아니라
일반적인 사실을 모은 데이터이기 때문에 저작권을 주장할 수도 없다는
해석도 있지만, 이러한 데이터를 독점적인 라이선스에 판매하는 기업이나
연구 기관도 있다. 조금의 논란이라도 발생할 가능성이 있다면 피해 가려고
한다.

만약 독점적인 라이선스가 있거나 출처가 명확하지 않은 외부의 데이터를
변환해 사용한다면 매번 이러한 논란에 시달릴 것이고 실질적으로 리눅스
배포판 등 다른 소프트웨어 패키지에 포함되지 못한다. 

공개된 개발 커뮤니티의 힘으로 사전 데이터를 바닥부터 만들어 가는 작업은
쉽지 않지만 충분히 가능한 일이다. 처음 시작할 때도 일상생활에 보이는
단어를 입력하거나, 웹 문서에서 누락된 단어를 하나씩 입력하는 방법으로
단기간에 꽤 쓸 만한 단어 모음을 만들 수 있었고, 지속적으로 관리하면
충분히 완성도 높은 데이터가 만들어질 것이다. 핀란드어, 덴마크어,
노르웨이어 등, 언어 사용자가 한국어보다 훨씬 적은 다른 언어의 맞춤법
사전도 참여하는 사람들의 힘으로 품질 높은 데이터를 축적했다.

### 단어 품사

* "명사" "대명사" "동사" "형용사" "감탄사" "관형사" "부사"

    일반 품사. 문법에서 다루는 9품사 중에서 수사와 조사는 현재 따로
    처리하므로 단어 데이터에 따로 쓰지 않는다.

* "특수:금지어"

    특별히 틀린 단어로 취급할 단어. 

    사전에 기재되어 있지 않으면 틀린 단어로 취급하기 때문에 일상적으로
    틀리는 단어를 여기에 기입할 필요는 없고, 사전에 있는 다른 단어의
    활용을 통해 파생될 수 있지만 예외적으로 틀린 단어이거나, 거의 쓰지
    않는 단어이고 잘못 썼을 가능성이 훨씬 높은 단어의 경우 이렇게 쓴다.
    (예를 들어, "화일"은 "화"+"이다"+"-ㄹ"이라고 생각할 수도 있지만,
    "파일"을 잘못 쓰는 경우가 대부분이므로 금지어로 취급한다.)

* "특수:파생형"

    파생된 형태만 주로 쓰이는 제한적인 단어는 파생된 형태를 기록한다.
    ("가라사대", "단칼에" 등)

* "특수:복수접미사" "특수:숫자" "특수:알파벳" "특수:수:<자리수>"

    내부적으로 접미어, 합성어를 위해 사용. 새로 추가할 일 없음.

### 단어 품사 세부 분류

* "명사:고유:인물" "명사:고유:지역" "명사:고유:기관" "명사:고유:국가"

    (현재 구현되지 않음)

    고유명사 분류. 실제 동작하는데 차이 없음.

* "부사:상태" "부사:성상" "부사:지시" "부사:정도" "부사:부정" "부사:양태" "부사:접속"

    부사의 세부 분류. 상태부사, 성상부사, 지시부사, 정도부사, 부정부사,
    양태부사, 접속부사.

    이 분류에 따라 보조사를 허용하느냐 여부가 달라진다. 상태부사,
    성상부사, 정도부사, 양태부사의 경우만 보조사를 붙일 수 있다.

### 단어 속성

* "가산명사"

    -들 접미어를 붙일 수 있는 명사, 대명사

* "단위명사"

    수량을 나타내는 명사, 아라비아 숫자 뒤에 붙여 쓰기 가능

* "비속어"

    (아직 구현되지 않음)

    비속어 명사, 이 속성이 들어 있는 단어는 틀린 단어로 취급하지는 않지만
    추천 단어에서 제외된다.

* "ㄷ불규칙" "ㅂ불규칙" "ㅅ불규칙" "ㅎ불규칙" "러불규칙" "르불규칙" "우불규칙" "으불규칙"

    불규칙활용 용언

    여 불규칙 활용 (~하다 형태의 용언), 리을 불규칙 (리을 탈락) 활용은
    따로 쓰지 않는다. (별도로 쓰지 않아도 알 수 있으므로.)

    거라 불규칙 (~가다 형태의 용언) 및 너라 불규칙 (~오다 형태의 용언)
    역시 따로 쓰지 않아도 된다. 현 교육 과정의 학교 문법 및 2008년 개정된
    표준국어대사전에 따라 "-거라" 및 "-너라" 어미는 "-어라"/"-아라"의
    불규칙 활용 형태가 아니라 별개의 어미로 취급한다.

    우 불규칙 활용은 "푸다" 외에는 없으므로 새로 추가할 일 없음.

* "보조용언:-어"

    다른 용언의 -어 형태 뒤에 붙여 쓸 수 있는 보조용언

* "보조용언:-을"

    다른 용언의 -을 형태 뒤에 붙여 쓸 수 있는 보조용언. 수가 한정되어
    있으므로 새로 추가할 일 없음. "만하다", "법하다", "듯싶다",
    "듯하다", "뻔하다", "성싶다"

* "보조용언:-은"

    다른 용언의 -은 형태 뒤에 붙여 쓸 수 있는 보조용언. 수가 한정되어
    있으므로 새로 추가할 일 없음. "양하다", "체하다", "듯싶다",
    "듯하다",

* "용언합성"

    용언+용언 형태의 합성 용언. 이러한 형태는 뒤에 보조 용언을 붙여 쓸 수
    없다.

* "준말용언"

    다른 용언에서 음절이 받침으로 줄여진 형태의 용언. 뒤에 모음으로
    시작하는 어미가 올 수 없다. "갖다"(가지다), "머물다"(머무르다),
    "서툴다"(서투르다), "딛다"(디디다) 따위.
