/*
  Copyright 2005 Jean-Baptiste Note

  This file is part of prism54usb.

  prism54usb is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  prism54usb is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with prism54usb; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

#ifndef _ISLSM_SMIOCTL_H
#define _ISLSM_SMIOCTL_H

#include <linux/ioctl.h>
#include <linux/types.h>

/* user-space include */
#ifndef __KERNEL__
#include <inttypes.h>
#endif

typedef struct islsm_reg {
	uint32_t                addr;
	uint32_t                val;
} islsm_reg_t;

typedef islsm_reg_t     islsm_mem_t;

#define ISLSM_FW_NAME_LEN 33

typedef char            islsm_firmware_name_t[ISLSM_FW_NAME_LEN];

#define ISLSM_IOC_MAGIC 'k'
#define ISLSM_IOC_STATE_CTRL  (1 << (_IOC_NRBITS - 1) )
#define ISLSM_IOC_ARGTYPE_REG  (1 << (_IOC_NRBITS - 2) )

/* access to pci registers */
#define ISLSM_IOCGREG _IOWR(ISLSM_IOC_MAGIC,0 | ISLSM_IOC_ARGTYPE_REG,islsm_reg_t)
#define ISLSM_IOCSREG _IOW(ISLSM_IOC_MAGIC,1 | ISLSM_IOC_ARGTYPE_REG,islsm_reg_t)

/* access to device memory */
#define ISLSM_IOCGMEM _IOWR(ISLSM_IOC_MAGIC,2 | ISLSM_IOC_ARGTYPE_REG,islsm_mem_t)
#define ISLSM_IOCSMEM _IOW(ISLSM_IOC_MAGIC,3 | ISLSM_IOC_ARGTYPE_REG,islsm_mem_t)

/* boots the rom */
#define ISLSM_IOCBOOTROM _IO(ISLSM_IOC_MAGIC, 0)
/* upload and boot firmware */
#define ISLSM_IOCLOADFW _IO(ISLSM_IOC_MAGIC, 1)
/* send the firmware a ping message */
#define ISLSM_IOCSENDPING _IO(ISLSM_IOC_MAGIC, 2)

/* set protocol constants */
//#define ISLSM_IOCSPROTO  _IOW(ISLSM_IOC_MAGIC, 1 | ISLSM_IOC_STATE_CTRL)

#endif				/* _ISLSM_SMIOCTL_H */
