/*
typedef struct {
	u_int32_t msgcode;
	u_int32_t msglen;
#define WLAN_DEVNAMELEN_MAX 16
	u_int8_t devname[WLAN_DEVNAMELEN_MAX];
	p80211item_uint32_t hosttime;
	p80211item_uint32_t mactime;
	p80211item_uint32_t channel;
	p80211item_uint32_t rssi;
	p80211item_uint32_t sq;
	p80211item_uint32_t signal;
	p80211item_uint32_t noise;
	p80211item_uint32_t rate;
	p80211item_uint32_t istx;
	p80211item_uint32_t frmlen;
} wlan_ng_prism2_header;
*/

/* wlan-ng (and hopefully others) AVS header, version one.  Fields in
 * network byte order. */
#define P80211CAPTURE_VERSION 0x80211001
#define ETH_P_80211_RAW 0x0019

struct avs_80211_1_header {
	uint32_t                version;
	uint32_t                length;
	uint64_t                mactime;
	uint64_t                hosttime;
	uint32_t                phytype;
	uint32_t                channel;
	uint32_t                datarate;
	uint32_t                antenna;
	uint32_t                priority;
	uint32_t                ssi_type;
	int32_t                 ssi_signal;
	int32_t                 ssi_noise;
	uint32_t                preamble;
	uint32_t                encoding;
};
