/*
 * some foo for wext compat/wext interoperability
 */
#ifndef _WEXT_H
#define _WEXT_H
#include <linux/netdevice.h>
#include <linux/if.h>
#include <linux/wireless.h>
#include <net/iw_handler.h>

/* wext compatibility must be compiled in...
 * this extern is in wext-compat.c */
struct cfg80211_ioctl_ops {
	/* used to make sure the module isn't going away
	 * can't really happen, except if no driver has cfg80211
	 * in use, but in that case  */
	struct module *module;

	/* and finally this is used to do work */
	int (*do_wext_ioctl)(struct ifreq *ifr, unsigned int cmd);
};
extern struct cfg80211_ioctl_ops cfg80211_ioctl_ops;


struct iw_statistics *get_wireless_stats(struct net_device *dev,
					 struct iw_statistics *out);
int wireless_process_ioctl(struct ifreq *ifr, unsigned int cmd);

int cfg80211_wext_ioctl(struct ifreq *ifr, unsigned int cmd);
#ifdef CFG80211_MODULE
int call_cfg80211_wext_ioctl(struct ifreq *ifr, unsigned int cmd);
#else
#define call_cfg80211_wext_ioctl cfg80211_wext_ioctl
#endif

#if defined(CONFIG_CFG80211_WEXT_COMPAT) && defined(CFG80211_MODULE)
int cfg80211_wext_init(void);
void cfg80211_wext_exit(void);
#else
static inline int cfg80211_wext_init(void)
{
	return 0;
}
static inline void cfg80211_wext_exit(void) {}
#endif

extern const struct iw_ioctl_description wext_standard_ioctl[];
extern const unsigned wext_standard_ioctl_num;
extern const struct iw_ioctl_description standard_event[];
extern const int event_type_size[];
#endif /* _WEXT_H */
