#line 1038 "ifupdown.nw"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#line 1049 "ifupdown.nw"
#include "header.h"
#line 1277 "ifupdown.nw"
#include <errno.h>
#line 1411 "ifupdown.nw"
#include <ctype.h>
#line 1254 "ifupdown.nw"
static int get_line(char **result, size_t *result_len, FILE *f, int *line);
#line 1481 "ifupdown.nw"
static char *next_word(char *buf, char *word, int maxlen);
#line 1718 "ifupdown.nw"
static address_family *get_address_family(address_family *af[], char *name);
#line 1753 "ifupdown.nw"
static method *get_method(address_family *af, char *name);
#line 1814 "ifupdown.nw"
static int duplicate_if(interface_defn *ifa, interface_defn *ifb);
#line 1956 "ifupdown.nw"
allowup_defn *get_allowup(allowup_defn **allowups, char *name);

#line 1994 "ifupdown.nw"
allowup_defn *add_allow_up(char *filename, int line,
	 allowup_defn *allow_up, char *iface_name);
#line 1179 "ifupdown.nw"
interfaces_file *read_interfaces(char *filename) {
	
#line 1224 "ifupdown.nw"
FILE *f;
int line;
#line 1261 "ifupdown.nw"
char *buf = NULL;
size_t buf_len = 0;
#line 1461 "ifupdown.nw"
interface_defn *currif = NULL;
mapping_defn *currmap = NULL;
enum { NONE, IFACE, MAPPING } currently_processing = NONE;
#line 1472 "ifupdown.nw"
char firstword[80];
char *rest;
#line 1181 "ifupdown.nw"
	interfaces_file *defn;

	
#line 1201 "ifupdown.nw"
defn = malloc(sizeof(interfaces_file));
if (defn == NULL) {
	return NULL;
}
defn->allowups = NULL;
defn->mappings = NULL;
defn->ifaces = NULL;
#line 1184 "ifupdown.nw"
	
#line 1229 "ifupdown.nw"
f = fopen(filename, "r");
if ( f == NULL ) return NULL;
line = 0;

#line 1186 "ifupdown.nw"
	while (
#line 1269 "ifupdown.nw"
get_line(&buf,&buf_len,f,&line)
#line 1186 "ifupdown.nw"
                                             ) {
		
#line 1508 "ifupdown.nw"
rest = next_word(buf, firstword, 80);
if (rest == NULL) continue; /* blank line */

if (strcmp(firstword, "mapping") == 0) {
	
#line 1560 "ifupdown.nw"
currmap = malloc(sizeof(mapping_defn));
if (currmap == NULL) {
	
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1563 "ifupdown.nw"
}
#line 1567 "ifupdown.nw"
currmap->max_matches = 0;
currmap->n_matches = 0;
currmap->match = NULL;

while((rest = next_word(rest, firstword, 80))) {
	if (currmap->max_matches == currmap->n_matches) {
		char **tmp;
		currmap->max_matches = currmap->max_matches * 2 + 1;
		tmp = realloc(currmap->match, 
			sizeof(*tmp) * currmap->max_matches);
		if (tmp == NULL) {
			currmap->max_matches = (currmap->max_matches - 1) / 2;
			
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1580 "ifupdown.nw"
		}
		currmap->match = tmp;
	}

	currmap->match[currmap->n_matches++] = strdup(firstword);
}
#line 1589 "ifupdown.nw"
currmap->script = NULL;

currmap->max_mappings = 0;
currmap->n_mappings = 0;
currmap->mapping = NULL;
#line 1597 "ifupdown.nw"
{
	mapping_defn **where = &defn->mappings;
	while(*where != NULL) {
		where = &(*where)->next;
	}
	*where = currmap;
	currmap->next = NULL;
}
#line 1513 "ifupdown.nw"
	currently_processing = MAPPING;
} else if (strcmp(firstword, "iface") == 0) {
	
#line 1649 "ifupdown.nw"
{
	
#line 1682 "ifupdown.nw"
char iface_name[80];
char address_family_name[80];
char method_name[80];

#line 1652 "ifupdown.nw"
	
#line 1670 "ifupdown.nw"
currif = malloc(sizeof(interface_defn));
if (!currif) {
	
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1673 "ifupdown.nw"
}

#line 1654 "ifupdown.nw"
	
#line 1688 "ifupdown.nw"
rest = next_word(rest, iface_name, 80);
rest = next_word(rest, address_family_name, 80);
rest = next_word(rest, method_name, 80);

if (rest == NULL) {
	
#line 2050 "ifupdown.nw"
fprintf(stderr, "%s:%d: too few parameters for iface line\n", filename, line);
return NULL;
#line 1694 "ifupdown.nw"
}

if (rest[0] != '\0') {
	
#line 2055 "ifupdown.nw"
fprintf(stderr, "%s:%d: too many parameters for iface line\n", filename, line);
return NULL;
#line 1698 "ifupdown.nw"
}

#line 1656 "ifupdown.nw"
	
#line 1704 "ifupdown.nw"
currif->logical_iface = strdup(iface_name);
if (!currif->logical_iface) {
	
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1707 "ifupdown.nw"
}
#line 1657 "ifupdown.nw"
	
#line 1722 "ifupdown.nw"
currif->address_family = get_address_family(addr_fams, address_family_name);
if (!currif->address_family) {
	
#line 2060 "ifupdown.nw"
fprintf(stderr, "%s:%d: unknown address type\n", filename, line);
return NULL;
#line 1725 "ifupdown.nw"
}
#line 1658 "ifupdown.nw"
	
#line 1757 "ifupdown.nw"
currif->method = get_method(currif->address_family, method_name);
if (!currif->method) {
	
#line 2065 "ifupdown.nw"
fprintf(stderr, "%s:%d: unknown method\n", filename, line);
return NULL;
#line 1760 "ifupdown.nw"
	return NULL; /* FIXME */
}
#line 1659 "ifupdown.nw"
	
#line 1780 "ifupdown.nw"
currif->automatic = 1;
currif->max_options = 0;
currif->n_options = 0;
currif->option = NULL;

#line 1661 "ifupdown.nw"
	
#line 1796 "ifupdown.nw"
{
	interface_defn **where = &defn->ifaces; 
	while(*where != NULL) {
		if (duplicate_if(*where, currif)) {
			
#line 2070 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate interface\n", filename, line);
return NULL;
#line 1801 "ifupdown.nw"
		}
		where = &(*where)->next;
	}

	*where = currif;
	currif->next = NULL;
}
#line 1662 "ifupdown.nw"
}
#line 1516 "ifupdown.nw"
	currently_processing = IFACE;
} else if (strcmp(firstword, "auto") == 0) {
	
#line 1935 "ifupdown.nw"
allowup_defn *auto_ups = get_allowup(&defn->allowups, "auto");
if (!auto_ups) {
	
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1938 "ifupdown.nw"
}
while((rest = next_word(rest, firstword, 80))) {
	if (!add_allow_up(filename, line, auto_ups, firstword))
		return NULL;
}
#line 1519 "ifupdown.nw"
	currently_processing = NONE;
} else if (strncmp(firstword, "allow-", 6) == 0 && strlen(firstword) > 6) {
	
#line 1945 "ifupdown.nw"
allowup_defn *allow_ups = get_allowup(&defn->allowups, firstword + 6);
if (!allow_ups) {
	
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1948 "ifupdown.nw"
}
while((rest = next_word(rest, firstword, 80))) {
	if (!add_allow_up(filename, line, allow_ups, firstword))
		return NULL;
}
#line 1522 "ifupdown.nw"
	currently_processing = NONE;
} else {
	
#line 1529 "ifupdown.nw"
switch(currently_processing) {
	case IFACE:
		
#line 1835 "ifupdown.nw"
if (strcmp(firstword, "post-up") == 0) {
	strcpy(firstword, "up");
}
if (strcmp(firstword, "pre-down") == 0) {
	strcpy(firstword, "down");
} 
#line 1844 "ifupdown.nw"
{
	int i;

	if (strlen (rest) == 0) {
		
#line 2096 "ifupdown.nw"
fprintf(stderr, "%s:%d: option with empty value\n", filename, line);
return NULL;
#line 1849 "ifupdown.nw"
	}

	if (strcmp(firstword, "pre-up") != 0 
	    && strcmp(firstword, "up") != 0
	    && strcmp(firstword, "down") != 0
	    && strcmp(firstword, "post-down") != 0)
        {
		for (i = 0; i < currif->n_options; i++) {
			if (strcmp(currif->option[i].name, firstword) == 0) {
				
#line 2081 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate option\n", filename, line);
return NULL;
#line 1859 "ifupdown.nw"
			}
		}
	}
}
#line 1871 "ifupdown.nw"
if (currif->n_options >= currif->max_options) {
	
#line 1916 "ifupdown.nw"
{
	variable *opt;
	currif->max_options = currif->max_options + 10;
	opt = realloc(currif->option, sizeof(*opt) * currif->max_options);
	if (opt == NULL) {
		
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1922 "ifupdown.nw"
	}
	currif->option = opt;
}
#line 1873 "ifupdown.nw"
}

currif->option[currif->n_options].name = strdup(firstword);
currif->option[currif->n_options].value = strdup(rest);

if (!currif->option[currif->n_options].name) {
	
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1880 "ifupdown.nw"
}

if (!currif->option[currif->n_options].value) {
	
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1884 "ifupdown.nw"
}

currif->n_options++;	
#line 1532 "ifupdown.nw"
		break;
	case MAPPING:
		
#line 1612 "ifupdown.nw"
if (strcmp(firstword, "script") == 0) {
	
#line 1622 "ifupdown.nw"
if (currmap->script != NULL) {
	
#line 2086 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate script in mapping\n", filename, line);
return NULL;
#line 1624 "ifupdown.nw"
} else {
	currmap->script = strdup(rest);
}
#line 1614 "ifupdown.nw"
} else if (strcmp(firstword, "map") == 0) {
	
#line 1630 "ifupdown.nw"
if (currmap->max_mappings == currmap->n_mappings) {
	char **opt;
	currmap->max_mappings = currmap->max_mappings * 2 + 1;
	opt = realloc(currmap->mapping, sizeof(*opt) * currmap->max_mappings);
	if (opt == NULL) {
		
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1636 "ifupdown.nw"
	}
	currmap->mapping = opt;
}
currmap->mapping[currmap->n_mappings] = strdup(rest);
currmap->n_mappings++;
#line 1616 "ifupdown.nw"
} else {
	
#line 2091 "ifupdown.nw"
fprintf(stderr, "%s:%d: misplaced option\n", filename, line);
return NULL;
#line 1618 "ifupdown.nw"
}
#line 1535 "ifupdown.nw"
		break;
	case NONE:
	default:
		
#line 2091 "ifupdown.nw"
fprintf(stderr, "%s:%d: misplaced option\n", filename, line);
return NULL;
#line 1539 "ifupdown.nw"
}
#line 1525 "ifupdown.nw"
}
#line 1188 "ifupdown.nw"
	}
	if (
#line 1281 "ifupdown.nw"
ferror(f) != 0
#line 1189 "ifupdown.nw"
                                           ) {
		
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1191 "ifupdown.nw"
	}

	
#line 1235 "ifupdown.nw"
fclose(f);
line = -1;
#line 1194 "ifupdown.nw"
	
#line 1211 "ifupdown.nw"
    currif = defn->ifaces;
    while (currif) {
       
#line 1894 "ifupdown.nw"
int metric_search_i = 0;
int metric_definition_found = 0;
for (; metric_search_i < currif->n_options; metric_search_i++) {
   if (!strcmp("metric", currif->option[metric_search_i].name)) {
	metric_definition_found = 1;
	break;
   }
}

if (!metric_definition_found) {
   
#line 1916 "ifupdown.nw"
{
	variable *opt;
	currif->max_options = currif->max_options + 10;
	opt = realloc(currif->option, sizeof(*opt) * currif->max_options);
	if (opt == NULL) {
		
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 1922 "ifupdown.nw"
	}
	currif->option = opt;
}
#line 1905 "ifupdown.nw"
   currif->option[currif->n_options].name = strdup("metric");
   currif->option[currif->n_options].value = strdup("100");
   currif->n_options++;
}

#line 1214 "ifupdown.nw"
       currif = currif->next;
    }

#line 1196 "ifupdown.nw"
	return defn;
}
#line 1294 "ifupdown.nw"
static int get_line(char **result, size_t *result_len, FILE *f, int *line) {
	
#line 1319 "ifupdown.nw"
size_t pos;

#line 1297 "ifupdown.nw"
	do {
		
#line 1326 "ifupdown.nw"
pos = 0;
#line 1299 "ifupdown.nw"
		
#line 1337 "ifupdown.nw"
do {
	
#line 1358 "ifupdown.nw"
if (*result_len - pos < 10) {
	char *newstr = realloc(*result, *result_len * 2 + 80);
	if (newstr == NULL) {
		return 0;
	}
	*result = newstr;
	*result_len = *result_len * 2 + 80;
}
#line 1339 "ifupdown.nw"
	
#line 1387 "ifupdown.nw"
if (!fgets(*result + pos, *result_len - pos, f)) {
	if (ferror(f) == 0 && pos == 0) return 0;
	if (ferror(f) != 0) return 0;
}
pos += strlen(*result + pos);
#line 1340 "ifupdown.nw"
} while(
#line 1378 "ifupdown.nw"
pos == *result_len - 1 && (*result)[pos-1] != '\n'
#line 1340 "ifupdown.nw"
                                   );

#line 1399 "ifupdown.nw"
if (pos != 0 && (*result)[pos-1] == '\n') {
	(*result)[--pos] = '\0';
}

#line 1344 "ifupdown.nw"
(*line)++;

assert( (*result)[pos] == '\0' );
#line 1300 "ifupdown.nw"
		
#line 1415 "ifupdown.nw"
{ 
	int first = 0; 
	while (isspace((*result)[first]) && (*result)[first]) {
		first++;
	}

	memmove(*result, *result + first, pos - first + 1);
	pos -= first;
}
#line 1301 "ifupdown.nw"
	} while (
#line 1439 "ifupdown.nw"
(*result)[0] == '#'
#line 1301 "ifupdown.nw"
                               );

	while (
#line 1443 "ifupdown.nw"
(*result)[pos-1] == '\\'
#line 1303 "ifupdown.nw"
                               ) {
		
#line 1447 "ifupdown.nw"
(*result)[--pos] = '\0';
#line 1305 "ifupdown.nw"
		
#line 1337 "ifupdown.nw"
do {
	
#line 1358 "ifupdown.nw"
if (*result_len - pos < 10) {
	char *newstr = realloc(*result, *result_len * 2 + 80);
	if (newstr == NULL) {
		return 0;
	}
	*result = newstr;
	*result_len = *result_len * 2 + 80;
}
#line 1339 "ifupdown.nw"
	
#line 1387 "ifupdown.nw"
if (!fgets(*result + pos, *result_len - pos, f)) {
	if (ferror(f) == 0 && pos == 0) return 0;
	if (ferror(f) != 0) return 0;
}
pos += strlen(*result + pos);
#line 1340 "ifupdown.nw"
} while(
#line 1378 "ifupdown.nw"
pos == *result_len - 1 && (*result)[pos-1] != '\n'
#line 1340 "ifupdown.nw"
                                   );

#line 1399 "ifupdown.nw"
if (pos != 0 && (*result)[pos-1] == '\n') {
	(*result)[--pos] = '\0';
}

#line 1344 "ifupdown.nw"
(*line)++;

assert( (*result)[pos] == '\0' );
#line 1306 "ifupdown.nw"
	}

	
#line 1427 "ifupdown.nw"
while (isspace((*result)[pos-1])) { /* remove trailing whitespace */
	pos--;
}
(*result)[pos] = '\0';

#line 1310 "ifupdown.nw"
	return 1;
}
#line 1485 "ifupdown.nw"
static char *next_word(char *buf, char *word, int maxlen) {
	if (!buf) return NULL;
	if (!*buf) return NULL;

	while(!isspace(*buf) && *buf) {
		if (maxlen-- > 1) *word++ = *buf;
		buf++;
	}
	if (maxlen > 0) *word = '\0';

	while(isspace(*buf) && *buf) buf++;

	return buf;
}
#line 1734 "ifupdown.nw"
static address_family *get_address_family(address_family *af[], char *name) {
	int i;
	for (i = 0; af[i]; i++) {
		if (strcmp(af[i]->name, name) == 0) {
			return af[i];
		}
	}
	return NULL;
}
#line 1765 "ifupdown.nw"
static method *get_method(address_family *af, char *name) {
	int i;
	for (i = 0; i < af->n_methods; i++) {
		if (strcmp(af->method[i].name, name) == 0) {
			return &af->method[i];
		}
	}
	return NULL;
}
#line 1818 "ifupdown.nw"
static int duplicate_if(interface_defn *ifa, interface_defn *ifb) {
	if (strcmp(ifa->logical_iface, ifb->logical_iface) != 0) return 0;
	if (ifa->address_family != ifb->address_family) return 0;
	return 1;
}
#line 1959 "ifupdown.nw"
allowup_defn *get_allowup(allowup_defn **allowups, char *name) {
	for (; *allowups; allowups = &(*allowups)->next) {
		if (strcmp((*allowups)->when, name) == 0) break;
	}
	if (*allowups == NULL) {
		*allowups = malloc(sizeof(allowup_defn));
		if (*allowups == NULL) return NULL;
		(*allowups)->when = strdup(name);
		(*allowups)->next = NULL;
		(*allowups)->max_interfaces = 0;
		(*allowups)->n_interfaces = 0;
		(*allowups)->interfaces = NULL;
	}
	return *allowups;
}
#line 1984 "ifupdown.nw"
allowup_defn *find_allowup(interfaces_file *defn, char *name) {
	allowup_defn *allowups = defn->allowups;
	for (; allowups; allowups = allowups->next) {
		if (strcmp(allowups->when, name) == 0) break;
	}
	return allowups;
}
#line 1999 "ifupdown.nw"
allowup_defn *add_allow_up(char *filename, int line,
	allowup_defn *allow_up, char *iface_name)
{
	
#line 2009 "ifupdown.nw"
{
	int i;

	for (i = 0; i < allow_up->n_interfaces; i++) {
		if (strcmp(iface_name, allow_up->interfaces[i]) == 0) {
			
#line 2075 "ifupdown.nw"
fprintf(stderr, "%s:%d: interface %s declared allow-%s twice\n", 
	filename, line, iface_name, allow_up->when);
return NULL;
#line 2015 "ifupdown.nw"
		}
	}
}
#line 2003 "ifupdown.nw"
	
#line 2021 "ifupdown.nw"
if (allow_up->n_interfaces == allow_up->max_interfaces) {
	char **tmp;
	allow_up->max_interfaces *= 2;
	allow_up->max_interfaces++;
	tmp = realloc(allow_up->interfaces, 
		sizeof(*tmp) * allow_up->max_interfaces);
	if (tmp == NULL) {
		
#line 2045 "ifupdown.nw"
perror(filename);
return NULL;
#line 2029 "ifupdown.nw"
	}
	allow_up->interfaces = tmp;
}

allow_up->interfaces[allow_up->n_interfaces] = strdup(iface_name);
allow_up->n_interfaces++;
#line 2004 "ifupdown.nw"
	return allow_up;
}
