
/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: IvmConfigConditions.c,v 1.1 2005/05/12 01:42:34 ro_han Exp $
 *****************************************************************************/

#include "common.h"
#include "IvmConfigConditions.h"

#include <string.h>
#include <glib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>
#include <dbus/dbus.h>
#include <libhal.h>

IvmConfigConditions * parseIvmConfigConditions(char const * const path, char const * udi, char const * const conditionName)
{
    gboolean mountable = ivm_device_is_mountable(udi);


    LIBXML_TEST_VERSION IvmConfigConditions * ret = NULL;

    // DEBUG("parseIvmConfigActions %s", path);
    ret = (IvmConfigConditions *) malloc(sizeof(IvmConfigConditions));

    if (ret == NULL)
    {
        DEBUG("Malloc of ret failed");
        return NULL;
    }

    memset(ret, 0, sizeof(IvmConfigConditions));

    ret->exec = NULL;
    int num_exec = 0;

    xmlDocPtr doc;
    xmlNodePtr cur;

    doc = xmlParseFile(path);
    if (doc == NULL)
    {
        DEBUG("Document not parsed successfully.");
        return NULL;
    }

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL)
    {
        DEBUG("Empty document");
        xmlFreeDoc(doc);
        return NULL;
    }
    if (xmlStrcmp(cur->name, (const xmlChar *) "ConditionsConfig"))
    {
        DEBUG("Document of the wrong type, root node != ConditionsConfig");
        xmlFreeDoc(doc);
        return NULL;
    }
    cur = cur->children;
    while (cur != NULL)
    {
        // DEBUG("At XML node %s",cur->name);
        if (!xmlStrcmp(cur->name, (const xmlChar *) "Match"))
        {
            /* Check if our device matches - if so, continue iterating
               through siblings, otherwise jump back up to parent */

            gboolean matches = FALSE;


            xmlChar *name;

            name = xmlGetProp(cur, "name");

            xmlChar *value;

            value = xmlGetProp(cur, "value");

            if (!xmlStrcmp(name, (const xmlChar *) "*"))
            {
                matches = TRUE;
            }

            else if (!xmlStrcmp(name, (const xmlChar *) "ivm.mountable"))
            {
                if (((!xmlStrcmp
                      (value, (const xmlChar *) "true"))
                     && mountable)
                    ||
                    ((!xmlStrcmp
                      (value, (const xmlChar *) "false")) && !mountable))
                    matches = TRUE;
            }

            else if (!xmlStrncmp(name, (const xmlChar *) "hal.", 4))
                matches = hal_xml_property_matches(name, value, udi);
            else
                DEBUG("Invalid match name: %s", (char *) name);

            if (matches == TRUE && cur->children != NULL)
                cur = cur->children;
            else if (cur->next != NULL)
                cur = cur->next;
            else
                cur = cur->parent->next;

            xmlFree(value);
            xmlFree(name);
        }

        else if (!xmlStrcmp(cur->name, (const xmlChar *) "Condition"))
        {
            xmlChar *name = xmlGetProp(cur, "name");

            xmlChar *exec = xmlGetProp(cur, "exec");

            if (!xmlStrcmp(name, (xmlChar *) conditionName))
            {
                num_exec++;
                ret->exec = realloc(ret->exec,
                                    (num_exec + 1) * sizeof(char *));
                ret->exec[num_exec-1] = (char *) xmlStrdup(exec);
                ret->exec[num_exec] = NULL;
            }

            xmlFree(name);
            xmlFree(exec);

            if (cur->next != NULL)
                cur = cur->next;
            else
                cur = cur->parent->next;
        } else if (cur->next != NULL)
            cur = cur->next;
        else
            cur = cur->parent->next;

    }
    xmlFreeDoc(doc);

    xmlCleanupParser();

    return ret;
}
