#include "fsck_message.h"

struct fsck_message msg_defs[fsck_highest_msgid_defined+1] = {
  /*   0 */ { fsck_MSGOK, "Operation was successful.", fsck_debug},
  /*   1 */ { fsck_ALLFXD, "All observed inconsistencies have been repaired.", fsck_debug},
  /*   2 */ { fsck_RIBADDATFMT, "Invalid data format detected in root directory.", fsck_quiet},
  /*   3 */ { fsck_BADBLKCTTTL, "A combination of Minimum Free Blocks and Total Usable Blocks which is invalid for the filesystem size was detected in the superblock (%s).", fsck_debug},
  /*   4 */ { fsck_BADBLKNO, "Invalid block number(s) (%s) detected for file system object %s%s%d.", fsck_debug},
  /*   5 */ { fsck_BADBSBLCHN, "File system object %s%s%d has a corrupt backward sibling chain.", fsck_debug},
  /*   6 */ { fsck_BADFSBLCHN, "File system object %s%s%d has a corrupt forward sibling chain.", fsck_debug},
  /*   7 */ { fsck_BADINOTYP, "Inode %s%d has unrecognized type.", fsck_debug},
  /*   8 */ { fsck_BADINODXDFLDD, "File system object %s%s%d has invalid descriptor (%s).", fsck_debug},
  /*   9 */ { fsck_BADINOLKCT, "Inode %s%d has incorrect link count.", fsck_debug},
  /*  10 */ { fsck_BADINOREF, "Directory inode %s%d refers to a nonexistent inode %s%s (entry %u).", fsck_debug},
  /*  11 */ { fsck_ERRONLOG, "Error (%d,%d) writing to the fsck service log (%d,%lld,%ld,%ld).  Continuing.", fsck_debug},
  /*  12 */ { fsck_BOOTSECFXD, "The boot sector has been refreshed.", fsck_debug},
  /*  13 */ { fsck_BADKEYS, "File system object %s%s%d has corrupt data (%d).", fsck_debug},
  /*  14 */ { fsck_BADSBOTHR, "Invalid data (%s) detected in the superblock (%s).", fsck_debug},
  /*  15 */ { fsck_BADSBAGSIZ, "Invalid allocation group size in the superblock (%s).", fsck_debug},
  /*  16 */ { fsck_BADSBBLSIZ, "Invalid filesystem block size in the superblock (%s).", fsck_debug},
  /*  17 */ { fsck_BADSBFSSIZ, "Invalid filesystem size in the superblock (%s).", fsck_debug},
  /*  18 */ { fsck_BDSBBTHCRRPT, "Superblock is corrupt and cannot be repaired \nsince both primary and secondary copies are corrupt.  \n\n CANNOT CONTINUE.", fsck_quiet},
  /*  19 */ { fsck_BDSBNWRTACC, "Primary superblock is corrupt and cannot be repaired without write access. Continuing.", fsck_quiet},
  /*  20 */ { fsck_XCHKLOGBADPARM, "XCHKLOG Unsupported XCHKLOG parameter:   %s", fsck_debug},
  /*  21 */ { fsck_BADSBMGC, "Invalid magic number in the superblock (%s).", fsck_debug},
  /*  22 */ { fsck_BADSBVRSN, "Invalid version number in the superblock (%s).", fsck_debug},
  /*  23 */ { fsck_BMAPCBMXB, "Incorrect maxbud AG detected in Block Map Control Page.", fsck_debug},
  /*  24 */ { fsck_BMAPCNF, "Incorrect number of free blocks detected in Block Map Control Page.", fsck_debug},
  /*  25 */ { fsck_BLSIZLTLVBLSIZ, "In superblock (%s) filesystem block size smaller than volume block size.", fsck_debug},
  /*  26 */ { fsck_RIBADFMT, "Invalid format detected in Root directory.", fsck_quiet},
  /*  27 */ { fsck_DEFAULTVOL, "Device parm defaulting to current volume: %s", fsck_debug},
  /*  28 */ { fsck_CNTWRTBSMBR, "Unable to write to boot sector Master Boot Record.  Continuing.", fsck_debug},
  /*  29 */ { fsck_INCONSIST2NDRY, "Secondary file/directory allocation structure (%s) is not a correct redundant copy of primary structure.", fsck_quiet},
  /*  30 */ { fsck_INCONSIST2NDRY1, "Unable to replicate primary file/directory allocation structure (%s) to secondary.  FUTURE RECOVERY CAPABILITY IS COMPROMISED.", fsck_quiet},
  /*  31 */ { fsck_CHKLOGNEW, "XCHKLOG  fsck service log selected:  MOST RECENT", fsck_debug},
  /*  32 */ { fsck_LSFNCNTCRE, "MINOR: Cannot create directory lost+found in root directory.  mkdir lost+found in the root directory then run fsck with the -f parameter to reconnect lost files and/or directories.", fsck_quiet},
  /*  33 */ { fsck_INOCANTNAME, "Fileset object %s%s%d:  No paths found.", fsck_quiet},
  /*  34 */ { fsck_INOBADREF, "The path(s) refer to an unallocated file.", fsck_quiet},
  /*  35 */ { fsck_CHKLOGOLD, "XCHKLOG  fsck service log selected:  PREVIOUS", fsck_debug},
  /*  36 */ { fsck_WILLRMVBADREF, "The path(s) refer to an unallocated file. Will remove.", fsck_quiet},
  /*  37 */ { fsck_CANTREPAIRAIS, "Unable to repair primary inode allocation structure (%s). Continuing.", fsck_debug},
  /*  38 */ { fsck_RIBADTREE, "Root directory has a corrupt tree.", fsck_debug},
  /*  39 */ { fsck_RICRETREE, "Initialized tree created for root directory.", fsck_debug},
  /*  40 */ { fsck_CNTRESUPP, "Unable to read primary superblock.", fsck_debug},
  /*  41 */ { fsck_CHKLOGINVALRCD, "fsck service log: INVALID LOG RECORD: SKIPPING ONE OR MORE LOG RECORDS.", fsck_debug},
  /*  42 */ { fsck_SESSSTART, "processing started: %s", fsck_debug},
  /*  43 */ { fsck_SEPARATOR, "\n**********************************************************", fsck_debug},
  /*  44 */ { fsck_CNTWRTSUPP, "Unable to write primary superblock.", fsck_quiet},
  /*  45 */ { fsck_ERRONAGG, "Fatal error (%d,%d) accessing the filesystem (%d,%lld,%d,%d).", fsck_debug},
  /*  46 */ { fsck_DIRWHDLKS, "Multiple parent directories for directory %s%d.", fsck_quiet},
  /*  47 */ { fsck_LOGSPECINVALID, "External journal log not supported.", fsck_debug},
  /*  48 */ { fsck_DUPBLKREF, "Duplicate reference to %d block(s) beginning at offset %lld found in file system object %s%s%d.", fsck_debug},
  /*  49 */ { fsck_BADMETAINOF, "File set metadata inode %s%d is corrupt.", fsck_debug},
  /*  50 */ { fsck_ERRONWSP, "Fatal error (%d,%d) accessing the workspace (%d,%lld,%d,%d).", fsck_debug},
  /*  51 */ { fsck_EXHDYNSTG, "Insufficient dynamic storage available for required workspace (%d,%d).  CANNOT CONTINUE", fsck_quiet},
  /*  52 */ { fsck_DEVGETCHARRC, "IOCtl(...DSK_GETDEVICEPARAMS...) returned rc = %s", fsck_debug},
  /*  53 */ { fsck_FSMNTD, "Filesystem is currently mounted.", fsck_quiet},
  /*  54 */ { fsck_BADINOOTHR, "Invalid data (%s) detected in file system object %s%s%d.", fsck_debug},
  /*  55 */ { fsck_FSSMMRY1, "Block size in bytes:  %d", fsck_quiet},
  /*  56 */ { fsck_FSSMMRY2, "Filesystem size in blocks:  %lld", fsck_quiet},
  /*  57 */ { fsck_FSSMMRY3, "Filesystem Summary:", fsck_debug},
  /*  58 */ { fsck_FSSMMRY4, "Blocks in use for inodes:  %lld", fsck_debug},
  /*  59 */ { fsck_FSSMMRY5, "Inode count:  %lld", fsck_debug},
  /*  60 */ { fsck_FSSMMRY6, "File count:  %lld", fsck_debug},
  /*  61 */ { fsck_FSSMMRY9, "Directory count:  %lld", fsck_debug},
  /*  62 */ { fsck_DUPBLKREFS, "Inode %s%d has references to cross linked blocks.", fsck_debug},
  /*  63 */ { fsck_FSSMMRY7, "Block count:  %lld", fsck_debug},
  /*  64 */ { fsck_FSSMMRY8, "Free block count:  %lld", fsck_debug},
  /*  65 */ { fsck_ILLINOREF, "Directory inode %s%d entry %s refers to an illegal inode %s%u.", fsck_debug},
  /*  66 */ { fsck_XCHKLOGUSAGE, "Usage: xchklog [-f filename] [-p] [-V] <device>", fsck_debug},
  /*  67 */ { fsck_INOCNTGETPATH, "Unable to get path for link from directory %s%d to fileset object %s%s%d.", fsck_quiet},
  /*  68 */ { fsck_INOEA, "Format error in Extended Attributes Space or descriptor.", fsck_quiet},
  /*  69 */ { fsck_BADAGFELIST, "Discrepancies detected in the Free Inode Extent List for Allocation Group %s%d. (%s)", fsck_debug},
  /*  70 */ { fsck_MNCNTRCNCTINOF, "MINOR: Unable to reconnect file inode %c%u.  Continuing.", fsck_debug},
  /*  71 */ { fsck_INCINOREF, "Directory %s%d entry \"..\" refers to an incorrect parent directory (%s%s).", fsck_quiet},
  /*  72 */ { fsck_INCINOREFCRCT, "Directory inode %s%d entry \"..\" reference to incorrect inode corrected.", fsck_debug},
  /*  73 */ { fsck_INOCLRD, "Storage allocated to inode %s%d has been cleared.", fsck_debug},
  /*  74 */ { fsck_INOEACLRD, "Storage allocated to extended attributes for inode %s%d has been cleared.", fsck_debug},
  /*  75 */ { fsck_INOINLSFNF, "File inode %c%u has been reconnected to /lost+found/.", fsck_debug},
  /*  76 */ { fsck_INOLKCTFXD, "Link count for inode %s%d has been adjusted/corrected.", fsck_debug},
  /*  77 */ { fsck_DEVLOCKRC, "IOCtl(...DSK_LOCKDRIVE...) returned rc = %s", fsck_debug},
  /*  78 */ { fsck_INONOPATHS, "No paths were found for inode %s%d.", fsck_debug},
  /*  79 */ { fsck_INOPATHOK, "File system object %s%s%d is linked as: %s", fsck_quiet},
  /*  80 */ { fsck_INOREFRMV, "Directory inode %s%d entry reference to inode %s%d removed.", fsck_debug},
  /*  81 */ { fsck_BADSBFWSL, "Invalid fwsp length detected in the superblock (%s).", fsck_debug},
  /*  82 */ { fsck_BADSBFWSA, "Invalid fwsp address detected in the superblock (%s).", fsck_debug},
  /*  83 */ { fsck_DEVOPENRDRC, "Open(...READONLY...) returned rc = %d", fsck_debug},
  /*  84 */ { fsck_CANTCHKEA, "MINOR: Insufficient dynamic storage to validate extended attributes format.", fsck_quiet},
  /*  85 */ { fsck_LOGREDOFAIL, "logredo failed (rc=%d).  fsck continuing.", fsck_quiet},
  /*  86 */ { fsck_LOGREDORC, "logredo returned rc = %d", fsck_debug},
  /*  87 */ { fsck_LSFNNOTDIR, "Unable to create a lost+found directory in root  because root already contains a non-directory object named lost+found.  Rename the existing lost+found object in root, mkdir lost+found in the root directory, then run fsck with the -f parameter to reconnect lost files and/or directories.", fsck_quiet},
  /*  88 */ { fsck_MNTFSYS2, "Checking a mounted filesystem does not produce dependable results.", fsck_quiet},
  /*  89 */ { fsck_MODIFIED, "**** Filesystem was modified. ****", fsck_debug},
  /*  90 */ { fsck_DEVREDETERMRC, "ujfs_redeterminemedia() returned rc = %s", fsck_debug},
  /*  91 */ { fsck_MRKSBDONE, "Superblock marked.", fsck_debug},
  /*  92 */ { fsck_MSSNGBLKS, "%lld blocks are missing.", fsck_quiet},
  /*  93 */ { fsck_CNTWRTBS, "Unable to write to boot sector.  Continuing.", fsck_quiet},
  /*  94 */ { fsck_LSFNNOTFOUND, "No \\lost+found directory found in the filesystem.", fsck_debug},
  /*  95 */ { fsck_BADLINKCTS, "Incorrect link counts detected in the aggregate.", fsck_quiet},
  /*  96 */ { fsck_BADIAMAGNBI, "The Inode Allocation Map control information has an incorrect number of backed inodes value for AG %s%d.", fsck_debug},
  /*  97 */ { fsck_BADIAMAGNFI, "The Inode Allocation Map control information has an incorrect number of free inodes value for AG %s%d.", fsck_debug},
  /*  98 */ { fsck_URCVREAD, "Unrecoverable error reading %s from %s.  CANNOT CONTINUE.", fsck_quiet},
  /*  99 */ { fsck_PHASE0, "**Phase 0 - Replay Journal Log", fsck_quiet},
  /* 100 */ { fsck_PHASE1, "**Phase 1 - Check Blocks, Files/Directories, and  Directory Entries", fsck_quiet},
  /* 101 */ { fsck_PHASE2, "**Phase 2 - Count links", fsck_quiet},
  /* 102 */ { fsck_PHASE3, "**Phase 3 - Duplicate Block Rescan and Directory Connectedness", fsck_quiet},
  /* 103 */ { fsck_PHASE4, "**Phase 4 - Report Problems", fsck_quiet},
  /* 104 */ { fsck_PHASE5, "**Phase 5 - Check Connectivity", fsck_quiet},
  /* 105 */ { fsck_PHASE6, "**Phase 6 - Perform Approved Corrections", fsck_quiet},
  /* 106 */ { fsck_PHASE7R, "**Phase 7 - Rebuild File/Directory Allocation Maps", fsck_quiet},
  /* 107 */ { fsck_PHASE8R, "**Phase 8 - Rebuild Disk Allocation Maps", fsck_quiet},
  /* 108 */ { fsck_PHASE9, "**Phase 9 - Reformat File System Log", fsck_quiet},
  /* 109 */ { fsck_WILLRMVBADENTRY, "Directory has entry for unallocated file %s%u. Will remove.", fsck_quiet},
  /* 110 */ { fsck_ERRONAITRD, "FATAL ERROR (%d,%d) ON READ Aggregate Inode Table (%d) first extent.", fsck_debug},
  /* 111 */ { fsck_WILLCLEAREA, "Format error in Extended Attributes Space or descriptor. Will clear.", fsck_quiet},
  /* 112 */ { fsck_BADIAMIAGPXDL, "The extent descriptor for inodes %d through %d is invalid.  (Inode Allocation Map %s%s, Inode Allocation Group %d, Extent Index %d).", fsck_debug},
  /* 113 */ { fsck_EAFORMATBAD, "Extended attributes for file set object %s%s%d have an invalid format.", fsck_debug},
  /* 114 */ { fsck_REPAIRSINPROGRESS, "Superblock marked dirty because repairs are about to be written.", fsck_debug},
  /* 115 */ { fsck_PRMMUTEXCLLEVELS, "Mutually exclusive 'check READ ONLY' and 'fix file system' options specified.", fsck_quiet},
  /* 116 */ { avail_116, "*undefined*", fsck_quiet},
  /* 117 */ { fsck_PRMUNRECOPTION, "Unrecognized  -f parameter value detected:   %s", fsck_quiet},
  /* 118 */ { fsck_PRMUNSUPPENUM, "Unsupported  parameter:   %s", fsck_quiet},
  /* 119 */ { fsck_LOGFORMATFAIL, "logformat failed (rc=%d).  fsck continuing.", fsck_quiet},
  /* 120 */ { fsck_LOGFORMATRC, "logformat returned rc = %d", fsck_debug},
  /* 121 */ { fsck_CNTRDDEVCHAR, "Unable to read device characteristics.  Boot sector cannot be refreshed.  Continuing.", fsck_quiet},
  /* 122 */ { fsck_SBBADP, "Primary superblock is corrupt.", fsck_debug},
  /* 123 */ { fsck_BADIAG, "Inode Allocation Group %s%d is inconsistent.", fsck_debug},
  /* 124 */ { fsck_BADIAMIAGPXDU, "cannot repair an allocation error for files and/or directories %d through %d.", fsck_quiet},
  /* 125 */ { fsck_RINOTDIR, "Root inode is not a directory.", fsck_debug},
  /* 126 */ { fsck_RIUNALLOC, "Root inode is not allocated.", fsck_debug},
  /* 127 */ { fsck_ROOTALLOC, "Root inode allocated.", fsck_debug},
  /* 128 */ { fsck_ROOTNOWDIR, "Root inode changed to directory.", fsck_debug},
  /* 129 */ { fsck_DEVUNLOCKRC, "IOCtl(...DSK_UNLOCKDRIVE...) returned rc = %d", fsck_debug},
  /* 130 */ { fsck_SBOKP, "Primary superblock is valid.", fsck_debug},
  /* 131 */ { fsck_SESSEND, "processing terminated:  %s  with return code: %d  exit code: %d.", fsck_debug},
  /* 132 */ { fsck_DEVCLOSERC, "Close returned rc = %d", fsck_debug},
  /* 133 */ { fsck_SESSPRMDFLT, "Using default parameter: -p", fsck_debug},
  /* 134 */ { fsck_DEVOPENRDWRRC, "Open(...READ/WRITE EXCLUSIVE...) returned rc = %d", fsck_debug},
  /* 135 */ { fsck_UALINOREF, "One or more directory entry found for unallocated inode %s%s.", fsck_debug},
  /* 136 */ { fsck_CANTRECOVERINOS, "cannot recover files and/or directories %d through %d.   CANNOT CONTINUE.", fsck_quiet},
  /* 137 */ { fsck_URCVWRT, "Unrecoverable error writing %s to %s.  CANNOT CONTINUE.", fsck_quiet},
  /* 138 */ { fsck_WILLFIXRIBADDATFMT, "The root directory has an invalid data format.  Will correct.", fsck_quiet},
  /* 139 */ { fsck_WILLFIXRIBADFMT, "The root directory has an invalid format.  Will correct.", fsck_quiet},
  /* 140 */ { fsck_WILLRELEASEINOS, "cannot recover files and/or directories %d through %d.  Will release.", fsck_quiet},
  /* 141 */ { fsck_BADINOCLAIMSDUPSF, "File claims cross linked block(s).", fsck_quiet},
  /* 142 */ { fsck_BADINODATAFORMAT, "cannot repair the data format error(s) in this file.", fsck_quiet},
  /* 143 */ { fsck_BADINOFORMAT, "cannot repair the format error(s) in this file.", fsck_quiet},
  /* 144 */ { fsck_CANTREPAIRINO, "cannot repair %s%s%d.", fsck_quiet},
  /* 145 */ { fsck_DRIVEID, "The current device is:  %s", fsck_quiet},
  /* 146 */ { fsck_DRIVETYPE, "The type of file system for the device is JFS.", fsck_debug},
  /* 147 */ { fsck_WILLRELEASEINO, "cannot repair %s%s%d.  Will release.", fsck_quiet},
  /* 148 */ { fsck_SBOKS, "Secondary superblock is valid.", fsck_debug},
  /* 149 */ { fsck_WRSUP, "Unable to open for write access.  Proceeding in read-only mode.", fsck_quiet},
  /* 150 */ { fsck_WILLFIXDIRWHDLKS, "Multiple parent directories for directory %s%d.  Will correct.", fsck_quiet},
  /* 151 */ { fsck_WILLFIXINCREF, "Directory %s%d entry \"..\" refers to an incorrect parent directory (%s%s). Will correct.", fsck_quiet},
  /* 152 */ { fsck_XTRABLKS, "%lld unexpected blocks detected.", fsck_quiet},
  /* 153 */ { fsck_RODIRSWHLKS, "Directories with illegal hard links have been detected.", fsck_quiet},
  /* 154 */ { fsck_ROINCINOREFS, "Directory entries (entries \"..\") referring to incorrect parent directories have been detected.", fsck_quiet},
  /* 155 */ { fsck_ROUALINOREFS, "Directory entries for unallocated files have been detected.", fsck_quiet},
  /* 156 */ { fsck_CNTWRTSUPS, "Unable to write secondary superblock.", fsck_quiet},
  /* 157 */ { fsck_WILLFIXLINKCTS, "Incorrect link counts have been detected. Will correct.", fsck_quiet},
  /* 158 */ { fsck_INOINLINECONFLICT, "File set object %s%s%d has inline data conflict (type %d).", fsck_debug},
  /* 159 */ { fsck_DUPBLKMDREFS, "Duplicate block references have been detected in Metadata.  CANNOT CONTINUE.", fsck_quiet},
  /* 160 */ { fsck_DUPBLKMDREF, "Multiple metadata references to %d blocks beginning at offset %lld have been detected.", fsck_debug},
  /* 161 */ { fsck_BADDINOFREELIST1, "Directory inode %s%d has a node with empty freelist and nonzero freecount.", fsck_debug},
  /* 162 */ { fsck_CANTREADEAITEXT1, "Unable to read entire first extent of AIT (%s).", fsck_debug},
  /* 163 */ { fsck_CANTREADAITEXT1, "Unable to read first extent of AIT (%s).", fsck_debug},
  /* 164 */ { fsck_URCVUNLCK, "Unrecoverable error during UNLOCK processing.", fsck_quiet},
  /* 165 */ { fsck_URCVCLOSE, "Unrecoverable error during CLOSE processing.", fsck_quiet},
  /* 166 */ { fsck_RICRRCTDREF, "The root directory reference (entry \"..\") has been corrected.", fsck_debug},
  /* 167 */ { fsck_INOPATHCRCT, "%s appears to be the correct path for directory %s%d.", fsck_quiet},
  /* 168 */ { fsck_RODIRWHLKS, "Directory inode %s%u has illegal hard links.", fsck_debug},
  /* 169 */ { fsck_ROINCINOREF, "Directory inode %s%u refers (entry \"..\") to an incorrect inode (%s%u).", fsck_debug},
  /* 170 */ { fsck_ROUALINOREF, "One or more directory entry found for unallocated inode %s%u.", fsck_debug},
  /* 171 */ { fsck_ERRORSDETECTED, "ERRORS HAVE BEEN DETECTED.  Run fsck with the -f parameter to repair.", fsck_quiet},
  /* 172 */ { fsck_RIINCINOREF, "The root directory refers (entry \"..\") to an incorrect inode.", fsck_debug},
  /* 173 */ { fsck_INOSINLSFND, "%u directory reconnected to /lost+found/.", fsck_quiet},
  /* 174 */ { fsck_MNCNTRCNCTINOSD, "MINOR: Unable to reconnect %u directory.  Continuing.", fsck_quiet},
  /* 175 */ { fsck_ROUNCONNIO, "Inode %s%u is not connected to the root directory tree.", fsck_debug},
  /* 176 */ { fsck_XCHKLOGNEW, "XCHKLOG  Most recent fsck service log extracted into:  %s", fsck_debug},
  /* 177 */ { fsck_XCHKLOGOLD, "XCHKLOG  Prior fsck service log extracted into:  %s", fsck_debug},
  /* 178 */ { fsck_XCHKLOGOPNFAIL, "XCHKLOG  Can't open output file:  %s", fsck_debug},
  /* 179 */ { fsck_BADINOSTAMP, "Invalid stamp detected in file system object %s%s%d.", fsck_debug},
  /* 180 */ { fsck_ROUNCONNIOS, "Files and/or directories not connected to the root directory tree have been detected.", fsck_quiet},
  /* 181 */ { fsck_WILLFIXROUALINOREFS, "Directory entries for unallocated files have been detected.  Will remove.", fsck_quiet},
  /* 182 */ { fsck_WILLFIXROUNCONNIOS, "Files and/or directories not connected to the root directory tree have been detected.  Will reconnect.", fsck_quiet},
  /* 183 */ { fsck_WILLFIXRODIRSWHLKS, "Directories with illegal hard links have been detected.  Will correct.", fsck_quiet},
  /* 184 */ { fsck_WILLFIXROINCINOREFS, "Directories (entries \"..\") referring to incorrect parent directories have been detected.  Will correct.", fsck_quiet},
  /* 185 */ { fsck_XCHKDMPOPNFAIL, "XCHKDMP  Can't open input file:  %s", fsck_debug},
  /* 186 */ { fsck_AGGCLN, "Filesystem is clean.", fsck_quiet},
  /* 187 */ { fsck_AGGCLNNOTDRTY, "Filesystem is clean but is marked dirty.  Run fsck with the -f parameter to fix.", fsck_quiet},
  /* 188 */ { fsck_AGGDRTY, "Filesystem is dirty.", fsck_quiet},
  /* 189 */ { fsck_AGGDRTYNOTCLN, "Filesystem is dirty but is marked clean.  In its present state,\nthe results of accessing %s (except by this utility) are undefined.", fsck_quiet},
  /* 190 */ { fsck_AGGMRKDCLN, "Filesystem has been marked clean.", fsck_debug},
  /* 191 */ { fsck_AGGMRKDDRTY, "Filesystem has been marked dirty because it contains critical errors.  Filesystem may be unrecoverable.", fsck_quiet},
  /* 192 */ { fsck_BADINOMTNODE, "File system object %s%s%d has an illegal empty node.", fsck_debug},
  /* 193 */ { fsck_BADINOODDINTRNEXT, "File system object %s%s%d -- extent at offset %lld has an invalid size (%d).", fsck_debug},
  /* 194 */ { fsck_BADINOFRONTGAP, "Dense file (inode %s%d) begins with an unallocated section.", fsck_debug},
  /* 195 */ { fsck_BADINOINTERNGAP, "Dense file (inode %s%d) has an unallocated section after offset %lld.", fsck_debug},
  /* 196 */ { fsck_BADAGFELIST1, "The Free Inode Extent List is inconsistent for Allocation Group %s%d.", fsck_debug},
  /* 197 */ { fsck_BADAGFILIST, "Discrepancies detected in the Free Inode List for Allocation Group %s%d. (%s)", fsck_debug},
  /* 198 */ { fsck_BADAGFILIST1, "The Free Inode List is inconsistent for Allocation Group %s%d.", fsck_debug},
  /* 199 */ { fsck_BADIAGAG, "Inode Allocation Group %s%d has an invalid Allocation Group (%lld).", fsck_debug},
  /* 200 */ { fsck_BADDIRENTRY, "Directory has an entry for an unallocated file %s%u.", fsck_quiet},
  /* 201 */ { fsck_BADDINONODESIZ, "Directory inode %s%d has a node with incorrect size.", fsck_debug},
  /* 202 */ { fsck_BADDINOODDNODESIZ, "Directory inode %s%d has a node with invalid size.", fsck_debug},
  /* 203 */ { fsck_BADDINOFREELIST4, "Directory inode %s%d has a node with an invalid freelist.", fsck_debug},
  /* 204 */ { fsck_BADDINOFREELIST2, "Directory inode %s%d has a node with an incorrect freecount.", fsck_debug},
  /* 205 */ { fsck_BADDINOFREELIST3, "Directory inode %s%d has a node with an incorrect freelist.", fsck_debug},
  /* 206 */ { fsck_BADIAGAGSTRT, "Inode Allocation Group %s%d has an invalid AG Start.", fsck_debug},
  /* 207 */ { fsck_BADIAGFIES, "Inode Allocation Group %s%d has an invalid Free Extent Summary.", fsck_debug},
  /* 208 */ { fsck_BADIAGFIS, "Inode Allocation Group %d%d has an invalid Free Inode Summary.", fsck_debug},
  /* 209 */ { fsck_BADIAGFLIST, "Discrepancies detected in the Free IAG List. (%s,%s)", fsck_debug},
  /* 210 */ { fsck_BADIAGFL1, "The Free Inode Allocation Group List is inconsistent (%s).", fsck_debug},
  /* 211 */ { fsck_BADIAGIAGNUM, "Inode Allocation Group %s%d has an incorrect IAG number value.", fsck_debug},
  /* 212 */ { fsck_BADIAGNFEXT, "Inode Allocation Group %s%d has an inconsistent count for number of free extents.", fsck_debug},
  /* 213 */ { fsck_BADIAGNFINO, "Inode Allocation Group %s%d has an inconsistent count for number of free inodes.", fsck_debug},
  /* 214 */ { fsck_BADIAGPMAP, "Discrepancies detected in the pmap for Inode Allocation Group %s%d.", fsck_debug},
  /* 215 */ { fsck_BADIAM, "Errors detected in the Fileset File/Directory Allocation Map. (%s)", fsck_quiet},
  /* 216 */ { fsck_BADIAMBPIE, "The Inode Allocation Map blocks per inode extent is incorrect (%s).", fsck_debug},
  /* 217 */ { fsck_BADIAMCTL, "Errors detected in the Fileset File/Directory Allocation Map control information. (%s)", fsck_quiet},
  /* 218 */ { fsck_BADIAML2BPIE, "The Inode Allocation Map log2(blocks per inode extent) is incorrect (%s).", fsck_debug},
  /* 219 */ { fsck_BADIAMNBI, "The Inode Allocation Map has an incorrect number of backed inodes value (%s).", fsck_debug},
  /* 220 */ { fsck_BADIAMNFI, "The Inode Allocation Map has an incorrect number of free inodes value (%s).", fsck_debug},
  /* 221 */ { fsck_BADIAMNXTIAG, "The Inode Allocation Map has an incorrect next IAG value (%s).", fsck_debug},
  /* 222 */ { fsck_XCHKDMPUSAGE, "Usage: xchkdmp [-f filename] [-V]", fsck_debug},
  /* 223 */ { fsck_BADIAGAGCRCTD, "Correcting Inode Allocation Group %s%d invalid Allocation Group (%lld).", fsck_debug},
  /* 224 */ { fsck_BADIAGAGSTRTCRCTD, "Correcting Inode Allocation Group %s%d invalid AG Start.", fsck_debug},
  /* 225 */ { fsck_BADBMAPSLFV, "Inconsistencies detected in leaf values (%s).", fsck_debug},
  /* 226 */ { fsck_BADBMAPSLNV, "Inconsistencies detected in internal values (%s).", fsck_debug},
  /* 227 */ { fsck_BADBMAPSOTHER, "Incorrect data detected in pages (%s).", fsck_debug},
  /* 228 */ { fsck_BADDMAPPMAPS, "Descrepancies detected between observed block allocations and pmaps.", fsck_debug},
  /* 229 */ { fsck_BADBLKALLOC, "Incorrect data detected in disk allocation structures.", fsck_quiet},
  /* 230 */ { fsck_BADBLKALLOCCTL, "Incorrect data detected in disk allocation control structures.", fsck_quiet},
  /* 231 */ { fsck_BMAPBADHT, "Incorrect height detected in in page %s,%d.", fsck_debug},
  /* 232 */ { fsck_BMAPBADL2NLF, "Incorrect l2 number of leafs detected in in page %s,%d.", fsck_debug},
  /* 233 */ { fsck_BMAPBADLFI, "Incorrect leaf index detected in in page %s,%d.", fsck_debug},
  /* 234 */ { fsck_BMAPBADLFV, "Incorrect leaf (%d) value detected in %s page %d.", fsck_debug},
  /* 235 */ { fsck_BMAPBADLNV, "Incorrect internal (%d) value detected in %s page %d.", fsck_debug},
  /* 236 */ { fsck_BMAPBADBMN, "Incorrect budmin detected in in page %s,%d.", fsck_debug},
  /* 237 */ { fsck_BMAPBADNLF, "Incorrect number of leafs detected in page %s,%d.", fsck_debug},
  /* 238 */ { fsck_BMAPCAGNF, "Incorrect number of free blocks in AG %d detected in Block Map Control Page.", fsck_debug},
  /* 239 */ { fsck_BMAPCASB, "Incorrect aggregate size detected in Block Map Control Page.", fsck_debug},
  /* 240 */ { fsck_BMAPCBPAG, "Incorrect blocks per AG detected in Block Map Control Page.", fsck_debug},
  /* 241 */ { fsck_BMAPCDMCLAG, "Incorrect dmap control level detected in Block Map Control Page.", fsck_debug},
  /* 242 */ { fsck_BMAPCDMCLH, "Incorrect dmap control height detected in Block Map Control Page.", fsck_debug},
  /* 243 */ { fsck_BMAPCDMCLW, "Incorrect dmap control width detected in Block Map Control Page.", fsck_debug},
  /* 244 */ { fsck_BMAPCL2BPAG, "Incorrect l2 blocks per AG detected in Block Map Control Page.", fsck_debug},
  /* 245 */ { fsck_BMAPCL2BPP, "Incorrect l2 blocks per page detected in Block Map Control Page.", fsck_debug},
  /* 246 */ { fsck_BMAPCMAAG, "Incorrect maximum active AGs detected in Block Map Control Page.", fsck_debug},
  /* 247 */ { fsck_BMAPCMXLVL, "Incorrect maximum level detected in Block Map Control Page.", fsck_debug},
  /* 248 */ { fsck_BMAPCNAG, "Incorrect number of AGs detected in Block Map Control Page.", fsck_debug},
  /* 249 */ { fsck_BMAPCPAG, "Invalid preferred AG detected in Block Map Control Page.", fsck_debug},
  /* 250 */ { fsck_XCHKLOGSBOK, "XCHKLOG  %s superblock is valid.", fsck_debug},
  /* 251 */ { fsck_DMAPBADNBLK, "Incorrect number of blocks detected in dmap %d.", fsck_debug},
  /* 252 */ { fsck_DMAPBADNFREE, "Incorrect number free detected in dmap %d.", fsck_debug},
  /* 253 */ { fsck_DMAPBADSTRT, "Incorrect start detected in dmap %d.", fsck_debug},
  /* 254 */ { fsck_PMAPSBOFF, "%lld consecutive blocks observed available but pmap (%d, %d, %d) indicates they are allocated.", fsck_debug},
  /* 255 */ { fsck_PMAPSBON, "%lld consecutive blocks observed allocated but pmap (%d, %d, %d) indicates they are available.", fsck_debug},
  /* 256 */ { fsck_BADBMAPCAGFCL, "Discrepancies detected in the Block Map Control Page AG free count list.", fsck_debug},
  /* 257 */ { fsck_BADBMAPCOTH, "Incorrect data detected in the Block Map Control Page.", fsck_debug},
  /* 258 */ { fsck_BMAPCDMCSTI, "Incorrect dmap control start index detected in Block Map Control Page.", fsck_debug},
  /* 259 */ { fsck_BADSBFWSL1, "Incorrect fwsp length detected in the superblock (%s).", fsck_debug},
  /* 260 */ { fsck_BADSBFJLA, "Incorrect jlog address detected in the superblock (%s).", fsck_debug},
  /* 261 */ { fsck_BADSBFJLL, "Incorrect jlog length detected in the superblock (%s).", fsck_debug},
  /* 262 */ { fsck_HEARTBEAT0, "|........\r", fsck_hrtbt},
  /* 263 */ { fsck_HEARTBEAT1, ".|.......\r", fsck_hrtbt},
  /* 264 */ { fsck_HEARTBEAT2, "..|......\r", fsck_hrtbt},
  /* 265 */ { fsck_HEARTBEAT3, "...|.....\r", fsck_hrtbt},
  /* 266 */ { fsck_HEARTBEAT4, "....|....\r", fsck_hrtbt},
  /* 267 */ { fsck_HEARTBEAT5, ".....|...\r", fsck_hrtbt},
  /* 268 */ { fsck_HEARTBEAT6, "......|..\r", fsck_hrtbt},
  /* 269 */ { fsck_HEARTBEAT7, ".......|.\r", fsck_hrtbt},
  /* 270 */ { fsck_HEARTBEAT8, "........|\r", fsck_hrtbt},
  /* 271 */ { fsck_BADINOCLAIMSDUPSD, "Directory claims cross linked block(s).", fsck_quiet},
  /* 272 */ { fsck_BADINOCLAIMSDUPSO, "File system object claims cross linked block(s).", fsck_quiet},
  /* 273 */ { fsck_SPARSEFILSYS, "File system is formatted for sparse files.", fsck_quiet},
  /* 274 */ { fsck_INCDASDUSEDCRCT, "Directory inode %s%d incorrect DASD used value corrected.", fsck_debug},
  /* 275 */ { fsck_INOSINLSFNDS, "%u directories reconnected to /lost+found/.", fsck_quiet},
  /* 276 */ { fsck_INOSINLSFNF, "%u file reconnected to /lost+found/.", fsck_quiet},
  /* 277 */ { fsck_INOSINLSFNFS, "%u files reconnected to /lost+found/.", fsck_quiet},
  /* 278 */ { fsck_BADINODATAFORMATD, "cannot repair the data format error(s) in this directory.", fsck_quiet},
  /* 279 */ { fsck_BADINOFORMATD, "cannot repair the format error(s) in this directory.", fsck_quiet},
  /* 280 */ { fsck_BADINODATAFORMATO, "cannot repair the data format error(s) in this file system object.", fsck_quiet},
  /* 281 */ { fsck_BADINOFORMATO, "cannot repair the format error(s) in this file system object.", fsck_quiet},
  /* 282 */ { fsck_PHASE7V, "**Phase 7 - Verify File/Directory Allocation Maps", fsck_quiet},
  /* 283 */ { fsck_PHASE8V, "**Phase 8 - Verify Disk Allocation Maps", fsck_quiet},
  /* 284 */ { fsck_PARMOMITLOGREDO, "parameter detected:  Omit logredo()", fsck_debug},
  /* 285 */ { fsck_NOTJFSINFSTAB, "The file system type for %s is not listed as jfs \nin the file system description file /etc/fstab.", fsck_quiet},
  /* 286 */ { avail_286, "*undefined*", fsck_debug},
  /* 287 */ { avail_287, "*undefined*", fsck_debug},
  /* 288 */ { avail_288, "*undefined*", fsck_debug},
  /* 289 */ { avail_289, "*undefined*", fsck_debug},
  /* 290 */ { fsck_BADMETAINOP, "Primary metadata inode %s%d is corrupt.", fsck_debug},
  /* 291 */ { fsck_BADMETAINOS, "Secondary metadata inode %s%d is corrupt.", fsck_debug},
  /* 292 */ { fsck_SBBADS, "Secondary superblock is corrupt.", fsck_debug},
  /* 293 */ { fsck_CANTREADAITS, "Unable to read the Secondary File/Directory Allocation Table.", fsck_quiet},
  /* 294 */ { fsck_BADIAMCTLA, "Errors detected in the File System File/Directory Allocation Map.", fsck_quiet},
  /* 295 */ { fsck_BADIAMA, "Errors detected in the File System File/Directory Allocation Map control information.", fsck_quiet},
  /* 296 */ { fsck_ERRORSINAITS, "Errors detected in the Secondary File/Directory Allocation Table.", fsck_quiet},
  /* 297 */ { fsck_CNTRESUPS, "Unable to read secondary superblock.", fsck_debug},
  /* 298 */ { avail_298, "*undefined*", fsck_debug},
  /* 299 */ { avail_299, "*undefined*", fsck_debug},
  /* 300 */ { avail_300, "*undefined*", fsck_debug},
  /* 301 */ { fsck_MNCNTRCNCTINOSDS, "MINOR: Unable to reconnect %u directories.  Continuing.", fsck_quiet},
  /* 302 */ { fsck_MNCNTRCNCTINOSF, "MINOR: Unable to reconnect %u file.  Continuing.", fsck_quiet},
  /* 303 */ { fsck_MNCNTRCNCTINOSFS, "MINOR: Unable to reconnect %u files.  Continuing.", fsck_quiet},
  /* 304 */ { avail_304, "*undefined*", fsck_debug},
  /* 305 */ { avail_305, "*undefined*", fsck_debug},
  /* 306 */ { avail_306, "*undefined*", fsck_debug},
  /* 307 */ { avail_307, "*undefined*", fsck_debug},
  /* 308 */ { avail_308, "*undefined*", fsck_debug},
  /* 309 */ { fsck_INOINLSFND, "Directory inode %c%u has been reconnected to /lost+found/.", fsck_debug},
  /* 310 */ { fsck_MNCNTRCNCTINOD, "MINOR: Unable to reconnect directory inode %c%u.  Continuing.", fsck_debug},
  /* 311 */ { avail_311, "*undefined*", fsck_debug},
  /* 312 */ { fsck_CNTRESUPB, "Unable to read either superblock.", fsck_debug},
  /* 313 */ { fsck_STDSUMMARY1, "%9lld kilobytes total disk space.", fsck_quiet},
  /* 314 */ { fsck_STDSUMMARY2, "%9lld kilobytes in %lld directories.", fsck_quiet},
  /* 315 */ { fsck_STDSUMMARY3, "%9lld kilobytes in %lld user files.", fsck_quiet},
  /* 316 */ { fsck_STDSUMMARY4, "%9lld kilobytes in extended attributes", fsck_quiet},
  /* 317 */ { fsck_STDSUMMARY5, "%9lld kilobytes reserved for system use.", fsck_quiet},
  /* 318 */ { fsck_STDSUMMARY6, "%9lld kilobytes are available for use.", fsck_quiet},
  /* 319 */ { fsck_XCHKDMPMTORBADREAD, "XCHKDMP Can't read input file:  %s", fsck_debug},
  /* 320 */ { fsck_XCHKDMPBADFORMAT, "XCHKDMP Input file (%s) not recognized as an extracted JFS fsck service log.", fsck_debug},
  /* 321 */ { fsck_XCHKLOGBADDEVICE, "XCHKLOG  Cannot open device %s", fsck_debug},
  /* 322 */ { fsck_XCHKLOGBADFNAME, "XCHKLOG  Output file path and name must be less than 128 characters.", fsck_debug},
  /* 323 */ { fsck_XCHKDMPBADFNAME, "XCHKDMP  Input file path and name must be less than 128 characters.", fsck_debug},
  /* 324 */ { fsck_CANTREADAITP, "Unable to read the Primary File/Directory Allocation Table.", fsck_quiet},
  /* 325 */ { fsck_ERRORSINAITP, "Errors detected in the Primary File/Directory Allocation Table.", fsck_quiet},
  /* 326 */ { fsck_CANTCONTINUE, "CANNOT CONTINUE.", fsck_quiet},
  /* 327 */ { fsck_CANTINITSVCLOG, "**********  CANNOT INITIALIZE THIS SERVICE LOG.  DISREGARD RESIDUAL LOG MESSAGES WHICH MAY BE APPENDED. **********", fsck_debug},
  /* 328 */ { fsck_CHKLOGNOVOL, "CHKLOG  Required parameter missing:  device specification", fsck_debug},
  /* 329 */ { fsck_XCHKLOGNOVOL, "XCHKLOG  Required parameter missing:  device specification", fsck_debug},
  /* 330 */ { fsck_PARMFIXLVL, "parameter detected:  FixLevel: %s", fsck_debug},
  /* 331 */ { fsck_PARMIFDRTY, "parameter detected:  IfDirty", fsck_debug},
  /* 332 */ { fsck_PARMVERBOSE, "parameter detected:  VerboseMessaging", fsck_debug},
  /* 333 */ { fsck_PARMAUTOCHK, "parameter detected:  AutoCheck mode", fsck_debug},
  /* 334 */ { fsck_PARMPMCHK, "parameter detected:  PMchkdsk mode", fsck_debug},
  /* 335 */ { fsck_PARMDEBUG, "parameter detected:  Debug mode", fsck_debug},
  /* 336 */ { fsck_CHKDSKSYSALLOC, "CHKDSK.SYS returned %s bytes of high memory at %s", fsck_debug},
  /* 337 */ { fsck_CHKDSKSYSOPENRC, "Open(CHKDSK.SYS,...) returned rc = %s", fsck_debug},
  /* 338 */ { fsck_CHKDSKSYSCALLRC, "IOCtl( ... ) to call CHKDSK.SYS returned rc = %s, data.rc = %s", fsck_debug},
  /* 339 */ { fsck_DEVBEGINFMTRC, "ujfs_beginformat() returned rc = %s", fsck_debug},
  /* 340 */ { fsck_PARMCLRBDBLKLST, "parameter detected:  Clear LVM Bad Block List", fsck_debug},
  /* 341 */ { fsck_CHKDSKFSSYNCHRC, "(JFSCTL_CHKDSK, ... ) returned rc = %s", fsck_debug},
  /* 342 */ { fsck_LVMFOUNDBDBLKS, "warning: The LVM has detected bad blocks in the partition.  Run  /B to transfer entries from the LVM bad block table to the JFS bad block table.", fsck_quiet},
  /* 343 */ { fsck_LVMGETBBLKINFORC, "LVM GetBadBlockInformation returned rc = %s", fsck_debug},
  /* 344 */ { fsck_LVMGETTBLSIZERC, "LVM GetTableSize rc = %s", fsck_debug},
  /* 345 */ { fsck_LVMFSNOWAVAIL, "THE FILE SYSTEM IS NOW AVAILABLE.", fsck_quiet},
  /* 346 */ { fsck_LVMTRNSBBLKSTOJFS, "Transferring entries from the LVM Bad Block Table for this file system to the JFS Bad Block Table for this file system.", fsck_quiet},
  /* 347 */ { fsck_INTERNALERROR, "INTERNAL ERROR (%d,%d,%d,%d).  CANNOT CONTINUE.", fsck_quiet},
  /* 348 */ { fsck_CLRBBACTIVITY, "CLRBBLKS:  relocated %s extents, for total %s relocated blocks.", fsck_debug},
  /* 349 */ { fsck_CLRBBLVMLISTDATA, "CLRBBLKS: LVM List #%s  num entries = %s  num active entries = %s", fsck_debug},
  /* 350 */ { fsck_CLRBBLVMNUMLISTS, "CLRBBLKS: number of LVM Lists = %s", fsck_debug},
  /* 351 */ { fsck_CLRBBRANGE, "CLRBBLKS: Attempted to relocate bad blocks in range %s to %s.", fsck_debug},
  /* 352 */ { fsck_CLRBBRESULTS, "LVM reports %s bad blocks.  Of these, %s have been transferred to the JFS Bad Block List.", fsck_quiet},
  /* 353 */ { fsck_CLRBBLKSRC, "CLRBBLKS rc = %s", fsck_debug},
  /* 354 */ { fsck_DOSEXECPGMRC, "DosExecPgm(...clrbblks...) rc = %s", fsck_debug},
  /* 355 */ { fsck_DEVOPENRDWRSRC, "Open(...OPEN_SHARE_DENYNONE|OPEN_ACCESS_READWRITE...) returned rc = %s", fsck_debug},
  /* 356 */ { fsck_CLRBBOPENFAILED, "Device unavailable or locked by another process.   CANNOT CONTINUE.", fsck_quiet},
  /* 357 */ { fsck_BADINONODESELF, "File system object %s%s%d has a node with an invalid self field.", fsck_debug},
  /* 358 */ { fsck_INOPATHBAD, "File system object %s%s%d is illegally linked as: %s", fsck_quiet},
  /* 359 */ { fsck_CANTRECONINSUFSTG, "Insufficient storage (%d) available to continue reconnecting lost files and/or directories. Continuing.", fsck_quiet},
  /* 360 */ { fsck_INOACL, "Format error in Access Control List space or descriptor.", fsck_quiet},
  /* 361 */ { fsck_WILLCLEARACL, "Format error in Access Control List space or descriptor. Will clear.", fsck_quiet},
  /* 362 */ { fsck_INOACLCLRD, "Storage allocated to Access Control List for inode %s%d has been cleared.", fsck_debug},
  /* 363 */ { fsck_STDSUMMARY4A, "%9lld kilobytes in access control lists", fsck_debug},
  /* 364 */ { fsck_EXHFILSYSSTG, "File system is full or too fragmented to allocated requested %d blocks.", fsck_debug},
  /* 365 */ { fsck_INOMINOR, "Minor format error detected.", fsck_quiet},
  /* 366 */ { fsck_INOMINORFXD, "Minor format error in inode %s%d has been corrected.", fsck_debug},
  /* 367 */ { fsck_WILLFIXINOMINOR, "Minor format error detected. Will fix.", fsck_quiet},
  /* 368 */ { fsck_BADINODXDFLDL, "File system object %s%s%d has invalid length in descriptor (%s).", fsck_debug},
  /* 369 */ { fsck_BADINODXDFLDO, "File system object %s%s%d has invalid offset in descriptor (%s).", fsck_debug},
  /* 370 */ { fsck_READONLY, "File system checked READ ONLY.", fsck_quiet},
  /* 371 */ { fsck_PRMBADDEVICE	, "Device does not exist.", fsck_quiet},
  /* 372 */ { fsck_PRMNODEVICE	, "No device given.", fsck_quiet},
  /* 373 */ { avail_373, "*undefined*", fsck_debug},
  /* 374 */ { avail_374, "*undefined*", fsck_debug},
  /* 375 */ { avail_375, "*undefined*", fsck_debug},
  /* 376 */ { avail_376, "*undefined*", fsck_debug},
  /* 377 */ { avail_377, "*undefined*", fsck_debug},
  /* 378 */ { avail_378, "*undefined*", fsck_debug},
  /* 379 */ { avail_379, "*undefined*", fsck_debug},
  /* 380 */ { avail_380, "*undefined*", fsck_debug},
  /* 381 */ { avail_381, "*undefined*", fsck_debug},
  /* 382 */ { avail_382, "*undefined*", fsck_debug},
  /* 383 */ { avail_383, "*undefined*", fsck_debug},
  /* 384 */ { fsck_block_special, "B", fsck_txtins},
  /* 385 */ { fsck_aggregate, "A", fsck_txtins},
  /* 386 */ { fsck_dirpfx, "D", fsck_txtins},
  /* 387 */ { fsck_dmap, "DM", fsck_txtins},
  /* 388 */ { fsck_EA, "E", fsck_txtins},
  /* 389 */ { fsck_fset_inode, "F", fsck_txtins},
  /* 390 */ { fsck_metaIAG, "I", fsck_txtins},
  /* 391 */ { fsck_L0, "L0", fsck_txtins},
  /* 392 */ { fsck_L1, "L1", fsck_txtins},
  /* 393 */ { fsck_L2, "L2", fsck_txtins},
  /* 394 */ { fsck_metadata, "M", fsck_txtins},
  /* 395 */ { fsck_char_special, "C", fsck_txtins},
  /* 396 */ { fsck_primary, "P", fsck_txtins},
  /* 397 */ { fsck_SOCK, "S", fsck_txtins},
  /* 398 */ { fsck_symbolic_link, "L", fsck_txtins},
  /* 399 */ { fsck_dotext, ".RCN", fsck_txtins},
  /* 400 */ { lrdo_ALREADYREDONE, "LOGREDO:  Log already redone!", fsck_debug},
  /* 401 */ { lrdo_LOGEND, "LOGREDO:  End of log found at logend = 0x0%x", fsck_debug},
  /* 402 */ { lrdo_REXTNDBEGIN, "LOGREDO:  Beginning to recover File System Extend processing.", fsck_debug},
  /* 403 */ { lrdo_REXTNDDONE, "LOGREDO:  Done recovering File System Extend processing.", fsck_debug},
  /* 404 */ { lrdo_REXTNDTOPRE, "LOGREDO:  File System Extend recovered to prior size.", fsck_debug},
  /* 405 */ { lrdo_REXTNDTOPOST, "LOGREDO:  File System Extend recovered and completed.", fsck_debug},
  /* 406 */ { lrdo_REXTNDFAIL, "LOGREDO:  Recovery of File System Extend failed.  Error = %s", fsck_debug},
  /* 407 */ { lrdo_LOGSUPBADMGC, "LOGREDO:  Log superblock contains invalid magic number.", fsck_debug},
  /* 408 */ { lrdo_LOGSUPBADVER, "LOGREDO:  Log superblock contains invalid version number.", fsck_debug},
  /* 409 */ { lrdo_LOGENDBAD1, "LOGREDO:  Unable to find valid end of log.", fsck_debug},
  /* 410 */ { lrdo_INITFAILED, "LOGREDO:  Initialization failed.  rc = %d   error num = %d", fsck_debug},
  /* 411 */ { lrdo_LOGSUPBADBLKSZ, "LOGREDO:  Log superblock contains invalid block size.", fsck_debug},
  /* 412 */ { lrdo_LOGSUPBADL2BLKSZ, "LOGREDO:  Log superblock contains invalid log2(block size).", fsck_debug},
  /* 413 */ { lrdo_LOGSUPBADLOGSZ, "LOGREDO:  Log superblock contains invalid log size.", fsck_debug},
  /* 414 */ { lrdo_LOGENDBAD2, "LOGREDO:  Log end is not in valid range.", fsck_debug},
  /* 415 */ { lrdo_RPTSYNCNUM, "LOGREDO:  Synch point record number:  0x0%x", fsck_debug},
  /* 416 */ { lrdo_RPTSYNCADDR, "LOGREDO:  Synch point record address:  0x0%x", fsck_debug},
  /* 417 */ { lrdo_RPTNUMLOGREC, "LOGREDO:  Number of log records:    (d) %d", fsck_debug},
  /* 418 */ { lrdo_RPTNUMDOBLK, "LOGREDO:  Number of Do blocks:    (d) %d", fsck_debug},
  /* 419 */ { lrdo_RPTNUMNODOBLK, "LOGREDO:  Number of NoDo blocks:    (d) %d", fsck_debug},
  /* 420 */ { lrdo_SYNCRECORD, "LOGREDO:  Log record for Sync Point at:    0x0%x", fsck_debug},
  /* 421 */ { lrdo_MOUNTRECORD, "LOGREDO:  Log record for Volume Mount at:    0x0%x", fsck_debug},
  /* 422 */ { fsck_ALLOCHIGHMEM, "Calling CHKDSK.SYS to allocate high memory....", fsck_debug},
  /* 423 */ { fsck_ALLOCHIGHMEMRSLT, "CHKDSK.SYS returned  addr= %s  length= %s", fsck_debug},
  /* 424 */ { lrdo_ALLOC4BMAP, "LOGREDO:  Allocating for BMap:  (d) %d bytes", fsck_debug},
  /* 425 */ { lrdo_ALLOC4IMAP, "LOGREDO:  Allocating for IMap:  (d) %d bytes", fsck_debug},
  /* 426 */ { lrdo_ALLOC4DOBLK, "LOGREDO:  Allocating for DoBLk:  (d) %d bytes", fsck_debug},
  /* 427 */ { lrdo_ALLOC4NOREDOFL, "LOGREDO:  Allocating for NoReDoFile:  (d) %d bytes", fsck_debug},
  /* 428 */ { lrdo_ALLOC4REDOPG, "LOGREDO:  Allocating for ReDoPage:  (d) %d bytes", fsck_debug},
  /* 429 */ { lrdo_ALLOC4NODOFL, "LOGREDO:  Allocating for NoDoFile:  (d) %d bytes", fsck_debug},
  /* 430 */ { lrdo_ALLOC4EXTDTPG, "LOGREDO:  Allocating for ExtendDtPg:  (d) %d bytes", fsck_debug},
  /* 431 */ { lrdo_ALLOC4BMAPFAIL, "LOGREDO:   Failed trying to allocate for BMap:  (d) %lld bytes", fsck_debug},
  /* 432 */ { lrdo_ALLOC4IMAPFAIL, "LOGREDO:  Failed trying to allocate for IMap:  (d) %d bytes", fsck_debug},
  /* 433 */ { lrdo_ALLOC4DOBLKFAIL, "LOGREDO:  Failed trying to allocate for DoBLk:  (d) %d bytes", fsck_debug},
  /* 434 */ { lrdo_ALLOC4NOREDOFLFAIL, "LOGREDO:  Failed trying to allocate for NoReDoFile:  (d) %d bytes", fsck_debug},
  /* 435 */ { lrdo_ALLOC4REDOPGFAIL, "LOGREDO:  Failed trying to allocate for ReDoPage:  (d) %d bytes", fsck_debug},
  /* 436 */ { lrdo_ALLOC4NODOFLFAIL, "LOGREDO:  Failed trying to allocate for NoDoFile:  (d) %d bytes", fsck_debug},
  /* 437 */ { lrdo_ALLOC4EXTDTPGFAIL, "LOGREDO:  Failed trying to allocate for ExtendDtPg:  (d) %d bytes", fsck_debug},
  /* 438 */ { lrdo_USINGBMAPALLOC4IMAP, "LOGREDO:  Working IMap will occupy storage originally allocated for BMap.", fsck_debug},
  /* 439 */ { lrdo_USINGBMAPALLOC4NRFL, "LOGREDO:  Some storage allocated for BMap now used for NoRedoFile records.", fsck_debug},
  /* 440 */ { lrdo_USINGBMAPALLOC4DOBLK, "LOGREDO:  Some storage allocated for BMap now used for DoBLock records.", fsck_debug},
  /* 441 */ { lrdo_USINGBMAPALLOC4RDPG, "LOGREDO:  Some storage allocated for BMap now used for RedoPage records.", fsck_debug},
  /* 442 */ { lrdo_USINGBMAPALLOC4NDFL, "LOGREDO:  Some storage allocated for BMap now used for NoDoFile records.", fsck_debug},
  /* 443 */ { lrdo_USINGBMAPALLOC4EDPG, "LOGREDO:  Some storage allocated for BMap now used for ExtendDtPage records.", fsck_debug},
  /* 444 */ { lrdo_CANTREADLOGSUP, "LOGREDO:  Unable to read Journal Log superblock.", fsck_debug},
  /* 445 */ { lrdo_CANTUPDLOGSUP, "LOGREDO:  Unable to update Journal Log superblock.", fsck_debug},
  /* 446 */ { lrdo_NEXTADDRINVALID, "LOGREDO:  Address of next log record is invalid.", fsck_debug},
  /* 447 */ { lrdo_NEXTADDROUTRANGE, "LOGREDO:  Address (0x0%x) of next log record is out of range.", fsck_debug},
  /* 448 */ { lrdo_NEXTADDRSAME, "LOGREDO:  Address (%s) of next log record is the same as address of current log record.", fsck_debug},
  /* 449 */ { lrdo_LOGWRAPPED, "LOGREDO:  The Journal Log has wrapped around and written over itself.", fsck_debug},
  /* 450 */ { lrdo_BADCOMMIT, "LOGREDO:  Invalid Commit record at 0x0%x.", fsck_debug},
  /* 451 */ { lrdo_BADMOUNT, "LOGREDO:  Invalid Mount record at 0x0%x.", fsck_debug},
  /* 452 */ { lrdo_DEVOPNREADERROR, "LOGREDO:  Device open/read error", fsck_debug},
  /* 453 */ { lrdo_BADREDOPAGE, "LOGREDO:  Invalid RedoPage record at 0x0%x.", fsck_debug},
  /* 454 */ { lrdo_BADNOREDOPAGE, "LOGREDO:  Invalid NoRedoPage record at 0x0%x.", fsck_debug},
  /* 455 */ { lrdo_BADNOREDOINOEXT, "LOGREDO:  Invalid NoRedoInoExt record at 0x0%x.", fsck_debug},
  /* 456 */ { lrdo_BADUPDATEMAP, "LOGREDO:  Invalid UpdateMap record at 0x0%x.", fsck_debug},
  /* 457 */ { lrdo_UNKNOWNTYPE, "LOGREDO:  Unrecognized log record type at 0x0%x.", fsck_debug},
  /* 458 */ { lrdo_ERRORNEEDREFORMAT, "LOGREDO:  Errors encountered imply the log is corrupt.  Reformat needed.", fsck_debug},
  /* 459 */ { lrdo_ERRORCANTCONTIN, "LOGREDO:  Errors encountered prevent logredo() from continuing.", fsck_debug},
  /* 460 */ { lrdo_ERRORCANTUPDMAPS, "LOGREDO:  Unable to update map(s).", fsck_debug},
  /* 461 */ { lrdo_ERRORCANTUPDFSSUPER, "LOGREDO:  Unable to update file system superblock.", fsck_debug},
  /* 462 */ { lrdo_CANTWRITELOGSUPER, "LOGREDO:  Unable to write to log superblock.", fsck_debug},
  /* 463 */ { lrdo_CANTREADFSSUPER, "LOGREDO:  Unable to read file system superblock.", fsck_debug},
  /* 464 */ { lrdo_FSSUPERBADMAGIC, "LOGREDO:  File system superblock has invalid magic number.", fsck_debug},
  /* 465 */ { lrdo_FSSUPERBADVERS, "LOGREDO:  File system superblock has invalid version number.", fsck_debug},
  /* 466 */ { lrdo_FSSUPERBADLOGLOC, "LOGREDO:  File system superblock has invalid log location.", fsck_debug},
  /* 467 */ { lrdo_FSSUPERBADLOGSER, "LOGREDO:  File system superblock has invalid log serial number.", fsck_debug},
  /* 468 */ { lrdo_INITMAPSFAIL, "LOGREDO:  Unable to initialize map(s).", fsck_debug},
  /* 469 */ { lrdo_READFSSUPERFAIL, "LOGREDO:  Attempt to read file system superblock failed.", fsck_debug},
  /* 470 */ { lrdo_WRITEFSSUPERFAIL, "LOGREDO:  Attempt to write file system superblock failed.", fsck_debug},
  /* 471 */ { lrdo_READFSPRIMSBFAIL, "LOGREDO:  Attempt to read file system primary superblock failed.", fsck_debug},
  /* 472 */ { lrdo_READFS2NDSBFAIL, "LOGREDO:  Attempt to read file system secondary superblock failed.", fsck_debug},
  /* 473 */ { lrdo_WRITEFSPRIMSBFAIL, "LOGREDO:  Attempt to write file system primary superblock failed.", fsck_debug},
  /* 474 */ { lrdo_WRITEFS2NDSBFAIL, "LOGREDO:  Attempt to write file system secondary superblock failed.", fsck_debug},
  /* 475 */ { lrdo_BUFFLUSHFAIL, "LOGREDO:  Attempt to flush buffers failed.", fsck_debug},
  /* 476 */ { lrdo_NOTAFSDEVNUM, "LOGREDO:  Not a valid file system device number.", fsck_debug},
  /* 477 */ { lrdo_LOGNOTINLINE1, "LOGREDO:  Journal log must be inline.", fsck_debug},
  /* 478 */ { lrdo_NOTAFSDEV, "LOGREDO:  Device is not a file system device.", fsck_debug},
  /* 479 */ { lrdo_LOGNOTINLINE2, "LOGREDO:  Journal log is not inline.", fsck_debug},
  /* 480 */ { lrdo_LOGOPEN, "LOGREDO:  Journal log is now open.  (major = %s, minor = %s)", fsck_debug},
  /* 481 */ { lrdo_ERRORONVOL, "LOGREDO:  Error in volume (d) %d.", fsck_debug},
  /* 482 */ { lrdo_OPENFAILED, "LOGREDO:  Device open failed.", fsck_debug},
  /* 483 */ { lrdo_CANTINITMAPS, "LOGREDO:  Failed attempting to initialize map(s).", fsck_debug},
  /* 484 */ { lrdo_BADDISKBLKNUM, "LOGREDO:  Invalid volume block number (0x0%llx).", fsck_debug},
  /* 485 */ { lrdo_BADINODENUM, "LOGREDO:  Invalid inode number ((d) %lld).", fsck_debug},
  /* 486 */ { lrdo_CANTREADBLK, "LOGREDO:  Failed attempt to read block 0x0%llx.", fsck_debug},
  /* 487 */ { lrdo_IOERRREADINGBLK, "LOGREDO:  I/O error attempting to read block 0x0%llx.", fsck_debug},
  /* 488 */ { lrdo_BADUPDMAPREC, "LOGREDO:  Invalid UpdateMap record (nxd = (d) %lld).", fsck_debug},
  /* 489 */ { lrdo_BADLOGSER, "LOGREDO:  Invalid log serial number.", fsck_debug},
  /* 490 */ { lrdo_FINDLOGENDFAIL, "LOGREDO:  Failed attempt to find the current end of the Journal Log.", fsck_debug},
  /* 491 */ { lrdo_LOGREADFAIL, "LOGREDO:  Failed attempting to read the Journal Log (logaddr = 0x0%x).", fsck_debug},
  /* 492 */ { lrdo_UNRECOGTYPE, "LOGREDO:  Unrecognized log record type (logaddr = 0x0%x).", fsck_debug},
  /* 493 */ { lrdo_IOERRONLOG, "LOGREDO:  I/O error on Journal Log (logaddr = 0x0%x).", fsck_debug},
  /* 494 */ { lrdo_LOGWRAP, "LOGREDO:  The Journal Log has wrapped.", fsck_debug},
  /* 495 */ { lrdo_EXTFSREADFSSUPERFAIL, "LOGREDO:  RecovExtFS: Attempt to read file system superblock failed.", fsck_debug},
  /* 496 */ { lrdo_EXTFSREADBLKMAPINOFAIL, "LOGREDO:  RecovExtFS: Attempt to read block map inode failed.", fsck_debug},
  /* 497 */ { lrdo_EXTFSREADBLKFAIL1, "LOGREDO:  RecovExtFS: Read aggregate block 0x0%llx failed (1).", fsck_debug},
  /* 498 */ { lrdo_EXTFSREADBLKFAIL2, "LOGREDO:  RecovExtFS: Read aggregate block 0x0%llx failed (2).", fsck_debug},
  /* 499 */ { lrdo_EXTFSWRITEBLKFAIL1, "LOGREDO:  RecovExtFS: Write aggregate block 0x0%x failed (1).", fsck_debug},
  /* 500 */ { lrdo_EXTFSWRITEBLKFAIL2, "LOGREDO:  RecovExtFS: Write aggregate block 0x0%llx failed (2).", fsck_debug},
  /* 501 */ { lrdo_EXTFSWRITEBLKFAIL3, "LOGREDO:  RecovExtFS: Write aggregate block 0x0%llx failed (3).", fsck_debug},
  /* 502 */ { lrdo_EXTFSREADBLKFAIL3, "LOGREDO:  RecovExtFS: Read aggregate block 0x0%llx failed (3).", fsck_debug},
  /* 503 */ { lrdo_EXTFSREADBLKFAIL4, "LOGREDO:  RecovExtFS: Read aggregate block 0x0%llx failed (4).", fsck_debug},
  /* 504 */ { lrdo_EXTFSINITLOGREDOFAIL, "LOGREDO:  RecovExtFS: Error in initLogredo().", fsck_debug},
  /* 505 */ { lrdo_EXTFSREADBLKFAIL5, "LOGREDO:  RecovExtFS: Read aggregate block 0x0%llx failed (5).", fsck_debug},
  /* 506 */ { lrdo_EXTFSWRITEBLKFAIL4, "LOGREDO:  RecovExtFS: Write aggregate block 0x0%llx failed (4).", fsck_debug},
  /* 507 */ { lrdo_EXTFSWRITEFSSUPERFAIL, "LOGREDO:  RecovExtFS: Attempt to write file system superblock failed.", fsck_debug},
  /* 508 */ { lrdo_EXTFSREADLOGSUPFAIL, "LOGREDO:  RecovExtFS: Attempt to read Journal Log superblock failed.", fsck_debug},
  /* 509 */ { lrdo_EXTFSWRITELOGSUPFAIL, "LOGREDO:  RecovExtFS: Attempt to write Journal Log superblock failed.", fsck_debug},
  /* 510 */ { lrdo_READBMAPINOFAIL, "LOGREDO:   Read Block Map inode failed.", fsck_debug},
  /* 511 */ { lrdo_READBMAPFAIL, "LOGREDO:   Read Block Map failed.", fsck_debug},
  /* 512 */ { lrdo_READIMAPINOFAIL, "LOGREDO:   Read Inode Alloc Map inode failed.", fsck_debug},
  /* 513 */ { lrdo_READIMAPFAIL, "LOGREDO:   Read Inode Alloc Map failed.", fsck_debug},
  /* 514 */ { lrdo_RBMPREADXTFAIL, "LOGREDO:   Read Block Map leftmost leaf failed.", fsck_debug},
  /* 515 */ { lrdo_RBMPREADDATFAIL, "LOGREDO:   Read Block Map data extents failed.", fsck_debug},
  /* 516 */ { lrdo_RBMPREADNXTLFFAIL, "LOGREDO:   Read Block Map next leaf failed.", fsck_debug},
  /* 517 */ { lrdo_RIMPREADXTFAIL, "LOGREDO:   Read Inode Alloc Map leftmost leaf failed.", fsck_debug},
  /* 518 */ { lrdo_RIMPREADCTLFAIL, "LOGREDO:   Read Inode Alloc Map control page failed.", fsck_debug},
  /* 519 */ { lrdo_RIMPREADNXTLFFAIL, "LOGREDO:   Read Inode Alloc Map next leaf failed.", fsck_debug},
  /* 520 */ { lrdo_RIMPREADDATFAIL, "LOGREDO:   Read Inode Alloc Map data extents failed.", fsck_debug},
  /* 521 */ { lrdo_UMPREADIMAPINOFAIL, "LOGREDO:   Read Inode Alloc Map inode failed in UpdateMaps().", fsck_debug},
  /* 522 */ { lrdo_UMPWRITEIMAPCTLFAIL, "LOGREDO:  Write Inode Alloc Map control page failed in UpdateMaps().", fsck_debug},
  /* 523 */ { lrdo_UMPREADBMAPINOFAIL, "LOGREDO:  Read Block Map inode failed in UpdateMaps().", fsck_debug},
  /* 524 */ { lrdo_UMPWRITEBMAPCTLFAIL, "LOGREDO:  Write Block Map control page failed in UpdateMaps().", fsck_debug},
  /* 525 */ { lrdo_WRIMPNOTRBLDGIMAP, "LOGREDO:  Not rebuilding the Inode Alloc Map because fsck will be doing it.", fsck_debug},
  /* 526 */ { lrdo_WRIMPRXTFAIL, "LOGREDO:  Write Inode Alloc Map, rXtree() failed.", fsck_debug},
  /* 527 */ { lrdo_WRIMPBLKWRITEFAIL, "LOGREDO:  Write block (blk=0x0%llx) failed when updating the Inode Alloc Mapl.", fsck_debug},
  /* 528 */ { lrdo_WRIMPREADLFFAIL, "LOGREDO:  Read next leaf (addr=%s) failed when updating the Inode Alloc Map.", fsck_debug},
  /* 529 */ { lrdo_WRIMPBADNPAGES, "LOGREDO:  Incorrect npages detected when updating the Inode Alloc Map.", fsck_debug},
  /* 530 */ { lrdo_WRIMPDONE, "LOGREDO:  Done updating the Inode Allocation Map.", fsck_debug},
  /* 531 */ { lrdo_WRIMPSTART, "LOGREDO:  Beginning to update the Inode Allocation Map.", fsck_debug},
  /* 532 */ { lrdo_WRBMPDONE, "LOGREDO:  Done updating the Block Map.", fsck_debug},
  /* 533 */ { lrdo_WRBMPSTART, "LOGREDO:  Beginning to update the Block Map.", fsck_debug},
  /* 534 */ { lrdo_WRBMPNOTRBLDGBMAP, "LOGREDO:  Not rebuilding the Block Map because fsck will be doing it.", fsck_debug},
  /* 535 */ { lrdo_RBLDGIMAPERROR1, "LOGREDO:  Error for pmap and inoext when rebuilding the Inode Allocation Map (1).", fsck_debug},
  /* 536 */ { lrdo_WRBMPBADMAPSIZE, "LOGREDO:  Inconsistent map size in Block Map.", fsck_debug},
  /* 537 */ { lrdo_WRBMPBADLFIDX0, "LOGREDO:  Incorrect leaf index detected (k=(d) %d, j=(d) %d, idx=(d) %d) while writing Block Map.", fsck_debug},
  /* 538 */ { lrdo_RBLDGDMAPERROR, "LOGREDO:  Error rebuilding DMap page (k=(d) %d, j=(d) %d, i=(d) %d).", fsck_debug},
  /* 539 */ { lrdo_WRBMPRXTFAIL, "LOGREDO:  rXtree() failed when called while writing Block Map.", fsck_debug},
  /* 540 */ { lrdo_WRBMPBLKWRITEFAIL, "LOGREDO:  Write block (at 0x0%llx) failed while writing Block Map.", fsck_debug},
  /* 541 */ { lrdo_WRBMPREADLFFAIL, "LOGREDO:  Read next leaf (at %s) failed while writing Block Map.", fsck_debug},
  /* 542 */ { lrdo_WRBMPBADTOTPG, "LOGREDO:  Incorrect total pages while writing Block Map.", fsck_debug},
  /* 543 */ { lrdo_UPDMPBADLFIDX, "LOGREDO:  Invalid leaf index detected while updating dmap page.", fsck_debug},
  /* 544 */ { lrdo_RXTREADLFFAIL, "LOGREDO:  rXtree() Read first leaf failed.", fsck_debug},
  /* 545 */ { lrdo_BRDBADBLOCK, "LOGREDO:  bread() Invalid block number specified (0x0%llx).", fsck_debug},
  /* 546 */ { lrdo_BRDREADBLKFAIL, "LOGREDO:  bread() Read block (0x0%llx) failed.", fsck_debug},
  /* 547 */ { lrdo_RBLDGIMAPERROR2, "LOGREDO:  Error for pmap and inoext when rebuilding the Inode Allocation Map (2).", fsck_debug},
  /* 548 */ { lrdo_DAFTUPDPGFAILED, "LOGREDO:   doAfter: updatePage failed.  (logaddr = 0x0%x, rc = (d) %d)", fsck_debug},
  /* 549 */ { lrdo_DAFTMRKBMPFAILED, "LOGREDO:   doAfter: markBmap failed.  (logaddr = 0x0%x, rc = (d) %d)", fsck_debug},
  /* 550 */ { lrdo_DEDPBREADFAILED, "LOGREDO:   doExtDtPg: bread failed.  (offset = 0x0%llx, rc = (d) %d)", fsck_debug},
  /* 551 */ { lrdo_DNRPFNDDTRTPGREDOFAIL, "LOGREDO:   doNoRedoPage: type dtpage: findPageRedo failed.  (rc = (d) %d)", fsck_debug},
  /* 552 */ { lrdo_DNRPFNDDTPGPGREDOFAIL, "LOGREDO:   doNoRedoPage: type dtroot: findPageRedo failed.  (rc = %s)", fsck_debug},
  /* 553 */ { lrdo_DNRPFNDXTRTPGREDOFAIL, "LOGREDO:   doNoRedoPage: type xtroot: findPageRedo failed.  (rc = (d) %d)", fsck_debug},
  /* 554 */ { lrdo_DNRPFNDXTPGPGREDOFAIL, "LOGREDO:   doNoRedoPage: type xtpage: findPageRedo failed.  (rc = (d) %d)", fsck_debug},
  /* 555 */ { lrdo_DNRPUNKNOWNTYPE, "LOGREDO:   doNoRedoPage: Unknown NoRedoPage record type.", fsck_debug},
  /* 556 */ { lrdo_DNRIFNDNOREDORECFAIL, "LOGREDO:   doNoRedoInoExt: findPageRedo failed.  (rc = (d) %d)", fsck_debug},
  /* 557 */ { lrdo_DUMPUNKNOWNTYPE, "LOGREDO:   doUpdateMap: Unknown updateMap record type.", fsck_debug},
  /* 558 */ { lrdo_DPRFBADSTBLENTRY, "LOGREDO:   dtpg_resetFreeList: Invalid stbl entry.", fsck_debug},
  /* 559 */ { lrdo_DPRFBADSLOTNXTIDX, "LOGREDO:   dtpg_resetFreeList: Invalid slot next index.", fsck_debug},
  /* 560 */ { lrdo_DRRFBADSTBLENTRY, "LOGREDO:   dtrt_resetFreeList: Invalid stbl entry.", fsck_debug},
  /* 561 */ { lrdo_DRRFBADSLOTNXTIDX, "LOGREDO:   dtrt_resetFreeList: Invalid slot next index.", fsck_debug},
  /* 562 */ { lrdo_MBMPBLKOUTRANGE, "LOGREDO:   markBmap: Block number(s) out of range (start=0x0%llx, length=(d)%d).", fsck_debug},
  /* 563 */ { lrdo_UPPGFNDPGREDOFAIL, "LOGREDO:   updatePage: findPageRedo failed.  (rc = (d) %d)", fsck_debug},
  /* 564 */ { lrdo_UPPGBADINODESEGOFFSET, "LOGREDO:   updatePage: type=INODE.  Invalid segment offset. (offset = (d) %d)", fsck_debug},
  /* 565 */ { lrdo_UPPGBREADFAIL1, "LOGREDO:   updatePage: bread failed (1).  (rc = (d) %d)", fsck_debug},
  /* 566 */ { lrdo_UPPGBREADFAIL2, "LOGREDO:   updatePage: bread failed (2).  (rc = (d) %d)", fsck_debug},
  /* 567 */ { lrdo_UPPGBREADFAIL3, "LOGREDO:   updatePage: bread failed (3).  (rc = (d) %d)", fsck_debug},
  /* 568 */ { lrdo_UPPGBREADFAIL4, "LOGREDO:   updatePage: bread failed (4).  (rc = (d) %d)", fsck_debug},
  /* 569 */ { lrdo_UPPGMIMPFAIL, "LOGREDO:   updatePage: markImap failed.  (rc = (d) %d)", fsck_debug},
  /* 570 */ { lrdo_UPPGMBMPFAIL, "LOGREDO:   updatePage: markBmap failed.  (rc = (d) %d)", fsck_debug},
  /* 571 */ { lrdo_UPPGDTRTRFLFAIL, "LOGREDO:   updatePage: dtrt_resetFreeList failed.  (rc = (d) %d)", fsck_debug},
  /* 572 */ { lrdo_UPPGDTPGRFLFAIL, "LOGREDO:   updatePage: dtpg_resetFreeList failed.  (rc = (d) %d)", fsck_debug},
  /* 573 */ { lrdo_UPPGSEDPFAIL, "LOGREDO:   updatePage: saveExtDtPg failed.  (rc = (d) %d)", fsck_debug},
  /* 574 */ { lrdo_FEOLPGV1FAIL, "LOGREDO:   fineEndOfLog: pageVal[1] failed (rc = (d) %d).", fsck_debug},
  /* 575 */ { lrdo_FEOLPGV2FAIL, "LOGREDO:   fineEndOfLog: pageVal[2] failed (rc = (d) %d).", fsck_debug},
  /* 576 */ { lrdo_FEOLPGV3FAIL, "LOGREDO:   fineEndOfLog: pageVal[3] failed (rc = (d) %d).", fsck_debug},
  /* 577 */ { lrdo_FEOLPGV4FAIL, "LOGREDO:   fineEndOfLog: pageVal[4] failed (rc = (d) %d).", fsck_debug},
  /* 578 */ { lrdo_FEOLPGV4AFAIL, "LOGREDO:   fineEndOfLog: pageVal[4(a)] failed (rc = (d) %d).", fsck_debug},
  /* 579 */ { lrdo_PVGETPGFAIL, "LOGREDO:   pageVal: getLogpage failed (pno = (d) %d, rc = (d) %d).", fsck_debug},
  /* 580 */ { lrdo_SLPWRITEFAIL, "LOGREDO:   setLogpage: Write log page failed (pno = (d) %d, rc = (d) %d).", fsck_debug},
  /* 581 */ { lrdo_LRLOGWRAP, "LOGREDO:   logRead: Log wrapped over itself (lognumread = (d) %d).", fsck_debug},
  /* 582 */ { lrdo_LRREADFAIL, "LOGREDO:   logRead: Read log page failed (pno = (d) %d, rc = (d) %d).", fsck_debug},
  /* 583 */ { lrdo_LRMWFAIL1, "LOGREDO:   logRead: MoveWords[1] failed (rc = (d) %d).", fsck_debug},
  /* 584 */ { lrdo_LRMWFAIL2, "LOGREDO:   logRead: MoveWords[2] failed (rc = (d) %d).", fsck_debug},
  /* 585 */ { lrdo_MWREADFAIL, "LOGREDO:   moveWords: getLogpage failed (pno = (d) %d, rc = (d) %d).", fsck_debug},
  /* 586 */ { fsck_DASDLIMITSPRIMED, "DASD Limit has been primed for directories on the volume.", fsck_debug},
  /* 587 */ { fsck_DASDUSEDPRIMED, "DASD Used has been primed for directories on the volume.", fsck_debug},
  /* 588 */ { lrdo_LRMWFAIL3, "LOGREDO:   logRead: Log data must not exceed LOGPSIZE (pno = (d) %d).", fsck_debug},
  /* 589 */ { avail_for_debug_only_589, "*undefined*", fsck_debug},
  /* 590 */ { avail_for_debug_only_590, "*undefined*", fsck_debug},
  /* 591 */ { avail_for_debug_only_591, "*undefined*", fsck_debug},
  /* 592 */ { avail_for_debug_only_592, "*undefined*", fsck_debug},
  /* 593 */ { avail_for_debug_only_593, "*undefined*", fsck_debug},
  /* 594 */ { avail_for_debug_only_594, "*undefined*", fsck_debug},
  /* 595 */ { avail_for_debug_only_595, "*undefined*", fsck_debug},
  /* 596 */ { avail_for_debug_only_596, "*undefined*", fsck_debug},
  /* 597 */ { avail_for_debug_only_597, "*undefined*", fsck_debug},
  /* 598 */ { avail_for_debug_only_598, "*undefined*", fsck_debug},
  /* 599 */ { avail_for_debug_only_599, "*undefined*", fsck_debug},
};
