# -*- coding: utf-8 -*-
# (c) 2008 Canonical Ltd.
# Author: Martin Pitt <martin.pitt@ubuntu.com>
# License: GPL v2 or later

import re, os.path, logging

from jockey.handlers import Handler

# dummy stub for xgettext
def _(x): return x

class SlModem(Handler):
    def __init__(self, backend):
        Handler.__init__(self, backend, name=_('Software modem'),
            rationale=_(
                'This driver enables the usage of many software modems, as '
                'commonly found in laptops.\n\n'
                'If this driver is not enabled, you will not be able to use '
                'your modem.'))
        self.package = 'sl-modem-daemon'

        self.modem_re = re.compile('^\s*\d+\s*\[Modem\s*\]')

    def available(self):
        '''Check /proc/asound/cards for a "Modem" card.'''

        if Handler.available(self) == False:
            return False
        
        try:
            for l in open('/proc/asound/cards'):
                if self.modem_re.match(l):
                    return True
        except IOError, e:
            logging.error('could not open /proc/asound/cards: %s' % str(e))

        return False

    def used(self):
        return self.enabled() and os.path.exists('/dev/modem')
