/* 
 *
 * $Id: k3bcdtext.h,v 1.7.2.1 2004/03/02 09:19:17 trueg Exp $
 * Copyright (C) 2003 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2004 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */


#ifndef _K3B_CDTEXT_H_
#define _K3B_CDTEXT_H_

#include <qstring.h>
#include <qvaluevector.h>


namespace K3bCdDevice
{
  struct cdtext_pack {
    unsigned char id1;
    unsigned char id2;
    unsigned char id3;
#ifdef WORDS_BIGENDIAN // __BYTE_ORDER == __BIG_ENDIAN
    unsigned char dbcc:       1;
    unsigned char blocknum:   3;
    unsigned char charpos:    4;
#else
    unsigned char charpos:    4;
    unsigned char blocknum:   3;
    unsigned char dbcc:       1;
#endif
    unsigned char data[12];
    unsigned char crc[2];
  };

  // TODO: add language stuff

  class TrackCdText
    {
      friend class CdDevice;
      
    public:
      TrackCdText() {
      }

      const QString& title() const { return m_title; }
      const QString& performer() const { return m_performer; }
      const QString& songwriter() const { return m_songwriter; }
      const QString& composer() const { return m_composer; }
      const QString& arranger() const { return m_arranger; }
      const QString& message() const { return m_message; }
      const QString& isrc() const { return m_isrc; }

      // TODO: use the real CD-TEXT charset (a modified ISO8859-1)
      void setTitle( const QString& s ) { m_title = s; fixup(m_title); }
      void setPerformer( const QString& s ) { m_performer = s; fixup(m_performer); }
      void setSongwriter( const QString& s ) { m_songwriter = s; fixup(m_songwriter); }
      void setComposer( const QString& s ) { m_composer = s; fixup(m_composer); }
      void setArranger( const QString& s ) { m_arranger = s; fixup(m_arranger); }
      void setMessage( const QString& s ) { m_message = s; fixup(m_message); }
      void setIsrc( const QString& s ) { m_isrc = s; fixup(m_isrc); }

      bool isEmpty() const {
	if( !m_title.isEmpty() )
	  return false;
	if( !m_performer.isEmpty() )
	  return false;
	if( !m_songwriter.isEmpty() )
	  return false;
	if( !m_composer.isEmpty() )
	  return false;
	if( !m_arranger.isEmpty() )
	  return false;
	if( !m_message.isEmpty() )
	  return false;
	if( !m_isrc.isEmpty() )
	  return false;

	return true;
      }

    private:
      // TODO: remove this (see above)
      void fixup( QString& s ) { s.replace( '/', "_" ); s.replace( '\"', "_" ); }

      QString m_title;
      QString m_performer;
      QString m_songwriter;
      QString m_composer;
      QString m_arranger;
      QString m_message;
      QString m_isrc;

      friend class AlbumCdText;
    };

  class AlbumCdText
    {
      friend class CdDevice;

    public:
      AlbumCdText();
      AlbumCdText( const unsigned char* data, int len );
      AlbumCdText( const QByteArray& );
      AlbumCdText( int size );

      void setRawPackData( const unsigned char*, int );
      void setRawPackData( const QByteArray& );

      QByteArray rawPackData() const;

      unsigned int count() const {
	return m_trackCdText.count();
      }

      void resize( int size ) {
	m_trackCdText.resize( size );
      }

      bool isEmpty() const {
	if( !m_title.isEmpty() )
	  return false;
	if( !m_performer.isEmpty() )
	  return false;
	if( !m_songwriter.isEmpty() )
	  return false;
	if( !m_composer.isEmpty() )
	  return false;
	if( !m_arranger.isEmpty() )
	  return false;
	if( !m_message.isEmpty() )
	  return false;
	if( !m_discId.isEmpty() )
	  return false;
	if( !m_upcEan.isEmpty() )
	  return false;
	
	for( unsigned int i = 0; i < m_trackCdText.count(); ++i )
	  if( !m_trackCdText[i].isEmpty() )
	    return false;

	return true;
      }

      void clear();

      const QString& title() const { return m_title; }
      const QString& performer() const { return m_performer; }
      const QString& songwriter() const { return m_songwriter; }
      const QString& composer() const { return m_composer; }
      const QString& arranger() const { return m_arranger; }
      const QString& message() const { return m_message; }
      const QString& discId() const { return m_discId; }
      const QString& upcEan() const { return m_upcEan; }

      // TODO: use the real CD-TEXT charset (a modified ISO8859-1)
      void setTitle( const QString& s ) { m_title = s; fixup(m_title); }
      void setPerformer( const QString& s ) { m_performer = s; fixup(m_performer); }
      void setSongwriter( const QString& s ) { m_songwriter = s; fixup(m_songwriter); }
      void setComposer( const QString& s ) { m_composer = s; fixup(m_composer); }
      void setArranger( const QString& s ) { m_arranger = s; fixup(m_arranger); }
      void setMessage( const QString& s ) { m_message = s; fixup(m_message); }
      void setDiscId( const QString& s ) { m_discId = s; fixup(m_discId); }
      void setUpcEan( const QString& s ) { m_upcEan = s; fixup(m_upcEan); }

      const TrackCdText& trackCdText( int i ) const { return m_trackCdText[i]; }
      void addTrackCdText( const TrackCdText& t ) { m_trackCdText.append(t); }

      void debug();
	
    private:
      // TODO: remove this (see above)
      void fixup( QString& s ) { s.replace( '/', "_" ); s.replace( '\"', "_" ); }

      QString m_title;
      QString m_performer;
      QString m_songwriter;
      QString m_composer;
      QString m_arranger;
      QString m_message;
      QString m_discId;
      QString m_upcEan;

      QValueVector<TrackCdText> m_trackCdText;
    };
}

#endif
