/***************************************************************************
                          broadcasteditor.h  -  description
                             -------------------
    begin                : Wen Apr 01 2005
    copyright            : (C) 2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/06/06 12:56:19 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BROADCASTEDITOR_H
#define BROADCASTEDITOR_H

#include <qpixmap.h>
#include <qfile.h>
#include <qlistbox.h>

#include "broadcasteditorui.h"
#include "channeldesc.h"



class BroadcastEditor : public BroadcastEditorUI
{
	Q_OBJECT

public:

	BroadcastEditor( QWidget *parent, QPtrList<ChannelDesc> *ch, QPtrList<ChannelDesc> *ret );
	~BroadcastEditor();

	QPtrList<ChannelDesc> *chan;
	QPtrList<ChannelDesc> *list;

public slots:

	virtual void addToList();
	virtual void resetList();
	void slotAddChannel(QListBoxItem*);

private:

	bool getChannelList();
	ChannelDesc* getChannel( const QString &name );

	QPixmap tvPix, raPix, tvcPix, racPix;

};

#endif
