/***************************************************************************
                          cdwidget.h  -  description
                             -------------------
    begin                : Wed Apr 01 2005
    copyright            : (C) 2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/07/21 19:40:31 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDWIDGET_H
#define CDWIDGET_H

#include <qlistbox.h>
#include <qpixmap.h>
#include <qptrlist.h>

#include "cddump.h"
#include "cdlisten.h"
#include "cdcleaner.h"

class CdWidget : public QWidget
{
	Q_OBJECT

public:

	CdWidget( const QString &ad, int port, int info, const QString &tspath, QWidget *parent, const char *name );
	~CdWidget();
	void setParam( const QString &ad, int port, int info, const QString &tspath );
	void enableLive( bool b );
	void playNumChannel( int num );
	void playLastChannel();
	void next();
	void previous();

	QListBox *channelsLb;

public slots:

	void stopLive();
	void pauseLiveTV();

private:

	CdDump *dump;
	CdListen *listen;
	QString cdAddress;
	int cdPort;
	int cdInfo;
	QString cdShiftDir;
	QPixmap tvPix, raPix;
	QPtrList<CdChannel> chan;
	QString fifoName;
	QString timeShiftFileName;
	CdCleaner *cleaner;
	int lastChannel;

private slots:

	void updateList( const QString &list );
	void channelSelected( const QString &name );

signals:

	void dvbOpen(const QString&, const QString&, int);
	void showPlayer();
	void dvbStop();
	void setTimeShiftFilename( const QString& );
	void isActiveBrowser( const QString& );

};
#endif
