#!/bin/sh
# Merge .po file ($file) with .pot template ($template)
# Usage: $0 $file $template

# Use "export VERBOSE=1" for debugging

file="$1"
template="$2"
if test ! -s $file; then exit 0; fi
if test ! -s $template; then exit 0; fi
if echo $file | grep ".pot$" >/dev/null 2>&1; then echo $file looks like a template, wrong argument order?; exit 1; fi
if msgmerge -q --no-wrap -o $file.tmp $file $template; then
  if test -f $file.tmp; then
    mv $file.tmp $file.new
    charsetline=`egrep "^\"Content-Type: .*/.*; charset=.*\n\"" $file.new`
    if test -z "$charsetline"; then
      charsetline="charset not declared!"
      charset="CHARSET"
    else
      charset=`echo $charsetline | sed -e "s#^.*charset=\(.*\)..\"#\1#"`
    fi
    if test "x$charset" = "xutf-8" || test "x$charset" = "xUTF-8"; then
      mv $file.new $file.tmp
      test -n "$VERBOSE" && echo fixing "$file"
      if ! perl ./msgsplit.pl < $file.tmp > $file.new; then
        echo "Splitting $file failed!"
        mv $file.tmp $file.new
      fi
    else
      echo "File $file has unsupported charset: $charsetline"
    fi
    rm -f $file.tmp
    if cmp -s $file.new $file; then
      rm $file.new
    else
      mv $file.new $file
    fi
  fi
else
  echo "Merging failed for file $file"
fi
