/***************************************************************************
                          calendarthread.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CALENDARTHREAD_H
#define CALENDARTHREAD_H

#include <qobject.h>
#include <qapplication.h>
#include <qthread.h>
#include <qmutex.h>
#include <qwaitcondition.h>

#include <synceelist.h>
#include <calendarsyncee.h>

#include "obexclient.h"
#include "irmcsyncthreadbase.h"




namespace KSync
{

	/**
	   Client Thread. The Worker OBEX client thread.
	   Note that this QObject is only accessed from the client thread. It is used
	   to report events from the working thread. This QObject will be the parent of
	   all QObjects in the working thread. It is in no way connected to the QObject
	   in the main thread.
	 */
	class CalendarThread
				: public IrMCSyncThreadBase
	{
		Q_OBJECT
	public:

		/**
		   Constructor.
		 */
		CalendarThread( QObject* );
		/**
		   Destructor.
		 */
		~CalendarThread();

	protected:

		// You have to create this functions that depends upon the syncee type (Calendar, AddressBook, etc...)

		KSync::Syncee* rawDataToSyncee(QByteArray, QStringList&);
		QByteArray syncEntryToRawData(KSync::SyncEntry*, QString&);
		KSync::Syncee* localGetEntry(const QString&);
		void localPutEntry(KSync::SyncEntry*, const QString&);


	};
}

#endif
