//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef DEVICENAMECACHE_H
#define DEVICENAMECACHE_H

#include <qobject.h>
#include <dcopobject.h>
#include <qmap.h>
//#include <qdatetime.h>
#include <libkbluetooth/deviceaddress.h>

namespace KBluetooth {
    class HciSocket;
}
class KConfig;

/**
@author Fred Schaettgen
*/
class DeviceNameCache : public QObject, virtual public DCOPObject
{
Q_OBJECT
K_DCOP
k_dcop:
    QString resolveCachedDeviceName(QString name);

    int getCachedDeviceClass(QString addrString);

    QString getCachedDeviceName(QString addrString);

public:
    DeviceNameCache(QObject *parent);
    virtual ~DeviceNameCache();

public slots:
    void slotNameRequest(int error, KBluetooth::DeviceAddress addr, QString name);
    void slotInquiryResult(KBluetooth::DeviceAddress addr, int deviceClass);
    
//private slots:
//    void slotHciEvent(unsigned char eventCode, QByteArray buf);
//    void slotHciConnectionClosed();
//    void slotHciConnect();

private:
    KConfig* m_config;
    // The keys of this map must be lower case
    // Otherwise name resolution would be case dependent
    // which will cause problems with sdp urls in KDE 3.2
    QMap<QString, KBluetooth::DeviceAddress> nameAddrMap;
    struct PeerInfo {
        int devClass;
        QString name;
        //QDateTime lastConnected;
        //QDateTime lastDiscovered;
        //QDateTime lastNameRequest;
    };
    QMap<KBluetooth::DeviceAddress, PeerInfo> addrInfoMap;
    KBluetooth::HciSocket *hciSocket;

    void loadDeviceCache();
    void storeDeviceCache();
};

#endif
