/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "mruservices.h"

#include <libkbluetooth/namecache.h>
#include <libkbluetooth/deviceaddress.h>
#include <dcopclient.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include "checkdaemon.h"

namespace KBluetoothd {
namespace MRUServices {

bool add(QString label, QStringList commandline, QString iconname, 
    const KBluetooth::DeviceAddress& addr)
{
    DCOPClient* dc = KApplication::dcopClient();
    QByteArray param;
    QDataStream paramStream(param, IO_WriteOnly);
    paramStream << label << commandline << iconname << QString(addr);
    QByteArray retData;

    QCString retType;
    if (dc->call( "kbluetoothd", "MRUServices", "mruAdd(QString,QStringList,QString,QString)",
        param, retType, retData, false))
    {
        return true;    
    }
    else {
        return false;
    }
}

bool add(QStringList commandline, const KBluetooth::DeviceAddress& addr)
{
    QString name = KApplication::kApplication()->aboutData()->programName();
    QString icon = KApplication::kApplication()->miniIconName();
    return add(name, commandline, icon, addr);
}

}
}
