/*
    This file is part of libqobex.

    Copyright (c) 2003-2004 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef CLIENT_H
#define CLIENT_H

#include <qcstring.h>
#include <qfile.h>
#include <qobject.h>

#include <qobex/qobexclient.h>

class client
  : public QObexClient {
  Q_OBJECT
public:
  client( QObexTransport * transport, QFile * f, QFile * df, bool verbose );

  void response( const QObexObject& resp );
  bool dataReq( QByteArray& data, size_t max );
  bool data( const QValueList<QByteArray>& data );
  void authenticationRequired( const QString& realm );

public slots:
  void slotPacketRecieved( QObexObject& obj );
  void slotWritingPacket( const QObexObject* obj );

private:
  QFile* mFile;
  QTextStream mDumpStream;
  bool mVerbose;
};

#endif
